/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.property.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.property.spi.PropertyPageInfo;
import javax.ide.util.MetaClass;

public final class PropertyHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-hook");
    private static final ElementName PROPERTY_PAGES = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-pages");
    private static final ElementName PROPERTY_PAGE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-page");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName OBJECT_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "object-class");
    private static final String KEY_INFO = "propertyInfo";
    private final ElementVisitor _propertyPagesVisitor = new PropertyPagesVisitor();
    private final ElementVisitor _propertyPageVisitor = new PropertyPageVisitor();
    private final ElementVisitor _labelVisitor = new LabelVisitor();
    private final ElementVisitor _objectClassVisitor = new ObjectClassVisitor();
    private Collection _propertyPageInfos = new ArrayList();

    public Collection getPropertyPageInfos() {
        return this._propertyPageInfos;
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(PROPERTY_PAGES, this._propertyPagesVisitor);
    }

    private PropertyPageInfo getInfo(ElementContext elementContext) {
        return (PropertyPageInfo)elementContext.getScopeData().get(KEY_INFO);
    }

    private final class ObjectClassVisitor
    extends ElementVisitor {
        private ObjectClassVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if (string != null && (string = string.trim()).length() > 0) {
                if (!"javax.ide.IDE".equals(string) && !"javax.ide.model.Project".equals(string)) {
                    this.log(elementEndContext, Level.SEVERE, "Must be either 'javax.ide.IDE' or 'javax.ide.model.Project'.");
                    return;
                }
                PropertyHook.this.getInfo(elementEndContext).setObjectClass(string);
            }
        }
    }

    private final class LabelVisitor
    extends I18NStringVisitor {
        private LabelVisitor() {
        }

        public void string(ElementContext elementContext, String string) {
            PropertyPageInfo propertyPageInfo = PropertyHook.this.getInfo(elementContext);
            propertyPageInfo.setLabel(string);
        }
    }

    private final class PropertyPageVisitor
    extends ElementVisitor {
        private PropertyPageVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("property-page-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'property-page-class'");
                return;
            }
            ClassLoader classLoader = (ClassLoader)elementStartContext.getScopeData().get("classLoader");
            MetaClass metaClass = new MetaClass(classLoader, string);
            PropertyPageInfo propertyPageInfo = new PropertyPageInfo();
            propertyPageInfo.setPageClass(metaClass);
            String string2 = elementStartContext.getAttributeValue("parent-page");
            propertyPageInfo.setParentPage(string2);
            elementStartContext.getScopeData().put(PropertyHook.KEY_INFO, propertyPageInfo);
            elementStartContext.registerChildVisitor(LABEL, PropertyHook.this._labelVisitor);
            elementStartContext.registerChildVisitor(OBJECT_CLASS, PropertyHook.this._objectClassVisitor);
        }

        public void end(ElementEndContext elementEndContext) {
            PropertyPageInfo propertyPageInfo = PropertyHook.this.getInfo(elementEndContext);
            if (propertyPageInfo.getLabel() == null) {
                this.log(elementEndContext, Level.SEVERE, "Label required.");
                return;
            }
            if (propertyPageInfo.getObjectClass() == null) {
                this.log(elementEndContext, Level.SEVERE, "Object class required.");
                return;
            }
            PropertyHook.this._propertyPageInfos.add(propertyPageInfo);
        }
    }

    private class PropertyPagesVisitor
    extends ElementVisitor {
        private PropertyPagesVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(PROPERTY_PAGE, PropertyHook.this._propertyPageVisitor);
        }
    }
}

