/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.ide.spi.ProviderNotFoundException;

public final class LookupProvider {
    private LookupProvider() {
    }

    public static Object lookup(ClassLoader classLoader, Class clazz) throws ProviderNotFoundException {
        Collection collection = LookupProvider.lookupAll(classLoader, clazz);
        if (collection.isEmpty()) {
            throw new ProviderNotFoundException("No provider for " + clazz);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (iterator.hasNext()) continue;
            return e;
        }
        throw new IllegalStateException();
    }

    public static Collection lookupAll(ClassLoader classLoader, Class clazz) throws ProviderNotFoundException {
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/services/" + clazz.getName());
            Collection collection = LookupProvider.lookupAll(classLoader, clazz, enumeration);
            collection.addAll(LookupProvider.lookupAll(classLoader, clazz, classLoader.getResources("meta-inf/services/" + clazz.getName())));
            return collection;
        }
        catch (IOException iOException) {
            throw new ProviderNotFoundException(clazz.getName(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection lookupAll(ClassLoader classLoader, Class clazz, Enumeration enumeration) throws ProviderNotFoundException {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            URL uRL = (URL)enumeration.nextElement();
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                        try {
                            Class<?> clazz2 = Class.forName(string, false, classLoader);
                            if (!clazz.isAssignableFrom(clazz2)) {
                                throw new ProviderNotFoundException(clazz2 + " is not correct type for service " + clazz);
                            }
                            arrayList.add(clazz2.newInstance());
                        }
                        catch (Exception exception) {
                            throw new ProviderNotFoundException("Failed to create service class " + string, exception);
                        }
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new ProviderNotFoundException("Failed to load service class " + clazz, iOException);
            }
        }
        return arrayList;
    }
}

