/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ide.util.MissingIconException;

public abstract class IconDescription {
    private URL _url;

    private IconDescription() {
    }

    public static IconDescription createInstance(final URL uRL) {
        return new IconDescription(){

            protected URL resolveURL() throws MissingIconException {
                return uRL;
            }
        };
    }

    public static IconDescription createResourceInstance(final ClassLoader classLoader, final String string, final String string2) {
        return new IconDescription(){

            protected URL resolveURL() throws MissingIconException {
                ResourceBundle resourceBundle;
                try {
                    resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    throw new MissingIconException("Resource bundle " + string + " not found.", missingResourceException);
                }
                try {
                    String string3 = resourceBundle.getString(string2);
                    if (string3 == null || string3.trim().length() == 0) {
                        throw new MissingIconException("Icon key " + string2 + " has empty value in bundle " + string);
                    }
                    Class<?> clazz = resourceBundle.getClass();
                    URL uRL = clazz.getResource(string3);
                    if (uRL == null) {
                        throw new MissingIconException("Icon path " + string3 + " does not exist. Specified by key " + string2 + " in bundle " + clazz);
                    }
                    return uRL;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new MissingIconException("Icon key " + string2 + " not defined in bundle " + string, missingResourceException);
                }
            }
        };
    }

    public static IconDescription createPathInstance(final ClassLoader classLoader, final String string) {
        return new IconDescription(){

            protected URL resolveURL() throws MissingIconException {
                URL uRL = classLoader.getResource(string);
                if (uRL == null) {
                    throw new MissingIconException("Icon path " + string + " not found.");
                }
                return uRL;
            }
        };
    }

    protected abstract URL resolveURL() throws MissingIconException;

    public URL getURL() throws MissingIconException {
        if (this._url == null) {
            this._url = this.resolveURL();
        }
        return this._url;
    }
}

