/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

public final class MetaClass {
    private String _className;
    private ClassLoader _classLoader;

    public MetaClass(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        if (string == null) {
            throw new NullPointerException("null className");
        }
        this._classLoader = classLoader;
        this._className = string;
    }

    public String getClassName() {
        return this._className;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Class toClass() throws ClassNotFoundException {
        return Class.forName(this._className, true, this._classLoader);
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.toClass().newInstance();
    }

    public String toString() {
        return "MetaClass[ classLoader=" + this._classLoader + ", className=" + this._className + "]";
    }

    public int hashCode() {
        int n = 42;
        n = 37 * n + this._className.hashCode();
        n = 37 * n + this._classLoader.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MetaClass)) {
            return false;
        }
        MetaClass metaClass = (MetaClass)object;
        return metaClass._classLoader.equals(this._classLoader) && metaClass._className.equals(this._className);
    }
}

