/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.wizard;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ide.Service;
import javax.ide.command.Context;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.MetaClass;
import javax.ide.wizard.Wizard;
import javax.ide.wizard.spi.WizardHook;

public class WizardManager
extends Service {
    private final Map _wizardInstancesById = new HashMap();

    public boolean invokeWizard(Context context, String string) {
        Wizard wizard = this.findOrCreateWizard(string);
        return wizard.invoke(context);
    }

    protected final WizardHook getWizardHook() {
        return (WizardHook)ExtensionRegistry.getExtensionRegistry().getHook(WizardHook.ELEMENT);
    }

    private MetaClass getWizardClass(String string) {
        return this.getWizardHook().getWizardInfo(string).getWizardClass();
    }

    protected final Collection getAllWizardClasses() {
        return this.getWizardHook().getAllWizardClasses();
    }

    protected final Wizard findOrCreateWizard(String string) {
        Wizard wizard = (Wizard)this._wizardInstancesById.get(string);
        if (wizard == null) {
            MetaClass metaClass = this.getWizardClass(string);
            if (metaClass == null) {
                throw new IllegalArgumentException("No such wizard: " + string);
            }
            try {
                wizard = (Wizard)metaClass.newInstance();
                this._wizardInstancesById.put(string, wizard);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to create wizard " + string);
            }
        }
        return wizard;
    }

    public static WizardManager getWizardManager() {
        try {
            return (WizardManager)WizardManager.getService(WizardManager.class);
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            providerNotFoundException.printStackTrace();
            throw new IllegalStateException("no wizard manager");
        }
    }
}

