/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.wizard.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;
import javax.ide.wizard.spi.WizardCategory;
import javax.ide.wizard.spi.WizardInfo;

public final class WizardHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard-hook");
    private static final ElementName WIZARDS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizards");
    private static final ElementName WIZARD = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard");
    private static final ElementName WIZARD_CATEGORY = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard-category");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final String KEY_WIZARD_INFO = "wizardInfo";
    private static final String KEY_CATEGORY = "wizardCategory";
    private ElementVisitor _wizardsVisitor = new WizardsVisitor();
    private ElementVisitor _wizardVisitor = new WizardVisitor();
    private ElementVisitor _labelVisitor = new LabelVisitor();
    private ElementVisitor _iconpathVisitor = new IconPathVisitor();
    private ElementVisitor _tooltipVisitor = new ToolTipVisitor();
    private ElementVisitor _wizardCategoryVisitor = new WizardCategoryVisitor();
    private final Map _wizardsByClass = new HashMap();
    private final Map _categoriesById = new HashMap();
    private final Map _categoryChildren = new HashMap();

    public WizardInfo getWizardInfo(String string) {
        WizardInfo wizardInfo = (WizardInfo)this._wizardsByClass.get(string);
        if (wizardInfo == null) {
            throw new IllegalArgumentException("Unknown wizard class " + string);
        }
        return wizardInfo;
    }

    public Collection getChildren(WizardCategory wizardCategory) {
        if (wizardCategory == null) {
            throw new NullPointerException("Null category");
        }
        return Collections.unmodifiableCollection(this.getCategoryChildren(wizardCategory));
    }

    private Collection getCategoryChildren(WizardCategory wizardCategory) {
        ArrayList arrayList = (ArrayList)this._categoryChildren.get(wizardCategory);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this._categoryChildren.put(wizardCategory, arrayList);
        }
        return arrayList;
    }

    public Collection getAllWizardClasses() {
        return Collections.unmodifiableCollection(this._wizardsByClass.keySet());
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(WIZARDS, this._wizardsVisitor);
    }

    private static WizardInfo getWizardInfo(ElementContext elementContext) {
        return (WizardInfo)elementContext.getScopeData().get(KEY_WIZARD_INFO);
    }

    private class ToolTipVisitor
    extends I18NStringVisitor {
        private ToolTipVisitor() {
        }

        protected void string(ElementContext elementContext, String string) {
            WizardHook.getWizardInfo(elementContext).setToolTip(string);
        }
    }

    private class IconPathVisitor
    extends IconVisitor {
        private IconPathVisitor() {
        }

        protected void icon(ElementContext elementContext, IconDescription iconDescription) {
            WizardHook.getWizardInfo(elementContext).setIcon(iconDescription);
        }
    }

    private class LabelVisitor
    extends I18NStringVisitor {
        private LabelVisitor() {
        }

        protected void string(ElementContext elementContext, String string) {
            WizardHook.getWizardInfo(elementContext).setLabel(string);
        }
    }

    private class WizardVisitor
    extends ElementVisitor {
        private WizardVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("wizard-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required 'wizard-class' attribute.");
                return;
            }
            String string2 = elementStartContext.getAttributeValue("category-ref");
            WizardCategory wizardCategory = WizardCategory.NONE;
            if (string2 != null && (string2 = string2.trim()).length() > 0 && (wizardCategory = (WizardCategory)WizardHook.this._categoriesById.get(string2)) == null) {
                this.log(elementStartContext, Level.WARNING, "Unknown category id '" + string2 + "'.");
                wizardCategory = WizardCategory.NONE;
            }
            MetaClass metaClass = new MetaClass((ClassLoader)elementStartContext.getScopeData().get("classLoader"), string);
            WizardInfo wizardInfo = new WizardInfo(metaClass);
            WizardHook.this.getCategoryChildren(wizardCategory).add(wizardInfo);
            wizardInfo.setCategory(wizardCategory);
            elementStartContext.getScopeData().put(WizardHook.KEY_WIZARD_INFO, wizardInfo);
            elementStartContext.registerChildVisitor(LABEL, WizardHook.this._labelVisitor);
            elementStartContext.registerChildVisitor(ICONPATH, WizardHook.this._iconpathVisitor);
            elementStartContext.registerChildVisitor(TOOLTIP, WizardHook.this._tooltipVisitor);
        }

        public void end(ElementEndContext elementEndContext) {
            WizardInfo wizardInfo = WizardHook.getWizardInfo(elementEndContext);
            WizardHook.this._wizardsByClass.put(wizardInfo.getWizardClass().getClassName(), wizardInfo);
        }
    }

    private class WizardCategoryVisitor
    extends ElementVisitor {
        private WizardCategoryVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("id");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required 'id' attribute.");
                return;
            }
            WizardCategory wizardCategory = WizardCategory.NONE;
            String string2 = elementStartContext.getAttributeValue("parent-category");
            if (string2 != null) {
                string2 = string2.trim();
                wizardCategory = (WizardCategory)WizardHook.this._categoriesById.get(string2);
                if (wizardCategory == null) {
                    this.log(elementStartContext, Level.WARNING, "Wizard category '" + string2 + "' not found.");
                    wizardCategory = WizardCategory.NONE;
                }
            }
            WizardCategory wizardCategory2 = new WizardCategory(wizardCategory, string);
            elementStartContext.getScopeData().put(WizardHook.KEY_CATEGORY, wizardCategory2);
            WizardHook.this._categoriesById.put(string, wizardCategory2);
            WizardHook.this.getCategoryChildren(wizardCategory).add(wizardCategory2);
            elementStartContext.registerChildVisitor(LABEL, new I18NStringVisitor(){

                protected void string(ElementContext elementContext, String string) {
                    WizardCategory wizardCategory = (WizardCategory)elementContext.getScopeData().get(WizardHook.KEY_CATEGORY);
                    wizardCategory.setLabel(string);
                }
            });
        }

        public void end(ElementEndContext elementEndContext) {
            WizardCategory wizardCategory = (WizardCategory)elementEndContext.getScopeData().get(WizardHook.KEY_CATEGORY);
            if (wizardCategory.getLabel() == null) {
                this.log(elementEndContext, Level.WARNING, "Missing label element for category.");
                wizardCategory.setLabel(wizardCategory.getId());
            }
        }
    }

    private class WizardsVisitor
    extends ElementVisitor {
        private WizardsVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(WIZARD, WizardHook.this._wizardVisitor);
            elementStartContext.registerChildVisitor(WIZARD_CATEGORY, WizardHook.this._wizardCategoryVisitor);
        }
    }
}

