/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class DomModel {
    public static final String DOCUMENT_CHANGED_PROPERTY = "documentChanged";
    public static final String TEXTBUFFER_MODIFIED_PROPERTY = "textBufferModified";
    public static final String PARSE_PROBLEMS_PROPERTY = "parseProblems";
    public static final String READONLY_PROPERTY = "readOnly";
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Reference _domModelRef;
    private final DomModelContext _context;
    private final Logger _logger;
    private final WhitespaceHandler _whitespaceHandler;

    static {
        $assertionsDisabled = DomModel.class.desiredAssertionStatus() ^ true;
    }

    protected DomModel(DomModelContext domModelContext) {
        this(domModelContext, null);
    }

    protected DomModel(DomModelContext domModelContext, WhitespaceHandler whitespaceHandler) {
        this.$init$();
        if (domModelContext == null) {
            throw new IllegalArgumentException("null context");
        }
        if (whitespaceHandler == null) {
            whitespaceHandler = WhitespaceHandler.getDefaultWhitespaceHandler();
        }
        this._context = domModelContext;
        this._whitespaceHandler = whitespaceHandler;
    }

    public final DomModelContext getContext() {
        return this._context;
    }

    public abstract DOMImplementation getDOMImplementation();

    public final WhitespaceHandler getWhitespaceHandler() {
        return this._whitespaceHandler;
    }

    public int getTextOffset(DomPosition domPosition) {
        return -1;
    }

    public Node getNodeAtOffset(int n) {
        return null;
    }

    public final DomPosition getDomPosition(int n) {
        return this.getDomPosition(n, false);
    }

    public DomPosition getDomPosition(int n, boolean bl) {
        return null;
    }

    public final void getTextOffsets(Node node, int[] nArray) {
        if (!$assertionsDisabled && nArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && nArray.length != 2) {
            throw new AssertionError();
        }
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        this.getTextOffsetsImpl(node, nArray);
    }

    public abstract Node getChangeTarget();

    public abstract String getTransactionDescription();

    public abstract boolean isInTopLevelTransaction();

    public abstract void addUndoableEditListener(UndoableEditListener var1);

    public abstract void removeUndoableEditListener(UndoableEditListener var1);

    public abstract Document getDocument();

    public abstract void destroyDocument();

    public abstract void forceReparse();

    public abstract void addDomChangeListener(DomModelListener var1);

    public abstract void removeDomChangeListener(DomModelListener var1);

    public abstract void addDomMutationListener(DomMutationListener var1);

    public abstract void removeDomMutationListener(DomMutationListener var1);

    public abstract int getDocChangeCount();

    public abstract void startTransaction(String var1);

    public abstract void commitTransaction();

    public abstract void rollbackTransaction();

    public boolean isReadOnly() {
        return false;
    }

    public final Logger getLogger() {
        return this._logger;
    }

    public abstract int getLockStatus();

    public abstract void acquireReadLock();

    public abstract void releaseReadLock();

    public abstract void verifyLock();

    public abstract void verifyWriteLock();

    public abstract void acquireWriteLock();

    public abstract void releaseWriteLock();

    public abstract void acquireStaleDataLock();

    public abstract void releaseStaleDataLock();

    public abstract List getCurrentDomParseProblems();

    public String toString() {
        return super.toString() + ", context=" + this.getContext();
    }

    public abstract boolean needsReparse();

    protected abstract void refreshModel(boolean var1);

    public abstract void setDocType(String var1, String var2, String var3);

    public abstract void removeDocType();

    public abstract XmlDeclarationInfo getXmlDeclarationInfo();

    public abstract void setXmlDeclarationInfo(XmlDeclarationInfo var1);

    public final FragmentParseResult parseFragment(Node node, String string) {
        return this.parseFragment(node, Collections.EMPTY_MAP, string);
    }

    public abstract FragmentParseResult parseFragment(Node var1, Map var2, String var3);

    public final void reformatSubtree(String string, Node node) {
        this.reformatSubtree(string, node, null);
    }

    public abstract void reformatSubtree(String var1, Node var2, Object var3);

    public void markCurrentUndoableEditMergable() {
    }

    public final Attr setUnspecifiedAttribute(Element element, String string, String string2, String string3) {
        this.verifyWriteLock();
        if (element == null) {
            throw new IllegalArgumentException("null owner");
        }
        int n = string2.indexOf(58);
        String string4 = n < 0 ? string2 : string2.substring(n + 1);
        Attr attr = element.getAttributeNodeNS(string, string4);
        if (attr != null) {
            throw new IllegalArgumentException("attr already set! ns=" + string + " localname=" + string4);
        }
        return this.setUnspecifiedAttributeImpl(element, string, string2, string3);
    }

    public boolean isUnspecifiedAttribute(Attr attr) {
        return false;
    }

    public final void mergeTextNodes(Text text, Text text2) {
        this.verifyWriteLock();
        if (text == null || text2 == null) {
            throw new IllegalArgumentException("null parameter not allowed");
        }
        if (text.getNextSibling() != text2) {
            throw new IllegalArgumentException("second must be next sibling of first");
        }
        this.mergeTextNodesImpl(text, text2);
    }

    public final Text splitTextNode(Text text, int n) {
        this.verifyWriteLock();
        if (n <= 0 || n >= text.getLength()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        return this.splitTextNodeImpl(text, n);
    }

    public final void dispose() {
        try {
            this.disposeImpl();
        }
        finally {
            this.getDomModelReference().clear();
        }
    }

    protected void disposeImpl() {
    }

    protected Attr setUnspecifiedAttributeImpl(Element element, String string, String string2, String string3) {
        Attr attr = element.getOwnerDocument().createAttributeNS(string, string2);
        attr.setValue(string3);
        element.setAttributeNodeNS(attr);
        return attr;
    }

    protected void getTextOffsetsImpl(Node node, int[] nArray) {
        nArray[0] = -1;
        nArray[1] = -1;
    }

    protected void mergeTextNodesImpl(Text text, Text text2) {
        text.appendData(text2.getNodeValue());
        text2.getParentNode().removeChild(text2);
    }

    protected Text splitTextNodeImpl(Text text, int n) {
        return text.splitText(n);
    }

    protected final void flushContextPendingEvents() {
        this.getContext().flushPendingEvents();
    }

    protected Logger createLogger() {
        return Logger.getLogger("oracle.bali.xml.dom");
    }

    protected final FragmentParseResult createFragmentParseResult(DocumentFragment documentFragment) {
        if (documentFragment == null) {
            return null;
        }
        return new FragmentParseResult(documentFragment);
    }

    public final Reference getDomModelReference() {
        return this._domModelRef;
    }

    void $init$() {
        this._domModelRef = new WeakReference<DomModel>(this);
        this._logger = this.createLogger();
    }

    public static final class FragmentParseResult {
        private final DocumentFragment _frag;

        protected FragmentParseResult(DocumentFragment documentFragment) {
            if (documentFragment == null) {
                throw new IllegalArgumentException("null fragment");
            }
            this._frag = documentFragment;
        }

        public DocumentFragment getDocumentFragment() {
            return this._frag;
        }
    }
}

