/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.CollectionUtils;
import org.w3c.dom.Node;

public final class DomModelEvent
extends EventObject {
    public static final int NODES_ADDED_FLAG = 1;
    public static final int NODES_REMOVED_FLAG = 2;
    public static final int NODES_MOVED_FLAG = 4;
    public static final int ATTRIBUTES_CHANGED_FLAG = 8;
    public static final int CHARACTERS_CHANGED_FLAG = 16;
    public static final int PROPERTIES_CHANGED_FLAG = 32;
    public static final int DOM_STRUCTURE_FLAGS = 7;
    public static final int DOM_TREE_FLAGS = 31;
    private final DomModel _domModel;
    private final Node _changeRoot;
    private final int _changeFlags;
    private final Map _propertyChanges;
    private final List _domChanges;
    private final NodeChangeDetails _details;

    public DomModelEvent(DomModel domModel, Node node, int n, List list, Map map, NodeChangeDetails nodeChangeDetails) {
        super(domModel);
        if (domModel == null) {
            throw new IllegalArgumentException("DOM model required");
        }
        if (nodeChangeDetails == null) {
            nodeChangeDetails = NodeChangeDetails.NO_DETAILS_AVAILABLE;
        }
        this._domModel = domModel;
        this._changeRoot = node;
        this._details = nodeChangeDetails;
        n = node == null ? (n &= 0xFFFFFFFA) : (n &= 0x1F);
        if (map != null && !map.isEmpty()) {
            this._propertyChanges = CollectionUtils.createUnmodifiableMap(map);
            n |= 0x20;
        } else {
            this._propertyChanges = Collections.EMPTY_MAP;
        }
        this._domChanges = list == null ? Collections.EMPTY_LIST : CollectionUtils.createUnmodifiableList(list);
        this._changeFlags = n;
    }

    public DomModel getDomModel() {
        return this._domModel;
    }

    public Node getChangeRoot() {
        return this._changeRoot;
    }

    public int getChangeFlags() {
        return this._changeFlags;
    }

    public final boolean isDomStructureChanged() {
        return (this.getChangeFlags() & 7) != 0;
    }

    public final boolean isDomTreeChanged() {
        return (this.getChangeFlags() & 0x1F) != 0;
    }

    public final boolean isPropertyChanged() {
        return (this.getChangeFlags() & 0x20) != 0;
    }

    public final PropertyChange getDocumentPropertyChange() {
        return this.getPropertyChange("documentChanged");
    }

    public final PropertyChange getReadOnlyPropertyChange() {
        return this.getPropertyChange("readOnly");
    }

    public final boolean isTextBufferModified() {
        PropertyChange propertyChange = this.getPropertyChange("textBufferModified");
        if (propertyChange != null) {
            return propertyChange.getNewBooleanValue();
        }
        return false;
    }

    public Map getPropertyChanges() {
        return this._propertyChanges;
    }

    public final PropertyChange getPropertyChange(String string) {
        return (PropertyChange)this.getPropertyChanges().get(string);
    }

    public final boolean containsPropertyChange(String string) {
        return this.getPropertyChanges().containsKey(string);
    }

    public List getDomChanges() {
        return this._domChanges;
    }

    public NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    public String toString() {
        int n;
        String string = super.toString();
        if (this._changeRoot != null) {
            string = string + "root: " + this._changeRoot;
        }
        if ((n = this._changeFlags) != 0) {
            string = string + "Changes:[";
            if ((n & 1) != 0) {
                string = string + "Nodes+ ";
            }
            if ((n & 2) != 0) {
                string = string + "Nodes- ";
            }
            if ((n & 4) != 0) {
                string = string + "Nodes Moved ";
            }
            if ((n & 8) != 0) {
                string = string + "Attr+- ";
            }
            if ((n & 0x10) != 0) {
                string = string + "Chars+- ";
            }
            if ((n & 0x20) != 0) {
                string = string + "Prop changed";
            }
            string = string + "]";
        }
        if (!this._propertyChanges.isEmpty()) {
            string = string + "\nproperty changes: " + this._propertyChanges;
        }
        if (!this._domChanges.isEmpty()) {
            string = string + "\nDOM changes: " + this._domChanges;
        }
        if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            string = string + "\nDetails: " + this._details;
        }
        return string;
    }
}

