/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NonAttrNodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MakeTestCaseUndoableEditListener
implements DomChangeHandler,
UndoableEditListener {
    private final StringBuffer _buffer;
    private int _nextVar;
    private static final String _DOC_VAR = "doc";

    public StringBuffer getOutput() {
        return this._buffer;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        this._line("getDomModel().startTransaction(" + this._literal(undoableEdit.getPresentationName()) + ");");
        if (undoableEdit instanceof DomChangesUndoableEdit) {
            ((DomChangesUndoableEdit)undoableEdit).processChanges(this);
        } else {
            this._line("Unknown UndoableEdit" + undoableEdit);
        }
        this._line("");
        this._line("getDomModel().commitTransaction();");
        this._line("");
    }

    public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        this._setupForNextChange(attrAddedChange);
        String string = this._localForRef("Element", attrAddedChange.getOwnerElementRef(), true);
        this._setAttr(string, attrAddedChange.getAddedAttributeClone());
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        this._setupForNextChange(attrRemovedChange);
        String string = this._localForRef("Element", attrRemovedChange.getOwnerElementRef(), true);
        Attr attr = attrRemovedChange.getRemovedAttributeClone();
        this._line(string + ".removeAttributeNS(" + this._literal(attr.getNamespaceURI()) + ", " + this._literal(DomUtils.getLocalName((Node)attr)) + ");");
    }

    public void handleAttrValueChange(AttrValueChange attrValueChange) {
        this._setupForNextChange(attrValueChange);
        String string = this._localForRef(attrValueChange.getNodeRef());
        this._line(string + ".setNodeValue(" + this._literal(attrValueChange.getNewValue()) + ");");
    }

    public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
        this._setupForNextChange(nodeInsertedChange);
        String string = this._createSubtree(nodeInsertedChange.getInsertedNodeClone());
        NonAttrNodeRef nonAttrNodeRef = (NonAttrNodeRef)nodeInsertedChange.getNodeRef();
        int[] nArray = nonAttrNodeRef.getNodePath();
        int n = nArray[nArray.length - 1];
        StringBuffer stringBuffer = new StringBuffer("new int[] {");
        int n2 = 0;
        while (n2 < nArray.length - 1) {
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[n2]);
            ++n2;
        }
        stringBuffer.append("}");
        String string2 = this._local("DomUtils.getNodeFromPath(doc, " + stringBuffer + ")");
        this._line("DomUtils.insertChildAtIndex(" + string + ", " + string2 + ", " + n + ");");
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
        this._setupForNextChange(nodeRemovedChange);
        String string = this._localForRef(nodeRemovedChange.getNodeRef());
        String string2 = this._local(string + ".getParentNode()");
        this._line(string2 + ".removeChild(" + string + ");");
    }

    public void handleNodeValueChange(NodeValueChange nodeValueChange) {
        this._setupForNextChange(nodeValueChange);
        String string = this._localForRef(nodeValueChange.getNodeRef());
        this._line(string + ".setNodeValue(" + this._literal(nodeValueChange.getNewValue()) + ");");
    }

    private String _createSubtree(Node node) {
        NamedNodeMap namedNodeMap;
        String string;
        String string2 = "Node";
        switch (node.getNodeType()) {
            case 8: {
                string = "createComment(" + this._literal(node.getNodeValue()) + ")";
                break;
            }
            case 3: {
                string = "createTextNode(" + this._literal(node.getNodeValue()) + ")";
                break;
            }
            case 1: {
                string2 = "Element";
                string = "createElementNS(" + this._literal(node.getNamespaceURI()) + ", " + this._literal(node.getNodeName()) + ")";
                break;
            }
            default: {
                string = "????? " + node;
            }
        }
        String string3 = this._local(string2, "doc." + string, "Node".equals(string2) ^ true);
        if (node.getNodeType() == 1 && (namedNodeMap = node.getAttributes()) != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                this._setAttr(string3, attr);
                ++n;
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            String string4 = this._createSubtree(node2);
            this._line(string3 + ".appendChild(" + string4 + ");");
            node2 = node2.getNextSibling();
        }
        return string3;
    }

    private void _setAttr(String string, Attr attr) {
        this._line(string + ".setAttributeNS(" + this._literal(attr.getNamespaceURI()) + ", " + this._literal(attr.getName()) + ", " + this._literal(attr.getValue()) + ");");
    }

    private void _setupForNextChange(DomChange domChange) {
        this._line("");
        this._line("// " + domChange);
    }

    private String _localForRef(NodeRef nodeRef) {
        return this._local(nodeRef.getJavaExpression(_DOC_VAR));
    }

    private String _localForRef(String string, NodeRef nodeRef, boolean bl) {
        return this._local(string, nodeRef.getJavaExpression(_DOC_VAR), bl);
    }

    private String _localForRef(String string, NodeRef nodeRef) {
        return this._localForRef(string, nodeRef, false);
    }

    private String _local(String string) {
        return this._local("Node", string);
    }

    private String _local(String string, String string2) {
        return this._local(string, string2, false);
    }

    private String _local(String string, String string2, boolean bl) {
        String string3 = this._getNextVariable();
        String string4 = bl ? "(" + string + ") " : "";
        this._line(string + " " + string3 + " = " + string4 + string2 + ";");
        return string3;
    }

    private void _line(String string) {
        if (string.length() > 0) {
            this._buffer.append("    ");
            this._buffer.append(string);
        }
        this._buffer.append("\n");
    }

    private String _literal(String string) {
        return string == null ? "null" : "\"" + string + "\"";
    }

    private String _getNextVariable() {
        String string = "node_" + this._nextVar;
        ++this._nextVar;
        return string;
    }

    void $init$() {
        this._buffer = new StringBuffer();
        this._nextVar = 0;
    }

    public MakeTestCaseUndoableEditListener() {
        this.$init$();
    }
}

