/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapNamedNodeMap
implements NamedNodeMap {
    private short _allowedNodeType;
    private Node _owner;
    private Map _storage;

    public MapNamedNodeMap(Element element, Map map) {
        this(element, 2, map);
    }

    public MapNamedNodeMap(Node node, short s, Map map) {
        if (node == null) {
            throw new IllegalArgumentException("No owner node specified");
        }
        short s2 = node.getNodeType();
        if (s2 == 1) {
            if (s != 2) {
                throw new IllegalArgumentException("Element nodes such as " + node + " can only have Attribute NamedNodeMaps");
            }
        } else if (s2 == 10) {
            if (s != 6 && s != 12) {
                throw new IllegalArgumentException("DocumentType nodes such as " + node + " can only have Entity or Notation NamedNodeMaps");
            }
        } else {
            throw new IllegalArgumentException("Owning node " + node + " can't have a NamedNodeMape");
        }
        if (map == null) {
            throw new IllegalArgumentException("No storage Map provided");
        }
        this._owner = node;
        this._allowedNodeType = s;
        this._storage = map;
    }

    public Node getNamedItem(String string) {
        return this.getKeyedItem(this.getKey(string));
    }

    public Node setNamedItem(Node node) throws DOMException {
        String string = node.getNamespaceURI();
        Object object = string != null ? QualifiedName.getQualifiedName((String)string, (String)DomUtils.getLocalName((Node)node)) : this.getKey(node.getNodeName());
        return this.setKeyedItem(object, node);
    }

    public Node removeNamedItem(String string) throws DOMException {
        return this.removeKeyedItem(this.getKey(string));
    }

    public Node item(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        for (Object k : this._storage.keySet()) {
            if (n == 0) {
                return (Node)this._storage.get(k);
            }
            --n;
        }
        throw new IllegalStateException("This should never happen");
    }

    public int getLength() {
        return this._storage.size();
    }

    public Node getNamedItemNS(String string, String string2) {
        QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
        return this.getKeyedItem(qualifiedName);
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)node.getNamespaceURI(), (String)DomUtils.getLocalName((Node)node));
        return this.setKeyedItem(qualifiedName, node);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
        return this.removeKeyedItem(qualifiedName);
    }

    protected Node getKeyedItem(Object object) {
        return (Node)this._storage.get(object);
    }

    protected Node removeKeyedItem(Object object) {
        Object v;
        try {
            v = this._storage.remove(object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new DOMException(7, "Can't remove " + object + " from " + this);
        }
        if (v == null) {
            throw new DOMException(8, object + " not found in " + this);
        }
        return (Node)v;
    }

    protected Node setKeyedItem(Object object, Node node) {
        Element element;
        if (node.getOwnerDocument() != this._owner.getOwnerDocument()) {
            throw new DOMException(4, node + " is not in " + this._owner + "'s document");
        }
        if (this._owner.getNodeType() == 1 && (element = ((Attr)node).getOwnerElement()) != null && element != this._owner) {
            throw new DOMException(10, node + " can not be added to " + this._owner + " because it already belongs to " + element);
        }
        if (node.getNodeType() != this._allowedNodeType) {
            throw new DOMException(3, node + "s not allowed in " + this._owner + "'s NamedNodeMap");
        }
        try {
            Node node2 = this._storage.put(object, node);
            return node2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new DOMException(7, "Can't set " + node + " on " + this);
        }
    }

    protected boolean hasKeyedItem(Object object) {
        return this._storage.containsKey(object);
    }

    protected final Object getKey(String string) {
        String string2 = string;
        if (this._allowedNodeType == 2) {
            string2 = QualifiedName.getQualifiedName((String)string);
        }
        return string2;
    }

    protected final Map getStorage() {
        return this._storage;
    }

    protected final Node getOwner() {
        return this._owner;
    }
}

