/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Map;
import oracle.bali.xml.dom.MapNamedNodeMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.standalone.ProxyingAttr;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ProxyingMapNamedNodeMap
extends MapNamedNodeMap {
    private static final Node _REMOVED_NODE = DummyNode.INSTANCE;
    private int _removedCount;
    private int _overrideCount;
    private NamedNodeMap _proxiedMap;

    public ProxyingMapNamedNodeMap(Element element, Map map, NamedNodeMap namedNodeMap) {
        super(element, map);
        this.$init$();
        if (namedNodeMap == null) {
            throw new IllegalArgumentException("No map to proxy specified");
        }
        this._proxiedMap = namedNodeMap;
    }

    public Node getNamedItem(String string) {
        Node node = super.getNamedItem(string);
        if (node != null) {
            if (node == _REMOVED_NODE) {
                return null;
            }
            return node;
        }
        Node node2 = this._proxiedMap.getNamedItem(string);
        if (node2 != null) {
            ++this._overrideCount;
            Attr attr = this._createAttrProxy((Attr)node2);
            super.setNamedItem(attr);
            return attr;
        }
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        return this._removeKeyedItem(this.getKey(string), this._proxiedMap.getNamedItem(string));
    }

    public Node setNamedItem(Node node) throws DOMException {
        Node node2 = super.setNamedItem(node);
        if (node2 == null && (node2 = this._proxiedMap.getNamedItem(node.getNodeName())) != null) {
            ++this._overrideCount;
        }
        return node2;
    }

    public Node item(int n) {
        boolean bl;
        if (n < 0) {
            return null;
        }
        NamedNodeMap namedNodeMap = this._proxiedMap;
        int n2 = namedNodeMap.getLength();
        if (this._overrideCount + this._removedCount != n2) {
            int n3 = 0;
            while (n3 < n2) {
                Node node = namedNodeMap.item(n3);
                if (super.getNamedItemNS(node.getNamespaceURI(), DomUtils.getLocalName((Node)node)) == null) {
                    ++this._overrideCount;
                    super.setNamedItem(this._createAttrProxy((Attr)node));
                }
                ++n3;
            }
        }
        boolean bl2 = bl = this._removedCount != 0;
        if (!bl) {
            return super.item(n);
        }
        Map map = this.getStorage();
        if (!map.isEmpty()) {
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                if (v == _REMOVED_NODE) continue;
                if (n == 0) {
                    return (Node)v;
                }
                --n;
            }
        }
        return null;
    }

    public int getLength() {
        return super.getLength() + this._proxiedMap.getLength() - this._removedCount * 2 - this._overrideCount;
    }

    public Node getNamedItemNS(String string, String string2) {
        Node node = super.getNamedItemNS(string, string2);
        if (node != null) {
            if (node == _REMOVED_NODE) {
                return null;
            }
            return node;
        }
        Node node2 = this._proxiedMap.getNamedItemNS(string, string2);
        if (node2 != null) {
            ++this._overrideCount;
            return super.setNamedItem(this._createAttrProxy((Attr)node2));
        }
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
        return this._removeKeyedItem(qualifiedName, this._proxiedMap.getNamedItemNS(string, string2));
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        Node node2 = super.setNamedItemNS(node);
        if (node2 == null && (node2 = this._proxiedMap.getNamedItemNS(node.getNamespaceURI(), DomUtils.getLocalName((Node)node))) != null) {
            ++this._overrideCount;
        }
        return node2;
    }

    private Node _removeKeyedItem(Object object, Node node) {
        Node node2 = this.getKeyedItem(object);
        if (node2 == _REMOVED_NODE || node2 == null && node == null) {
            throw new DOMException(8, "Not attribute named " + object + " found in " + this.getOwner());
        }
        if (node2 != null) {
            --this._overrideCount;
        }
        ++this._removedCount;
        return this.getStorage().put(object, _REMOVED_NODE);
    }

    private Attr _createAttrProxy(Attr attr) {
        return new ProxyingAttr((Element)this.getOwner(), attr);
    }

    void $init$() {
        this._removedCount = 0;
        this._overrideCount = 0;
    }
}

