/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;

public class SynchronizedDomModel
extends BaseDomModel {
    private final DomModel _peerDomModel;

    public SynchronizedDomModel(DomModel domModel) {
        super(domModel.getContext(), domModel.getWhitespaceHandler());
        this._peerDomModel = domModel;
        domModel.addDomMutationListener(new MutationListener(null));
    }

    public DOMImplementation getDOMImplementation() {
        return this._peerDomModel.getDOMImplementation();
    }

    public boolean isReadOnly() {
        return this._peerDomModel.isReadOnly();
    }

    protected void acquireReadLockDirectly() {
        this._peerDomModel.acquireReadLock();
    }

    protected void releaseReadLockDirectly() {
        this._peerDomModel.releaseReadLock();
    }

    protected void acquireWriteLockDirectly() {
        this._peerDomModel.acquireWriteLock();
    }

    protected void releaseWriteLockDirectly() {
        this._peerDomModel.releaseWriteLock();
    }

    public int getLockStatus() {
        return this._peerDomModel.getLockStatus();
    }

    public List getCurrentDomParseProblems() {
        return this._peerDomModel.getCurrentDomParseProblems();
    }

    public DomModel.FragmentParseResult parseFragment(Node node, Map map, String string) {
        Node node2 = this._getPeerNode(node);
        DomModel.FragmentParseResult fragmentParseResult = this._peerDomModel.parseFragment(node2, map, string);
        if (fragmentParseResult == null) {
            return null;
        }
        DocumentFragment documentFragment = fragmentParseResult.getDocumentFragment();
        if (documentFragment == null) {
            return fragmentParseResult;
        }
        this.acquireReadLock();
        try {
            DocumentFragment documentFragment2 = (DocumentFragment)this.getDocument().importNode(documentFragment, true);
            DomModel.FragmentParseResult fragmentParseResult2 = this.createFragmentParseResult(documentFragment2);
            this.releaseReadLock();
            return fragmentParseResult2;
        }
        catch (Throwable throwable) {
            this.releaseReadLock();
            throw throwable;
        }
    }

    protected UndoableEdit setDocTypeImpl(String string, String string2, String string3) {
        this._peerDomModel.setDocType(string, string2, string3);
        return null;
    }

    protected UndoableEdit removeDocTypeImpl() {
        this._peerDomModel.removeDocType();
        return null;
    }

    protected void refreshModel(boolean bl) {
        this._peerDomModel.refreshModel(bl);
    }

    public boolean needsReparse() {
        return false;
    }

    protected void getTextOffsetsImpl(Node node, int[] nArray) {
        Node node2 = this._getPeerNode(node);
        if (node2 != null) {
            this._peerDomModel.getTextOffsetsImpl(node, nArray);
        } else {
            super.getTextOffsetsImpl(node, nArray);
        }
    }

    protected int getTextOffsetImpl(DomPosition domPosition) {
        Node node = domPosition.getTargetNode();
        Node node2 = this._getPeerNode(node);
        if (node2 != null) {
            return this._peerDomModel.getTextOffset(domPosition.createDomPosition(node2));
        }
        return -1;
    }

    protected Document getDocumentImpl() {
        Document document;
        Document document2 = this.getDocumentInternal();
        if (document2 == null && (document = this._peerDomModel.getDocument()) != null) {
            this._peerDomModel.acquireReadLock();
            try {
                document2 = this._clonePeerDocument(document);
            }
            finally {
                this._peerDomModel.releaseReadLock();
            }
            this.replaceDocument(document2);
        }
        return document2;
    }

    protected void handlePeerMutation(DomChange domChange, MutationEvent mutationEvent) {
        System.out.println("Peer Mutation:" + mutationEvent);
    }

    private Node _getPeerNode(Node node) {
        if (node == null) {
            return null;
        }
        return this.getContext().remapNode(this._peerDomModel.getDocument(), node);
    }

    private Document _clonePeerDocument(Document document) {
        String string;
        DOMImplementation dOMImplementation = this.getDOMImplementation();
        DocumentType documentType = document.getDoctype();
        DocumentType documentType2 = null;
        if (documentType != null) {
            documentType2 = dOMImplementation.createDocumentType(documentType.getNamespaceURI(), documentType.getPublicId(), documentType.getSystemId());
        }
        String string2 = document.getPrefix();
        String string3 = string = document.getLocalName();
        if (string2 != null) {
            string3 = string2 + ":" + string;
        }
        Document document2 = dOMImplementation.createDocument(document.getNamespaceURI(), string3, documentType2);
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() != 10) {
                Node node2 = document2.importNode(node, true);
                document2.appendChild(node2);
            }
            ++n2;
        }
        return document2;
    }

    static DomModel ra$_peerDomModel(SynchronizedDomModel synchronizedDomModel) {
        return synchronizedDomModel._peerDomModel;
    }

    static void mav$replaceDocument(SynchronizedDomModel synchronizedDomModel, Document document) {
        synchronizedDomModel.replaceDocument(document);
    }

    private class MutationListener
    implements DomChangeHandler,
    DomMutationListener {
        public void domMutated(DomModel domModel, DomChange domChange, MutationEvent mutationEvent) {
            if (domChange != null) {
                try {
                    domChange.process(this);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    LogRecord logRecord = new LogRecord(Level.SEVERE, "Unexpected Exception Synchronizing");
                    logRecord.setThrown(throwable);
                    SynchronizedDomModel.this.getLogger().log(logRecord);
                }
            } else if (mutationEvent == null) {
                SynchronizedDomModel.mav$replaceDocument(SynchronizedDomModel.this, null);
            } else {
                SynchronizedDomModel.this.handlePeerMutation(domChange, mutationEvent);
            }
        }

        public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
            Element element = attrAddedChange.getOwnerElement(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Element element2 = (Element)SynchronizedDomModel.this.getContext().remapNode(SynchronizedDomModel.this.getDocument(), element);
            if (element2 != null) {
                DomUtils.addAttr((Element)element2, (Attr)attrAddedChange.getAddedAttributeClone());
            }
        }

        public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
            Element element = attrRemovedChange.getOwnerElement(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Element element2 = (Element)SynchronizedDomModel.this.getContext().remapNode(SynchronizedDomModel.this.getDocument(), element);
            if (element2 != null) {
                DomUtils.removeAttr((Element)element2, (Attr)attrRemovedChange.getRemovedAttributeClone());
            }
        }

        public void handleAttrValueChange(AttrValueChange attrValueChange) {
            Document document = SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument();
            Element element = attrValueChange.getOwnerElement(document);
            Element element2 = (Element)SynchronizedDomModel.this.getContext().remapNode(SynchronizedDomModel.this.getDocument(), element);
            if (element2 != null) {
                Attr attr = attrValueChange.getChangedAttr(document);
                element2.setAttributeNS(attr.getNamespaceURI(), DomUtils.getLocalName((Node)attr), attrValueChange.getNewValue());
            }
        }

        public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
            Node node;
            Node node2;
            Document document = SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument();
            Document document2 = SynchronizedDomModel.this.getDocument();
            Node node3 = nodeInsertedChange.getNodeRef().getCorrespondingNode(document);
            Node node4 = node3.getNextSibling();
            DomModelContext domModelContext = SynchronizedDomModel.this.getContext();
            if (node4 != null) {
                node2 = domModelContext.remapNode(document2, node4);
                if (node2 == null) {
                    return;
                }
                node = node2.getParentNode();
            } else {
                node2 = null;
                node = domModelContext.remapNode(document2, node3.getParentNode());
                if (node == null) {
                    return;
                }
            }
            Node node5 = document2.importNode(node3, true);
            node.insertBefore(node5, node2);
        }

        public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
            Node node = nodeRemovedChange.getNodeRef().getCorrespondingNode(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Node node2 = SynchronizedDomModel.this.getContext().remapNode(SynchronizedDomModel.this.getDocument(), node);
            if (node2 != null) {
                node2.getParentNode().removeChild(node2);
            }
        }

        public void handleNodeValueChange(NodeValueChange nodeValueChange) {
            Node node = nodeValueChange.getNodeRef().getCorrespondingNode(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Node node2 = SynchronizedDomModel.this.getContext().remapNode(SynchronizedDomModel.this.getDocument(), node);
            if (node2 != null) {
                node2.setNodeValue(nodeValueChange.getNewValue());
            }
        }

        private MutationListener() {
        }

        MutationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

