/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

public final class XmlDeclarationInfo {
    public static final Float VERSION_1_0 = new Float(1.0f);
    public static final XmlDeclarationInfo SUITABLE_DEFAULT = new XmlDeclarationInfo(VERSION_1_0, "UTF-8", null);
    private final Float _version;
    private final String _encoding;
    private final Boolean _standalone;

    public XmlDeclarationInfo(Float f, String string, Boolean bl) {
        this._version = f;
        this._encoding = string;
        this._standalone = bl;
    }

    public Float getVersion() {
        return this._version;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Boolean getStandalone() {
        return this._standalone;
    }

    public StringBuffer getAsXml() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml ");
        if (this._version != null) {
            XmlDeclarationInfo._addField(stringBuffer, "version", this._version);
            XmlDeclarationInfo._addField(stringBuffer, "encoding", this._encoding);
            if (this._standalone != null) {
                XmlDeclarationInfo._addField(stringBuffer, "standalone", Boolean.TRUE.equals(this._standalone) ? "yes" : "no");
            }
        }
        stringBuffer.append("?>");
        return stringBuffer;
    }

    public String toString() {
        return this.getAsXml().toString();
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        n ^= XmlDeclarationInfo._hash(this._version);
        n ^= XmlDeclarationInfo._hash(this._encoding);
        return n ^= XmlDeclarationInfo._hash(this._standalone);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        XmlDeclarationInfo xmlDeclarationInfo = (XmlDeclarationInfo)object;
        return XmlDeclarationInfo._eq(this._version, xmlDeclarationInfo._version) && XmlDeclarationInfo._eq(this._encoding, xmlDeclarationInfo._encoding) && XmlDeclarationInfo._eq(this._standalone, xmlDeclarationInfo._standalone);
    }

    private static void _addField(StringBuffer stringBuffer, String string, Object object) {
        if (object != null) {
            stringBuffer.append(string);
            stringBuffer.append("=\"");
            stringBuffer.append(object);
            stringBuffer.append("\" ");
        }
    }

    private static boolean _eq(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private static int _hash(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }
}

