/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.base.DomModelTransaction;
import oracle.bali.xml.dom.base.RedoHandler;
import oracle.bali.xml.dom.base.RootDomModelTransaction;
import oracle.bali.xml.dom.base.UndoHandler;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.tracking.TrackingEventHandler;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class BaseDomModel
extends DomModel {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final DocumentChangeListener _DOM_LISTENER;
    private final SafeListenerManager _undoListeners;
    private final SafeListenerManager _mutationListeners;
    private final DomChangeHandler _undoHandler;
    private final DomChangeHandler _redoHandler;
    private volatile RootDomModelTransaction _rootTransaction;
    private volatile transient DomModelTransaction _currTransaction;
    private transient boolean _currentEditMergable;
    private Document _document;
    private boolean _sendReadOnlyPropChangeASAP;

    protected BaseDomModel(DomModelContext domModelContext) {
        this(domModelContext, null);
    }

    protected BaseDomModel(DomModelContext domModelContext, WhitespaceHandler whitespaceHandler) {
        super(domModelContext, whitespaceHandler);
        this.$init$();
    }

    public DOMImplementation getDOMImplementation() {
        Document document = this.getDocument();
        if (document != null) {
            return document.getImplementation();
        }
        return DomUtils.getDOMImplementation();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this._undoListeners.addListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this._undoListeners.removeListener(undoableEditListener);
    }

    public final int getTextOffset(DomPosition domPosition) {
        this.verifyLock();
        if (this._rootTransaction.hasModifications()) {
            return -1;
        }
        return this.getTextOffsetImpl(domPosition);
    }

    public final Node getNodeAtOffset(int n) {
        this.verifyLock();
        if (this._rootTransaction.hasModifications()) {
            return null;
        }
        return this.getNodeAtOffsetImpl(n);
    }

    public final DomPosition getDomPosition(int n, boolean bl) {
        this.verifyLock();
        if (this._rootTransaction.hasModifications()) {
            return null;
        }
        return this.getDomPositionImpl(n, bl);
    }

    public Node getChangeTarget() {
        this.verifyLock();
        return this._currTransaction.getCommittedChangeTarget();
    }

    public String getTransactionDescription() {
        this.verifyLock();
        return this._currTransaction.getDescription();
    }

    public boolean isInTopLevelTransaction() {
        this.verifyLock();
        return this._currTransaction.getParent() == this._rootTransaction;
    }

    public void addDomChangeListener(DomModelListener domModelListener) {
        this._currTransaction.addDomChangeListener(domModelListener);
    }

    public final void acquireStaleDataLock() {
        this.acquireWriteLockDirectly();
    }

    public final void releaseStaleDataLock() {
        this.releaseWriteLockDirectly();
    }

    public void removeDomChangeListener(DomModelListener domModelListener) {
        this._currTransaction.removeDomChangeListener(domModelListener);
    }

    public void addDomMutationListener(DomMutationListener domMutationListener) {
        this._mutationListeners.addListener(domMutationListener);
    }

    public void removeDomMutationListener(DomMutationListener domMutationListener) {
        this._mutationListeners.removeListener(domMutationListener);
    }

    public final Document getDocument() {
        this.verifyLock();
        return this.getDocumentImpl();
    }

    public int getDocChangeCount() {
        this.acquireReadLock();
        try {
            int n = this._rootTransaction.getChangeCount();
            this.releaseReadLock();
            return n;
        }
        catch (Throwable throwable) {
            this.releaseReadLock();
            throw throwable;
        }
    }

    public void startTransaction(String string) {
        this.acquireWriteLock();
        this.getLogger().log(Level.FINE, "startTransaction: {0}", string);
        this._currTransaction = this._currTransaction.startNestedTransaction(string);
        if (this.isInTopLevelTransaction()) {
            this._currentEditMergable = false;
        }
    }

    public void commitTransaction() {
        this.getLogger().fine("commitTransaction");
        try {
            this._currTransaction = this._currTransaction.commit();
        }
        finally {
            this._finishCommitOrRollback();
        }
    }

    public void rollbackTransaction() {
        this.getLogger().fine("rollbackTransaction");
        try {
            this._currTransaction = this._currTransaction.rollback();
        }
        finally {
            this._finishCommitOrRollback();
        }
    }

    private void _finishCommitOrRollback() {
        boolean bl = this._sendReadOnlyPropChangeASAP;
        this.releaseWriteLock();
        if (bl && this._notInTransaction()) {
            this._deliverReadOnlyPropertyChange();
        }
    }

    public final void acquireReadLock() {
        this.acquireReadLockDirectly();
        if (this.needsReparse()) {
            this.releaseReadLockDirectly();
            this.acquireWriteLockDirectly();
            this.refreshModel(false);
            this.acquireReadLockDirectly();
            this.releaseWriteLockDirectly();
        }
    }

    public final void releaseReadLock() {
        this.releaseReadLockDirectly();
    }

    public final void acquireWriteLock() {
        if (this.getLockStatus() == 1) {
            this.handleLockUpgradeAttempt(new IllegalStateException("lock upgrade attempt on " + this));
        }
        this.acquireWriteLockDirectly();
        this.refreshModel(false);
    }

    public final void releaseWriteLock() {
        this.releaseWriteLockDirectly();
    }

    public void forceReparse() {
        this.acquireWriteLockDirectly();
        try {
            this.refreshModel(true);
        }
        finally {
            this.releaseWriteLockDirectly();
        }
    }

    public abstract int getLockStatus();

    public final void verifyLock() {
        switch (this.getLockStatus()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.handleMissingLock(new IllegalStateException());
            }
        }
    }

    public final void verifyWriteLock() {
        if (this.getLockStatus() != 2) {
            this.handleMissingWriteLock(new IllegalStateException());
        }
    }

    public void destroyDocument() {
        this.replaceDocument(null);
    }

    public final void setDocType(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("invalid qname: " + string);
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        this._verifyNotInTransaction();
        this.acquireWriteLock();
        try {
            UndoableEdit undoableEdit = this.setDocTypeImpl(string, string2, string3);
            if (undoableEdit != null) {
                this.__addEdit(undoableEdit);
                this.flushContextPendingEvents();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public final void removeDocType() {
        this._verifyNotInTransaction();
        this.acquireWriteLock();
        try {
            UndoableEdit undoableEdit = this.removeDocTypeImpl();
            if (undoableEdit != null) {
                this.__addEdit(undoableEdit);
                this.flushContextPendingEvents();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public XmlDeclarationInfo getXmlDeclarationInfo() {
        return null;
    }

    public final void setXmlDeclarationInfo(XmlDeclarationInfo xmlDeclarationInfo) {
        this._verifyNotInTransaction();
        this.acquireWriteLock();
        try {
            UndoableEdit undoableEdit = this.setXmlDeclarationInfoImpl(xmlDeclarationInfo);
            if (undoableEdit != null) {
                this.__addEdit(undoableEdit);
                this.flushContextPendingEvents();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    static {
        $assertionsDisabled = BaseDomModel.class.desiredAssertionStatus() ^ true;
    }

    public final void reformatSubtree(String string, Node node, Object object) {
        this._verifyNotInTransaction();
        this.acquireReadLock();
        try {
            Document document = this.getDocument();
            if (document == null || document.getFirstChild() == null) {
                this.releaseReadLock();
                return;
            }
            if (node == null) {
                node = document;
            } else if (document != DomUtils.getOwnerDocument((Node)node) || !DomUtils.isInDocumentHierarchy((Node)node)) {
                throw new IllegalArgumentException("node passed to reformatSubtree not in document!");
            }
        }
        finally {
            this.releaseReadLock();
        }
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        this.reformatSubtreeImpl(string, node, object);
        this.flushContextPendingEvents();
    }

    public void markCurrentUndoableEditMergable() {
        this.verifyWriteLock();
        if (this._notInTransaction()) {
            throw new IllegalStateException("must be in transaction!");
        }
        this._currentEditMergable = true;
    }

    final void __addEdit(UndoableEdit undoableEdit) {
        this.handleUndoableEditHook(undoableEdit);
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
        Iterator iterator = this._undoListeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((UndoableEditListener)iterator.next()).undoableEditHappened(undoableEditEvent);
            }
            catch (Throwable throwable) {
                this.getLogger().log(Level.SEVERE, "BaseDomModel.__addEdit", throwable);
            }
        }
    }

    protected abstract UndoableEdit removeDocTypeImpl();

    protected abstract UndoableEdit setDocTypeImpl(String var1, String var2, String var3);

    protected UndoableEdit setXmlDeclarationInfoImpl(XmlDeclarationInfo xmlDeclarationInfo) {
        return null;
    }

    protected void reformatSubtreeImpl(String string, Node node, Object object) {
    }

    protected abstract void acquireWriteLockDirectly();

    protected abstract void releaseWriteLockDirectly();

    protected abstract void acquireReadLockDirectly();

    protected abstract void releaseReadLockDirectly();

    protected final void handleMissingLock(IllegalStateException illegalStateException) {
        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Read lock required, but not held. Model={0}", (Object)this, (Throwable)illegalStateException);
        this._nagToLogWindow(illegalStateException, "missing read lock");
    }

    protected final void handleMissingWriteLock(IllegalStateException illegalStateException) {
        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Write lock required, but not held. Model={0}", (Object)this, (Throwable)illegalStateException);
        this._nagToLogWindow(illegalStateException, "missing write lock");
    }

    protected final void handleLockUpgradeAttempt(IllegalStateException illegalStateException) {
        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Attempt to upgrade read lock to write lock. This leads to deadlocks. Model={0}", (Object)this, (Throwable)illegalStateException);
        this._nagToLogWindow(illegalStateException, "upgrade attempt");
    }

    private void _nagToLogWindow(IllegalStateException illegalStateException, String string) {
    }

    protected abstract Document getDocumentImpl();

    protected void startUndoTransaction() {
        if (this._currTransaction != this._rootTransaction) {
            throw new IllegalStateException("Nested Transaction Open");
        }
        this.getLogger().fine("startUndoTransaction");
        this.acquireWriteLock();
        this._currTransaction = this._rootTransaction.startUndoTransaction();
    }

    protected void startRedoTransaction() {
        if (this._currTransaction != this._rootTransaction) {
            throw new IllegalStateException("Nested Transaction Open");
        }
        this.getLogger().fine("startRedoTransaction");
        this.acquireWriteLock();
        this._currTransaction = this._rootTransaction.startRedoTransaction();
    }

    protected int getTextOffsetImpl(DomPosition domPosition) {
        return -1;
    }

    protected Node getNodeAtOffsetImpl(int n) {
        return null;
    }

    protected DomPosition getDomPositionImpl(int n, boolean bl) {
        return null;
    }

    protected void handleUncommittedMutationEventHook(DomChange domChange, MutationEvent mutationEvent, boolean bl) {
        this.fireDomMutationEvent(domChange, mutationEvent);
    }

    protected void fireDomMutationEvent(DomChange domChange, MutationEvent mutationEvent) {
        if (!this._mutationListeners.isEmpty()) {
            Iterator iterator = this._mutationListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    DomMutationListener domMutationListener = (DomMutationListener)iterator.next();
                    domMutationListener.domMutated(this, domChange, mutationEvent);
                }
                catch (Exception exception) {
                    this.getLogger().log(Level.SEVERE, "Unexpected exception in Mutation Listener:", exception);
                }
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChange propertyChange = new PropertyChange(string, object, object2);
        this._rootTransaction.fireSubtreeChanged(null, 0, Collections.EMPTY_LIST, Collections.singletonMap(string, propertyChange), null, false);
    }

    protected void handleChangeRollbackPreHook(DomChange domChange) {
    }

    protected void handleChangeRollbackPostHook(DomChange domChange) {
    }

    protected void handleUndoableEditHook(UndoableEdit undoableEdit) {
    }

    protected void handleUndoOccuredPreHook(DomChangesUndoableEdit domChangesUndoableEdit) {
    }

    protected void handleUndoOccuredPostHook(DomChangesUndoableEdit domChangesUndoableEdit) {
    }

    protected void handleRedoOccuredPreHook(DomChangesUndoableEdit domChangesUndoableEdit) {
    }

    protected void handleRedoOccuredPostHook(DomChangesUndoableEdit domChangesUndoableEdit) {
    }

    protected final Document getDocumentInternal() {
        return this._document;
    }

    protected final void replaceDocument(Document document) {
        Document document2 = null;
        this.verifyWriteLock();
        document2 = this._document;
        if (document == document2) {
            return;
        }
        try {
            this.__removeDocListeners();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.getLogger().log(Level.SEVERE, "unexpected throwable", throwable);
        }
        this._document = document;
        if (this._currTransaction != this._rootTransaction) {
            throw new IllegalStateException("in transaction during replaceDocument!");
        }
        this._rootTransaction = new RootDomModelTransaction(this, this._rootTransaction);
        this._currTransaction = this._rootTransaction;
        this.__addDocListeners();
        this.fireDomMutationEvent(null, null);
        this._rootTransaction.fireEntireDocumentChangedEvent(Collections.singletonMap("documentChanged", new PropertyChange("documentChanged", document2, document)));
    }

    protected final void handleReadOnlyStatusChange() {
        if (this._notInTransaction()) {
            this._queueDeliveryOfReadOnlyPropertyChange();
        } else {
            this._sendReadOnlyPropChangeASAP = true;
        }
    }

    protected Map getExtraPropertyChanges(Node node, int n, boolean bl) {
        return null;
    }

    protected final int getLockStatus(ReadWriteLock readWriteLock) {
        if (readWriteLock.isWriteLockHeld()) {
            return 2;
        }
        if (readWriteLock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    void __removeDocListeners() {
        BaseDomModel.__removeDocListeners((EventTarget)((Object)this._document), this._DOM_LISTENER);
    }

    static void __removeDocListeners(EventTarget eventTarget, EventListener eventListener) {
        if (eventTarget != null) {
            eventTarget.removeEventListener("DOMNodeInserted", eventListener, false);
            eventTarget.removeEventListener("DOMNodeRemoved", eventListener, false);
            eventTarget.removeEventListener("DOMAttrModified", eventListener, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", eventListener, false);
        }
    }

    void __addDocListeners() {
        BaseDomModel.__addDocListeners((EventTarget)((Object)this._document), this._DOM_LISTENER);
    }

    static void __addDocListeners(EventTarget eventTarget, EventListener eventListener) {
        if (eventTarget != null) {
            eventTarget.addEventListener("DOMNodeInserted", eventListener, false);
            eventTarget.addEventListener("DOMNodeRemoved", eventListener, false);
            eventTarget.addEventListener("DOMAttrModified", eventListener, false);
            eventTarget.addEventListener("DOMCharacterDataModified", eventListener, false);
        }
    }

    boolean __getCurrentUndoableEditMergable() {
        return this._currentEditMergable;
    }

    DomChangeHandler __getUndoHandler() {
        return this._undoHandler;
    }

    DomChangeHandler __getRedoHandler() {
        return this._redoHandler;
    }

    private void _queueDeliveryOfReadOnlyPropertyChange() {
        1 var1_1 = new 1("read-only change delivery thread for " + this);
        var1_1.setPriority(10);
        var1_1.start();
    }

    private void _deliverReadOnlyPropertyChange() {
        this.acquireWriteLock();
        try {
            this._verifyNotInTransaction();
            this._sendReadOnlyPropChangeASAP = false;
            Boolean bl = this.isReadOnly();
            this.firePropertyChange("readOnly", null, bl);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void _verifyNotInTransaction() {
        if (!this._notInTransaction()) {
            throw new IllegalStateException("in transaction when not allowed! " + this);
        }
    }

    private boolean _notInTransaction() {
        return this._currTransaction == this._rootTransaction;
    }

    void $init$() {
        this._DOM_LISTENER = new DocumentChangeListener(null);
        this._undoListeners = new SafeListenerManager();
        this._mutationListeners = new SafeListenerManager();
        this._undoHandler = new UndoHandler(this);
        this._redoHandler = new RedoHandler(this);
        this._rootTransaction = new RootDomModelTransaction(this);
        this._currTransaction = this._rootTransaction;
        this._currentEditMergable = false;
        this._sendReadOnlyPropChangeASAP = false;
    }

    static void mav$_deliverReadOnlyPropertyChange(BaseDomModel baseDomModel) {
        baseDomModel._deliverReadOnlyPropertyChange();
    }

    static DomModelTransaction ra$_currTransaction(BaseDomModel baseDomModel) {
        return baseDomModel._currTransaction;
    }

    public final class 1
    extends Thread {
        public void run() {
            BaseDomModel.mav$_deliverReadOnlyPropertyChange(BaseDomModel.this);
        }

        public 1(String string) {
            super(string);
        }
    }

    private class DocumentChangeListener
    implements EventListener {
        public void handleEvent(Event event) {
            BaseDomModel.this.verifyWriteLock();
            try {
                BaseDomModel.ra$_currTransaction(BaseDomModel.this).handleMutationEvent(event);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                BaseDomModel.this.getLogger().log(Level.SEVERE, "BaseDomModel$DocumentChangeListener", throwable);
            }
        }

        private DocumentChangeListener() {
        }

        DocumentChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class LockAssertingTrackingEventHandler
    extends TrackingEventHandler {
        public void handleWrite(Node node) {
            BaseDomModel.this.verifyWriteLock();
        }

        public void handleRead(Node node) {
            BaseDomModel.this.verifyLock();
        }

        private LockAssertingTrackingEventHandler() {
        }
    }
}

