/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.base.ChangeRecord;
import oracle.bali.xml.dom.base.DomModelTransaction;
import oracle.bali.xml.dom.base.NCDImpl;
import oracle.bali.xml.dom.base.RemovedSubtreeListener;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

class ChildDomModelTransaction
extends DomModelTransaction {
    private DomModelTransaction _parent;
    private String _description;
    private Node _changeTarget;
    private int _changeFlags;
    private NodeChangeDetails _details;
    private final LinkedList _mutationChanges;
    private final LinkedList _removedSubtreeListeners;

    ChildDomModelTransaction(BaseDomModel baseDomModel, DomModelTransaction domModelTransaction, String string) {
        super(baseDomModel);
        this.$init$();
        if (domModelTransaction == null) {
            throw new IllegalArgumentException();
        }
        this._parent = domModelTransaction;
        this._description = string;
    }

    protected final Node getChangeTarget() {
        return this._changeTarget;
    }

    protected final int getChangeFlags() {
        return this._changeFlags;
    }

    public List getMutationChanges() {
        return this._mutationChanges;
    }

    public NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    public String getDescription() {
        return this._description;
    }

    public DomModelTransaction commit() {
        DomModelTransaction domModelTransaction = this.getParent();
        if (domModelTransaction == null) {
            throw new IllegalStateException("No transaction started");
        }
        domModelTransaction.commitChild(this.getChangeIncrement());
        this._parent = null;
        return domModelTransaction;
    }

    public boolean hasModifications() {
        return !this._mutationChanges.isEmpty() || super.hasModifications();
    }

    public String toString() {
        return super.toString() + "desc=" + this._description + ", parent=" + this._parent;
    }

    protected DomModelTransaction getParent() {
        return this._parent;
    }

    protected int getChangeIncrement() {
        return this._changeTarget != null ? 1 : 0;
    }

    protected boolean modifiesUndoStack() {
        return true;
    }

    public Node getCommittedChangeTarget() {
        ChildDomModelTransaction childDomModelTransaction = this.getChild();
        if (childDomModelTransaction != null) {
            return DomUtils.lowestCommonAncestor((Node)this._changeTarget, (Node)childDomModelTransaction.getCommittedChangeTarget());
        }
        return this._changeTarget;
    }

    protected void updateChangeTarget(ChildDomModelTransaction childDomModelTransaction, int n) {
        Node node = childDomModelTransaction.getChangeTarget();
        if (node != null) {
            this._mutationChanges.add(childDomModelTransaction.getMutationChanges());
            if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
                NodeChangeDetails nodeChangeDetails = childDomModelTransaction.getNodeChangeDetails();
                this._details = nodeChangeDetails == NodeChangeDetails.NO_DETAILS_AVAILABLE ? NodeChangeDetails.NO_DETAILS_AVAILABLE : this._details.addDetails(nodeChangeDetails);
            }
            if (this._changeTarget != null && DomUtils.isInDocumentHierarchy((Node)this._changeTarget)) {
                node = DomUtils.lowestCommonAncestor((Node)this._changeTarget, (Node)node);
            }
            this._removedSubtreeListeners.addAll(childDomModelTransaction._removedSubtreeListeners);
            if (this._description == null) {
                this._description = childDomModelTransaction.getDescription();
            }
            this._changeTarget = node;
            this._changeFlags |= childDomModelTransaction.getChangeFlags();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMutationEventHook(Node node, int n, ChangeRecord changeRecord, MutationEvent mutationEvent) {
        DomChange domChange = changeRecord.getChange();
        Node node2 = changeRecord.getAssociatedNode();
        this.getModel().handleUncommittedMutationEventHook(domChange, mutationEvent, this.modifiesUndoStack());
        ChildDomModelTransaction childDomModelTransaction = this;
        synchronized (childDomModelTransaction) {
            this._changeTarget = DomUtils.lowestCommonAncestor((Node)this._changeTarget, (Node)node);
            this._changeFlags |= n;
        }
        this._mutationChanges.add(changeRecord);
        if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            NCDImpl nCDImpl = (NCDImpl)this._details;
            nCDImpl.__processChange(changeRecord);
        }
        domChange.process(new 1(this, node2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomModelTransaction rollback() {
        DomModelTransaction domModelTransaction;
        ChildDomModelTransaction childDomModelTransaction = this;
        synchronized (childDomModelTransaction) {
            domModelTransaction = this._parent;
            this._parent = null;
            if (domModelTransaction == null) {
                throw new IllegalStateException("No transaction started");
            }
            for (RemovedSubtreeListener removedSubtreeListener : this._removedSubtreeListeners) {
                removedSubtreeListener.dispose();
            }
            domModelTransaction.rollbackChild();
            BaseDomModel baseDomModel = this.getModel();
            baseDomModel.__removeDocListeners();
            this.rollbackChanges(this._mutationChanges);
            baseDomModel.__addDocListeners();
        }
        return domModelTransaction;
    }

    void $init$() {
        this._details = new NCDImpl();
        this._mutationChanges = new LinkedList();
        this._removedSubtreeListeners = new LinkedList();
    }

    static LinkedList ra$_removedSubtreeListeners(ChildDomModelTransaction childDomModelTransaction) {
        return childDomModelTransaction._removedSubtreeListeners;
    }

    static DomModelTransaction ra$_parent(ChildDomModelTransaction childDomModelTransaction) {
        return childDomModelTransaction._parent;
    }

    final class 1
    implements DomChangeHandler {
        private final /* synthetic */ Node v$changedNode;
        final /* synthetic */ ChildDomModelTransaction this$0;

        public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
            ChildDomModelTransaction childDomModelTransaction = this.this$0;
            while (childDomModelTransaction != null) {
                Iterator iterator = ChildDomModelTransaction.ra$_removedSubtreeListeners(childDomModelTransaction).iterator();
                while (iterator.hasNext()) {
                    RemovedSubtreeListener removedSubtreeListener = (RemovedSubtreeListener)iterator.next();
                    if (!removedSubtreeListener.isRemovedNodeInHierarchyNow()) continue;
                    iterator.remove();
                    removedSubtreeListener.dispose();
                }
                childDomModelTransaction = ChildDomModelTransaction.ra$_parent(childDomModelTransaction) instanceof ChildDomModelTransaction ? (ChildDomModelTransaction)ChildDomModelTransaction.ra$_parent(childDomModelTransaction) : null;
            }
        }

        public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
            ChildDomModelTransaction.ra$_removedSubtreeListeners(this.this$0).add(new RemovedSubtreeListener(this.v$changedNode, this.this$0.getModel().getLogger()));
        }

        public void handleNodeValueChange(NodeValueChange nodeValueChange) {
        }

        public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        }

        public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        }

        public void handleAttrValueChange(AttrValueChange attrValueChange) {
        }

        public 1(ChildDomModelTransaction childDomModelTransaction, Node node) {
            this.v$changedNode = node;
            this.this$0 = childDomModelTransaction;
        }
    }
}

