/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import java.lang.ref.Reference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelHolder;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.base.ChangeRecord;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.javatools.logging.LogUtils;

class DomChangesUndoableEditImpl
extends DomChangesUndoableEdit
implements DomModelHolder {
    private boolean _allowAddEdit;
    private final Reference _modelRef;
    private final String _description;

    public DomChangesUndoableEditImpl(BaseDomModel baseDomModel, String string, List list) {
        this(DomChangesUndoableEditImpl._flattenToArray(list), baseDomModel, string);
    }

    public DomChangesUndoableEditImpl(BaseDomModel baseDomModel, DomChange domChange) {
        this(new DomChange[]{domChange}, baseDomModel, DomChangesUndoableEditImpl._createDescription(baseDomModel, domChange));
    }

    private DomChangesUndoableEditImpl(DomChange[] domChangeArray, BaseDomModel baseDomModel, String string) {
        super(domChangeArray);
        this._description = string;
        this._allowAddEdit = baseDomModel.__getCurrentUndoableEditMergable() && this._allChangesCanMergeTogether();
        this._modelRef = baseDomModel.getDomModelReference();
    }

    public DomModel getDomModel() {
        return this._getModel();
    }

    public void undo() throws CannotUndoException {
        BaseDomModel baseDomModel = this._getModel();
        if (baseDomModel != null) {
            baseDomModel.handleUndoOccuredPreHook(this);
        }
        super.undo();
        if (baseDomModel != null) {
            baseDomModel.startUndoTransaction();
            try {
                this.processChangesInReverse(baseDomModel.__getUndoHandler());
                baseDomModel.handleUndoOccuredPostHook(this);
                baseDomModel.commitTransaction();
            }
            catch (Throwable throwable) {
                this._catchInUndoRedo(throwable, "undo", baseDomModel);
            }
        }
        this._allowAddEdit = false;
    }

    public void redo() throws CannotRedoException {
        BaseDomModel baseDomModel = this._getModel();
        if (baseDomModel != null) {
            baseDomModel.handleRedoOccuredPreHook(this);
        }
        super.redo();
        if (baseDomModel != null) {
            baseDomModel.startRedoTransaction();
            try {
                this.processChanges(baseDomModel.__getRedoHandler());
                baseDomModel.handleRedoOccuredPostHook(this);
                baseDomModel.commitTransaction();
            }
            catch (Throwable throwable) {
                this._catchInUndoRedo(throwable, "redo", baseDomModel);
            }
        }
    }

    public String getPresentationName() {
        return this._description;
    }

    protected boolean canAddEdit(DomChangesUndoableEdit domChangesUndoableEdit) {
        DomChangesUndoableEditImpl domChangesUndoableEditImpl = (DomChangesUndoableEditImpl)domChangesUndoableEdit;
        if (!this._allowAddEdit || !domChangesUndoableEditImpl._allowAddEdit) {
            return false;
        }
        BaseDomModel baseDomModel = this._getModel();
        BaseDomModel baseDomModel2 = domChangesUndoableEditImpl._getModel();
        if (baseDomModel == null || baseDomModel != baseDomModel2) {
            return false;
        }
        return super.canAddEdit(domChangesUndoableEdit);
    }

    private BaseDomModel _getModel() {
        return (BaseDomModel)this._modelRef.get();
    }

    private static DomChange[] _flattenToArray(List list) {
        int n = DomChangesUndoableEditImpl._countItems(list);
        DomChange[] domChangeArray = new DomChange[n];
        int n2 = 0;
        DomChangesUndoableEditImpl._addItems(list, domChangeArray, n2);
        return domChangeArray;
    }

    private static int _addItems(List list, DomChange[] domChangeArray, int n) {
        for (Object e : list) {
            if (e instanceof List) {
                n = DomChangesUndoableEditImpl._addItems((List)e, domChangeArray, n);
                continue;
            }
            domChangeArray[n] = ((ChangeRecord)e).getChange();
            ++n;
        }
        return n;
    }

    private static int _countItems(List list) {
        int n = 0;
        for (Object e : list) {
            if (e instanceof List) {
                n += DomChangesUndoableEditImpl._countItems((List)e);
                continue;
            }
            ++n;
        }
        return n;
    }

    private void _catchInUndoRedo(Throwable throwable, String string, BaseDomModel baseDomModel) {
        LogUtils.log((Logger)baseDomModel.getLogger(), (Level)Level.SEVERE, (String)"Exception in {0} of transaction {1} on {2}", (Object[])new Object[]{string, this.getPresentationName(), baseDomModel}, (Throwable)throwable);
        baseDomModel.rollbackTransaction();
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
    }

    private boolean _allChangesCanMergeTogether() {
        int n = this.getChangeCount();
        if (n == 0) {
            return false;
        }
        if (n > 1) {
            DomChange domChange = this.getChange(0);
            int n2 = 1;
            while (n2 < n) {
                DomChange domChange2 = this.getChange(n2);
                if (!domChange.canMergeWith(domChange2)) {
                    return false;
                }
                domChange = domChange2;
                ++n2;
            }
        }
        return true;
    }

    private static String _createDescription(BaseDomModel baseDomModel, DomChange domChange) {
        return baseDomModel.getContext().getTranslatedString("DOM_MODEL.OUT_OF_TRANSACTION_CHANGE");
    }
}

