/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModelEvent;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.base.ChangeRecord;
import oracle.bali.xml.dom.base.ChildDomModelTransaction;
import oracle.bali.xml.dom.base.InTransactionChangeRollbackHandler;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationEvent;

public abstract class DomModelTransaction {
    private SafeListenerManager _changeListeners;
    private ChildDomModelTransaction _child;
    private final BaseDomModel _model;

    DomModelTransaction(BaseDomModel baseDomModel) {
        this._model = baseDomModel;
    }

    public final BaseDomModel getModel() {
        return this._model;
    }

    public final Document getDocument() {
        return this.getModel().getDocument();
    }

    public ChildDomModelTransaction startNestedTransaction(String string) {
        ChildDomModelTransaction childDomModelTransaction = new ChildDomModelTransaction(this._model, this, string);
        this.setNestedTransaction(childDomModelTransaction);
        return childDomModelTransaction;
    }

    protected void setNestedTransaction(ChildDomModelTransaction childDomModelTransaction) {
        if (this._child != null) {
            throw new IllegalStateException("Transaction already open");
        }
        this._child = childDomModelTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitChild(int n) {
        int n2;
        Node node;
        ChildDomModelTransaction childDomModelTransaction;
        DomModelTransaction domModelTransaction = this;
        synchronized (domModelTransaction) {
            childDomModelTransaction = this._child;
            if (childDomModelTransaction == null) {
                throw new IllegalStateException("Parent has no child transaction to commit");
            }
            try {
                this._child = null;
                this.updateChangeTarget(childDomModelTransaction, n);
                node = this.getChangeTarget();
                n2 = this.getChangeFlags();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (RuntimeException runtimeException) {
                this._child = childDomModelTransaction;
                this.getModel().getLogger().log(Level.WARNING, "Unexpected Exception!", runtimeException);
                throw runtimeException;
            }
        }
        this.fireSubtreeChanged(node, n2, this._createDomChangeList(childDomModelTransaction.getMutationChanges()), null, childDomModelTransaction.getNodeChangeDetails());
    }

    protected void rollbackChild() {
        if (this._child == null) {
            throw new IllegalStateException("Parent has no child transaction to rollback");
        }
        this._child = null;
    }

    protected Node getChangeTarget() {
        return this._child.getChangeTarget();
    }

    protected int getChangeFlags() {
        return this._child.getChangeFlags();
    }

    protected void updateChangeTarget(ChildDomModelTransaction childDomModelTransaction, int n) {
    }

    public abstract DomModelTransaction commit();

    public abstract DomModelTransaction rollback();

    protected abstract DomModelTransaction getParent();

    protected ChildDomModelTransaction getChild() {
        return this._child;
    }

    public Node getCommittedChangeTarget() {
        if (this._child != null) {
            return this._child.getCommittedChangeTarget();
        }
        return null;
    }

    public String getDescription() {
        if (this._child != null) {
            return this._child.getDescription();
        }
        return null;
    }

    public void addDomChangeListener(DomModelListener domModelListener) {
        if (this._changeListeners == null) {
            this._changeListeners = new SafeListenerManager();
        }
        this._changeListeners.addListener(domModelListener);
    }

    public void removeDomChangeListener(DomModelListener domModelListener) {
        this._changeListeners.removeListener(domModelListener);
    }

    public boolean hasModifications() {
        if (this._child != null) {
            return this._child.hasModifications();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferListeners(DomModelTransaction domModelTransaction) {
        DomModelTransaction domModelTransaction2 = this;
        synchronized (domModelTransaction2) {
            this._changeListeners = domModelTransaction._changeListeners;
            domModelTransaction._changeListeners = null;
        }
    }

    public void handleMutationEvent(Event event) {
        int n;
        DomChange domChange;
        Node node;
        Logger logger = this.getLogger();
        if (this._child != null) {
            logger.severe("Child transaction open");
            throw new IllegalStateException("Child transaction open");
        }
        MutationEvent mutationEvent = (MutationEvent)event;
        Node node2 = (Node)((Object)mutationEvent.getTarget());
        Node node3 = mutationEvent.getRelatedNode();
        String string = mutationEvent.getType();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(DomUtils.getEventDebugMsg((MutationEvent)mutationEvent));
        }
        if ("DOMNodeInserted".equals(string) && node2.getNodeType() == 1 && node2.getParentNode() == this.getDocument()) {
            int n2 = 0;
            Node node4 = this.getDocument().getFirstChild();
            while (node4 != null) {
                if (node4.getNodeType() == 1) {
                    ++n2;
                }
                node4 = node4.getNextSibling();
            }
            if (n2 > 1) {
                throw new IllegalStateException("Got element inserted event for element with document as its parent and found there to be " + n2 + " root elements!");
            }
        }
        if ("DOMAttrModified".equals(string)) {
            Attr attr;
            node = attr = (Attr)mutationEvent.getRelatedNode();
            node3 = node2;
            switch (mutationEvent.getAttrChange()) {
                case 2: {
                    domChange = new AttrAddedChange(attr);
                    break;
                }
                case 3: {
                    domChange = new AttrRemovedChange(attr, node3);
                    break;
                }
                case 1: {
                    String string2 = mutationEvent.getNewValue();
                    String string3 = mutationEvent.getPrevValue();
                    if (string2 == string3 || string2 != null && string2.equals(string3)) {
                        domChange = null;
                        break;
                    }
                    domChange = new AttrValueChange(attr, string3, string2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid mutation event: " + mutationEvent);
                }
            }
            n = 8;
        } else if ("DOMCharacterDataModified".equals(string)) {
            String string4;
            node3 = node2;
            node = node3;
            n = 16;
            String string5 = mutationEvent.getNewValue();
            domChange = string5 == (string4 = mutationEvent.getPrevValue()) || string5 != null && string5.equals(string4) ? null : new NodeValueChange(node2, string4, string5);
        } else if ("DOMNodeRemoved".equals(string)) {
            node = node2;
            domChange = new NodeRemovedChange(node2);
            n = 2;
        } else if ("DOMNodeInserted".equals(string)) {
            node = node2;
            domChange = new NodeInsertedChange(node2);
            n = 1;
        } else {
            throw new IllegalStateException("Invalid mutation event: " + mutationEvent);
        }
        if (domChange != null) {
            this.handleMutationEventHook(node3, n, new ChangeRecord(domChange, node), mutationEvent);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finer("  " + domChange);
            }
            NodeChangeDetails nodeChangeDetails = null;
            this.fireSubtreeChanged(node3, n, Collections.singletonList(domChange), null, nodeChangeDetails);
        }
    }

    protected abstract void handleMutationEventHook(Node var1, int var2, ChangeRecord var3, MutationEvent var4);

    protected void rollbackChanges(List list) {
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Object e = listIterator.previous();
            if (e instanceof List) {
                this.rollbackChanges((List)e);
                continue;
            }
            if (!(e instanceof ChangeRecord)) continue;
            ChangeRecord changeRecord = (ChangeRecord)e;
            DomChange domChange = changeRecord.getChange();
            Node node = changeRecord.getAssociatedNode();
            domChange.process(new InTransactionChangeRollbackHandler(this._model, node));
        }
    }

    protected final void fireSubtreeChanged(Node node, int n, List list, Map map, NodeChangeDetails nodeChangeDetails) {
        this.fireSubtreeChanged(node, n, list, map, nodeChangeDetails, this.getModel().isInTopLevelTransaction() ^ true);
    }

    protected void fireSubtreeChanged(Node node, int n, List list, Map map, NodeChangeDetails nodeChangeDetails, boolean bl) {
        if (this._changeListeners == null || this._changeListeners.isEmpty()) {
            return;
        }
        DomModelEvent domModelEvent = this.createDomChangeEvent(node, n, list, map = PropertyChange.mergePropertyChangeMaps(map, this.getModel().getExtraPropertyChanges(node, n, bl), null), nodeChangeDetails);
        if (domModelEvent == null) {
            return;
        }
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DomModel firing event: {0}", domModelEvent);
        }
        Iterator iterator = this._changeListeners.iterator();
        while (iterator.hasNext()) {
            DomModelListener domModelListener = (DomModelListener)iterator.next();
            try {
                domModelListener.modelChanged(domModelEvent);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.getLogger().log(Level.WARNING, "Exception caught during DomModel event dispatch:", throwable);
            }
        }
    }

    protected final DomModelEvent createDomChangeEvent(Node node, int n, List list, Map map, NodeChangeDetails nodeChangeDetails) {
        if (n == 0 && (map == null || map.isEmpty()) && list.isEmpty()) {
            return null;
        }
        return new DomModelEvent(this.getModel(), node, n, list, map, nodeChangeDetails);
    }

    protected final Logger getLogger() {
        return this.getModel().getLogger();
    }

    private List _createDomChangeList(List list) {
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList(list.size());
        this._addDomChangesToList(list, arrayList);
        return arrayList;
    }

    private void _addDomChangesToList(List list, List list2) {
        for (Object e : list) {
            if (e instanceof List) {
                this._addDomChangesToList((List)e, list2);
                continue;
            }
            if (e instanceof ChangeRecord) {
                ChangeRecord changeRecord = (ChangeRecord)e;
                list2.add(changeRecord.getChange());
                continue;
            }
            throw new IllegalStateException("Invalid item in changeRecords list! item=" + e);
        }
    }
}

