/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.base.UndoHandler;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InTransactionChangeRollbackHandler
extends UndoHandler {
    private final Node _associatedNode;

    InTransactionChangeRollbackHandler(BaseDomModel baseDomModel, Node node) {
        super(baseDomModel);
        this._associatedNode = node;
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        if (this._associatedNode != null) {
            Element element = attrRemovedChange.getOwnerElement(this.getDocument());
            this.preHook(attrRemovedChange);
            element.setAttributeNodeNS((Attr)this._associatedNode);
            this.postHook(attrRemovedChange);
        } else {
            super.handleAttrRemovedChange(attrRemovedChange);
        }
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
        if (this._associatedNode != null) {
            this.preHook(nodeRemovedChange);
            nodeRemovedChange.getNodeRef().putCorrespondingNode(this.getDocument(), this._associatedNode);
            this.postHook(nodeRemovedChange);
        } else {
            super.handleNodeRemovedChange(nodeRemovedChange);
        }
    }

    protected void preHook(DomChange domChange) {
        super.preHook(domChange);
        this.getModel().handleChangeRollbackPreHook(domChange);
    }

    protected void postHook(DomChange domChange) {
        super.postHook(domChange);
        this.getModel().handleChangeRollbackPostHook(domChange);
    }
}

