/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.base.ChangeRecord;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class NCDImpl
extends NodeChangeDetails
implements DomChangeHandler {
    private final Set _added;
    private final Set _changed;
    private final Set _removed;
    private final Set _moved;
    private final Map _elemToPriorAttrMap;
    private final Map _nodeToPriorValue;
    private final Set _addedImm;
    private final Set _removedImm;
    private final Set _changedImm;
    private final Set _movedImm;
    static final /* synthetic */ boolean $assertionsDisabled;
    private transient Node _changedNodeTemp;

    NCDImpl() {
        this.$init$();
    }

    public Set getAddedNodes() {
        return this._addedImm;
    }

    public Set getRemovedNodes() {
        return this._removedImm;
    }

    public Set getChangedNodes() {
        return this._changedImm;
    }

    public Set getMovedNodes() {
        return this._movedImm;
    }

    public Map getPriorAttributeValues(Node node) {
        Map map = (Map)this._elemToPriorAttrMap.get(node);
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public String getPriorNodeValue(Node node) {
        return (String)this._nodeToPriorValue.get(node);
    }

    public NodeChangeDetails addDetails(NodeChangeDetails nodeChangeDetails) {
        if (nodeChangeDetails == null) {
            return this;
        }
        NCDImpl nCDImpl = this._getCopyImpl();
        Iterator iterator = nodeChangeDetails.getAddedNodes().iterator();
        while (iterator.hasNext()) {
            nCDImpl._nodeInserted((Node)iterator.next());
        }
        iterator = nodeChangeDetails.getRemovedNodes().iterator();
        while (iterator.hasNext()) {
            nCDImpl._nodeRemoved((Node)iterator.next());
        }
        iterator = nodeChangeDetails.getMovedNodes().iterator();
        while (iterator.hasNext()) {
            nCDImpl._nodeMoved((Node)iterator.next());
        }
        for (Node node : nodeChangeDetails.getChangedNodes()) {
            nCDImpl._nodeChanged(node, nodeChangeDetails.getPriorNodeValue(node));
            Map map = nodeChangeDetails.getPriorAttributeValues(node);
            for (Map.Entry entry : map.entrySet()) {
                nCDImpl._attrValueChangeImpl((Element)node, (QualifiedName)entry.getKey(), (String)entry.getValue());
            }
        }
        return nCDImpl;
    }

    public NodeChangeDetails getCopy() {
        return this._getCopyImpl();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("{ ");
        this._s(stringBuffer, "added", this._added);
        this._s(stringBuffer, "removed", this._removed);
        this._s(stringBuffer, "changed", this._changed);
        this._s(stringBuffer, "moved", this._moved);
        for (Node node : this._changed) {
            Map map = this._getPriorAttributeValuesImpl(node);
            if (map.isEmpty()) continue;
            this._out(stringBuffer, "attrs for " + node.getNodeName(), map);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void _nodeInserted(Node node) {
        if (this._moved.contains(node)) {
            return;
        }
        if (this._removed.remove(node)) {
            this._nodeMoved(node);
        } else if (!this._isDescendent(this._added, node, true)) {
            this._added.add(node);
        }
        this._updateChildrenInInsertedSubtree(node);
    }

    private void _nodeRemoved(Node node) {
        this._moved.remove(node);
        if (!this._added.remove(node) && !this._isDescendent(this._added, node, false)) {
            this._removed.add(node);
        }
        this._updateChildrenInRemovedSubtree(node);
    }

    private void _nodeChanged(Node node, String string) {
        boolean bl;
        boolean bl2 = bl = this._isDescendent(this._added, node, true) && !this._isDescendent(this._moved, node, true);
        if (!bl) {
            this._changed.add(node);
            this._providePriorNodeValueIfNeeded(node, string);
        }
    }

    private void _providePriorNodeValueIfNeeded(Node node, String string) {
        if (string != null && !this._nodeToPriorValue.containsKey(node)) {
            this._nodeToPriorValue.put(node, string);
        }
    }

    private void _nodeMoved(Node node) {
        this._moved.add(node);
        this._added.remove(node);
        this._removed.remove(node);
    }

    private void _attrValueChange(Attr attr, String string, String string2) {
        Element element = attr.getOwnerElement();
        this._nodeChanged(element, null);
        this._attrValueChangeImpl(element, DomUtils.getQualifiedName((Node)attr), string);
    }

    private NCDImpl _getCopyImpl() {
        NCDImpl nCDImpl = new NCDImpl();
        nCDImpl._added.addAll(this._added);
        nCDImpl._changed.addAll(this._changed);
        nCDImpl._removed.addAll(this._removed);
        nCDImpl._moved.addAll(this._moved);
        nCDImpl._nodeToPriorValue.putAll(this._nodeToPriorValue);
        for (Map.Entry entry : this._elemToPriorAttrMap.entrySet()) {
            nCDImpl._elemToPriorAttrMap.put(entry.getKey(), new HashMap((Map)entry.getValue()));
        }
        return nCDImpl;
    }

    private Map _getPriorAttributeValuesImpl(Node node) {
        Map map = (Map)this._elemToPriorAttrMap.get(node);
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    private void _s(StringBuffer stringBuffer, String string, Set set) {
        if (!set.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(set);
            int n = 0;
            while (n < arrayList.size()) {
                Node node = (Node)arrayList.get(n);
                arrayList.set(n, node.getNodeName());
                ++n;
            }
            this._out(stringBuffer, string, arrayList);
        }
    }

    private void _out(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(object);
        stringBuffer.append(" ");
    }

    private void _attrValueChangeImpl(Element element, QualifiedName qualifiedName, String string) {
        TreeMap<QualifiedName, String> treeMap = (TreeMap<QualifiedName, String>)this._elemToPriorAttrMap.get(element);
        if (treeMap == null) {
            treeMap = new TreeMap<QualifiedName, String>();
            this._elemToPriorAttrMap.put(element, treeMap);
        }
        if (!treeMap.containsKey(qualifiedName)) {
            treeMap.put(qualifiedName, string);
        }
    }

    private boolean _isDescendent(Set set, Node node, boolean bl) {
        for (Node node2 : set) {
            if (bl && node2 == node) {
                return true;
            }
            if (!DomUtils.isDescendant((Node)node, (Node)node2)) continue;
            return true;
        }
        return false;
    }

    private void _updateChildrenInInsertedSubtree(Node node) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 8: {
                this._providePriorNodeValueIfNeeded(node, NodeChangeDetails.UNSET_VALUE);
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (this._removed.remove(node2)) {
                this._moved.add(node2);
            }
            this._updateChildrenInInsertedSubtree(node2);
            node2 = node2.getNextSibling();
        }
    }

    private void _updateChildrenInRemovedSubtree(Node node) {
        if (node == null) {
            return;
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this._moved.remove(node2);
            this._changed.remove(node2);
            this._added.remove(node2);
            this._updateChildrenInRemovedSubtree(node2);
            node2 = node2.getNextSibling();
        }
    }

    private static Set _new() {
        return new HashSet(4);
    }

    private static Set _imm(Set set) {
        return Collections.unmodifiableSet(set);
    }

    void $init$() {
        this._added = NCDImpl._new();
        this._changed = NCDImpl._new();
        this._removed = NCDImpl._new();
        this._moved = NCDImpl._new();
        this._elemToPriorAttrMap = new HashMap(4);
        this._nodeToPriorValue = new HashMap(4);
        this._addedImm = NCDImpl._imm(this._added);
        this._removedImm = NCDImpl._imm(this._removed);
        this._changedImm = NCDImpl._imm(this._changed);
        this._movedImm = NCDImpl._imm(this._moved);
    }

    static {
        $assertionsDisabled = NCDImpl.class.desiredAssertionStatus() ^ true;
    }

    void __processChange(ChangeRecord changeRecord) {
        if (!$assertionsDisabled && this._changedNodeTemp != null) {
            throw new AssertionError();
        }
        this._changedNodeTemp = changeRecord.getAssociatedNode();
        try {
            changeRecord.getChange().process(this);
        }
        finally {
            this._changedNodeTemp = null;
        }
    }

    public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        this._attrValueChange((Attr)this._changedNodeTemp, NodeChangeDetails.UNSET_VALUE, attrAddedChange.getAddedAttributeClone().getValue());
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        this._attrValueChange((Attr)this._changedNodeTemp, attrRemovedChange.getRemovedAttributeClone().getValue(), NodeChangeDetails.UNSET_VALUE);
    }

    public void handleAttrValueChange(AttrValueChange attrValueChange) {
        this._attrValueChange((Attr)this._changedNodeTemp, attrValueChange.getPrevValue(), attrValueChange.getNewValue());
    }

    public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
        this._nodeInserted(this._changedNodeTemp);
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
        this._nodeRemoved(this._changedNodeTemp);
    }

    public void handleNodeValueChange(NodeValueChange nodeValueChange) {
        this._nodeChanged(this._changedNodeTemp, nodeValueChange.getPrevValue());
    }
}

