/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import java.util.Collections;
import java.util.Map;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.base.ChangeRecord;
import oracle.bali.xml.dom.base.ChildDomModelTransaction;
import oracle.bali.xml.dom.base.DomChangesUndoableEditImpl;
import oracle.bali.xml.dom.base.DomModelTransaction;
import oracle.bali.xml.dom.base.UndoDomModelTransaction;
import oracle.bali.xml.dom.changes.DomChange;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class RootDomModelTransaction
extends DomModelTransaction {
    private int _changeCount;
    private transient Node _changeTarget;
    private transient int _changeFlags;

    public RootDomModelTransaction(BaseDomModel baseDomModel, RootDomModelTransaction rootDomModelTransaction) {
        super(baseDomModel);
        this._changeCount = rootDomModelTransaction.getChangeCount() + 1;
        this.transferListeners(rootDomModelTransaction);
    }

    public RootDomModelTransaction(BaseDomModel baseDomModel) {
        super(baseDomModel);
    }

    public void fireEntireDocumentChangedEvent(Map map) {
        this.fireSubtreeChanged(this.getModel().getDocument(), 31, Collections.EMPTY_LIST, map, null, false);
    }

    public UndoDomModelTransaction startUndoTransaction() {
        return this._startUndoRedoTransaction(true);
    }

    public UndoDomModelTransaction startRedoTransaction() {
        return this._startUndoRedoTransaction(false);
    }

    private UndoDomModelTransaction _startUndoRedoTransaction(boolean bl) {
        UndoDomModelTransaction undoDomModelTransaction = new UndoDomModelTransaction(this.getModel(), (DomModelTransaction)this, bl);
        this.setNestedTransaction(undoDomModelTransaction);
        return undoDomModelTransaction;
    }

    public DomModelTransaction commit() {
        throw new IllegalStateException("Root transactions can't be comitted");
    }

    public DomModelTransaction rollback() {
        throw new IllegalStateException("Root transactions can't be rolled back");
    }

    public String toString() {
        return super.toString() + "[change=" + this._changeCount + "]";
    }

    public int getChangeCount() {
        return this._changeCount;
    }

    protected DomModelTransaction getParent() {
        return null;
    }

    protected Node getChangeTarget() {
        return this._changeTarget;
    }

    protected int getChangeFlags() {
        return this._changeFlags;
    }

    protected void updateChangeTarget(ChildDomModelTransaction childDomModelTransaction, int n) {
        this._changeTarget = childDomModelTransaction.getChangeTarget();
        this._changeFlags = childDomModelTransaction.getChangeFlags();
        if (n != 0) {
            this._changeCount += n;
            if (n > 0 && childDomModelTransaction.modifiesUndoStack()) {
                this.getModel().__addEdit(new DomChangesUndoableEditImpl(this.getModel(), childDomModelTransaction.getDescription(), childDomModelTransaction.getMutationChanges()));
            }
        }
    }

    protected void commitChild(int n) {
        try {
            super.commitChild(n);
        }
        finally {
            this._changeTarget = null;
            this._changeFlags = 0;
        }
    }

    protected void handleMutationEventHook(Node node, int n, ChangeRecord changeRecord, MutationEvent mutationEvent) {
        DomChange domChange = changeRecord.getChange();
        this.getModel().__addEdit(new DomChangesUndoableEditImpl(this.getModel(), domChange));
        ++this._changeCount;
    }
}

