/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.base;

import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class UndoHandler
implements DomChangeHandler {
    private final BaseDomModel _model;

    UndoHandler(BaseDomModel baseDomModel) {
        this._model = baseDomModel;
    }

    public final void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        this.preHook(attrAddedChange);
        DomUtils.removeAttr((Element)attrAddedChange.getOwnerElement(this.getDocument()), (Attr)attrAddedChange.getAddedAttributeClone());
        this.postHook(attrAddedChange);
    }

    public final void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
        this.preHook(nodeInsertedChange);
        DomUtils.removeChild((Document)this.getDocument(), (NodeRef)nodeInsertedChange.getNodeRef());
        this.postHook(nodeInsertedChange);
    }

    public final void handleAttrValueChange(AttrValueChange attrValueChange) {
        this.preHook(attrValueChange);
        Attr attr = attrValueChange.getChangedAttr(this.getDocument());
        attr.setValue(attrValueChange.getPrevValue());
        this.postHook(attrValueChange);
    }

    public final void handleNodeValueChange(NodeValueChange nodeValueChange) {
        this.preHook(nodeValueChange);
        Node node = nodeValueChange.getNodeRef().getCorrespondingNode(this.getDocument());
        node.setNodeValue(nodeValueChange.getPrevValue());
        this.postHook(nodeValueChange);
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        this.preHook(attrRemovedChange);
        DomUtils.addAttr((Element)attrRemovedChange.getOwnerElement(this.getDocument()), (Attr)attrRemovedChange.getRemovedAttributeClone());
        this.postHook(attrRemovedChange);
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
        this.preHook(nodeRemovedChange);
        DomUtils.addChild((Document)this.getDocument(), (NodeRef)nodeRemovedChange.getNodeRef(), (Node)nodeRemovedChange.getRemovedNodeClone());
        this.postHook(nodeRemovedChange);
    }

    protected final BaseDomModel getModel() {
        return this._model;
    }

    protected final Document getDocument() {
        return this._model.getDocument();
    }

    protected void preHook(DomChange domChange) {
        domChange.deliverRelatedChanges(this._model, 0);
    }

    protected void postHook(DomChange domChange) {
        domChange.deliverRelatedChanges(this._model, 1);
    }
}

