/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.BufferDomDocumentParser;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import oracle.javatools.buffer.ReadTextBuffer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

abstract class AbstractBufferDomParser
implements DocumentHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    private LocatorManager _manager;
    private Map _locatorMap;
    private Node _currentParent;
    private final DOMImplementation _domImpl;
    private final WhitespaceHandler _whitespaceHandler;
    private final ParserConfiguration _parserConfiguration;
    private final List _textNodesWithModeTrim;
    private static final Logger _LOGGER;

    protected AbstractBufferDomParser(DOMImplementation dOMImplementation, ParserConfiguration parserConfiguration, WhitespaceHandler whitespaceHandler) {
        this.$init$();
        if (dOMImplementation == null) {
            throw new IllegalArgumentException("null DOMImplementation");
        }
        if (whitespaceHandler == null) {
            throw new IllegalArgumentException("null WhitespaceHandler");
        }
        this._domImpl = dOMImplementation;
        this._parserConfiguration = parserConfiguration;
        this._whitespaceHandler = whitespaceHandler;
    }

    public void handleStartElement(ResolvedName resolvedName, AttributeDeclarations attributeDeclarations, ElementLocator elementLocator) {
        this._handleElement(resolvedName, attributeDeclarations, elementLocator, false);
    }

    public void handleEmptyElement(ResolvedName resolvedName, AttributeDeclarations attributeDeclarations, ElementLocator elementLocator) {
        this._handleElement(resolvedName, attributeDeclarations, elementLocator, true);
    }

    public void handleEndElement(ResolvedName resolvedName, SimpleLocator simpleLocator, boolean bl) {
        if (this._currentParent != null && this._currentParent.getNodeType() == 1) {
            ElementLocator elementLocator;
            if (this._locatorMap != null && (elementLocator = (ElementLocator)this._locatorMap.get(this._currentParent)) != null) {
                elementLocator.setEndTagLocator(simpleLocator);
                elementLocator.setEndTagComplete(bl);
            }
            this._currentParent = this._currentParent.getParentNode();
        }
    }

    public void handleCDATASection(String string, SimpleLocator simpleLocator) {
        CDATASection cDATASection = null;
        try {
            if (this._parentAllowsCharacterContent()) {
                cDATASection = this.getOwnerDocument().createCDATASection(string);
            }
        }
        catch (Exception exception) {
            cDATASection = null;
            this.getLogger().log(Level.WARNING, "Exception creating CDATA", exception);
        }
        if (cDATASection != null) {
            this._currentParent.appendChild(cDATASection);
            this.mapToLocator(cDATASection, simpleLocator);
        } else {
            this._manager.detach(simpleLocator);
        }
    }

    static {
        $assertionsDisabled = AbstractBufferDomParser.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(AbstractBufferDomParser.class.getName());
    }

    public void handleText(String string, TextLocator textLocator) {
        WhitespaceResult whitespaceResult;
        Element element;
        if (!$assertionsDisabled && string.length() <= 0) {
            throw new AssertionError((Object)"must have some characters");
        }
        if (!$assertionsDisabled && textLocator.getLength() <= 0) {
            throw new AssertionError((Object)"must have some location");
        }
        String string2 = string;
        Text text = null;
        TextLocator textLocator2 = null;
        textLocator.attach(this._manager, false);
        if (!this._parentAllowsCharacterContent()) {
            return;
        }
        WhitespaceMode whitespaceMode = WhitespaceMode.MODE_PRESERVE;
        if (this._currentParent != null && (element = this.getPotentialParentElement(this._currentParent)) != null) {
            whitespaceMode = this.getWhitespaceHandler().getElementContentWhitespaceMode(this.getTraversalForWhitespaceHandler(), element);
        }
        if ((whitespaceResult = whitespaceMode.apply(string2)) == null) {
            textLocator.attach(this._manager, true);
            textLocator2 = textLocator;
        } else {
            if (string2.length() != whitespaceResult.getTotalLength()) {
                throw new IllegalStateException("Result has wrong length. Chars=||" + string2 + "|| " + "charsLen=" + string2.length() + " resultLen=" + whitespaceResult.getTotalLength());
            }
            if (whitespaceResult.isEmpty()) {
                string2 = null;
            } else {
                string2 = whitespaceResult.getValue();
                if (whitespaceResult.hasNoWhitespace()) {
                    textLocator.attach(this._manager, true);
                    textLocator2 = textLocator;
                } else {
                    textLocator2 = this._makeTextLocator(string, textLocator, whitespaceResult);
                }
            }
        }
        if (string2 != null) {
            try {
                text = this.getOwnerDocument().createTextNode(string2);
            }
            catch (Exception exception) {
                text = null;
                this.getLogger().log(Level.WARNING, "Exception creating Text", exception);
            }
        }
        if (text != null) {
            if (textLocator2 == null) {
                throw new IllegalStateException("no locator! text=" + text);
            }
            this._currentParent.appendChild(text);
            this.mapToLocator(text, textLocator2);
            if (whitespaceMode == WhitespaceMode.MODE_TRIM) {
                this._textNodesWithModeTrim.add(text);
            }
        }
    }

    public void handleProcessingInstruction(String string, String string2, SimpleLocator simpleLocator) {
        ProcessingInstruction processingInstruction = null;
        if (string != null) {
            try {
                if (this.getOwnerDocument() != null) {
                    processingInstruction = this.getOwnerDocument().createProcessingInstruction(string, string2);
                } else {
                    Document document = DomUtils.getScratchDocument();
                    processingInstruction = document.createProcessingInstruction(string, string2);
                }
            }
            catch (Exception exception) {
                processingInstruction = null;
                this.getLogger().log(Level.WARNING, "Exception creating PI", exception);
            }
        }
        if (processingInstruction != null) {
            if (this.getOwnerDocument() != null) {
                this._currentParent.appendChild(processingInstruction);
                this.mapToLocator(processingInstruction, simpleLocator);
            } else {
                this.handleCommentOrPIBeforeDocumentCreated(processingInstruction, simpleLocator);
            }
        } else {
            this._manager.detach(simpleLocator);
        }
    }

    public void handleComment(String string, SimpleLocator simpleLocator) {
        Comment comment = null;
        try {
            if (this.getOwnerDocument() != null) {
                comment = this.getOwnerDocument().createComment(string);
            } else {
                Document document = DomUtils.getScratchDocument();
                comment = document.createComment(string);
            }
        }
        catch (Exception exception) {
            comment = null;
            this.getLogger().log(Level.WARNING, "Exception creating Comment", exception);
        }
        if (comment != null) {
            if (this.getOwnerDocument() != null) {
                this._currentParent.appendChild(comment);
                this.mapToLocator(comment, simpleLocator);
            } else {
                this.handleCommentOrPIBeforeDocumentCreated(comment, simpleLocator);
            }
        } else {
            this._manager.detach(simpleLocator);
        }
    }

    public final DOMImplementation getDOMImplementation() {
        return this._domImpl;
    }

    public final WhitespaceHandler getWhitespaceHandler() {
        return this._whitespaceHandler;
    }

    public final ParserConfiguration getParserConfiguration() {
        return this._parserConfiguration;
    }

    protected Logger getLogger() {
        return _LOGGER;
    }

    protected final void doParse(ReadTextBuffer readTextBuffer, LocatorManager locatorManager, Map map, Node node, NamespaceDeclarations namespaceDeclarations) {
        this._locatorMap = map;
        this._manager = locatorManager;
        this._currentParent = node;
        this._textNodesWithModeTrim.clear();
        this.getWhitespaceHandler().beginCacheablePeriod();
        try {
            DocumentScanner documentScanner = this.getParserConfiguration().createDocumentScanner();
            documentScanner.scanDocument(readTextBuffer, this, locatorManager, namespaceDeclarations);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.getLogger().log(Level.SEVERE, "Unexpected error in document scanner", throwable);
        }
        if (!this._textNodesWithModeTrim.isEmpty()) {
            for (Text text : this._textNodesWithModeTrim) {
                this._postProcessTrimTextNode(text);
            }
        }
    }

    protected final void doCleanup() {
        this._locatorMap = null;
        this._manager = null;
        this._currentParent = null;
        this._textNodesWithModeTrim.clear();
        this.getWhitespaceHandler().endCacheablePeriod();
    }

    protected final void clearRegularLocators() {
        Locator locator = (Locator)this._locatorMap.get(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY);
        Locator locator2 = (Locator)this._locatorMap.get(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY);
        this._manager.clear();
        this._locatorMap.clear();
        this._restore(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY, locator);
        this._restore(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY, locator2);
    }

    protected final void mapToLocator(Object object, Locator locator) {
        if (object != null) {
            this._locatorMap.put(object, locator);
        }
    }

    protected final LocatorManager getLocatorManager() {
        return this._manager;
    }

    protected final void setCurrentParent(Node node) {
        this._currentParent = node;
    }

    protected TreeTraversal getTraversalForWhitespaceHandler() {
        return DocumentTreeTraversal.INSTANCE;
    }

    protected Element getPotentialParentElement(Node node) {
        return DomUtils.asElement((Node)node);
    }

    protected abstract Document getOwnerDocument();

    protected abstract void handleCommentOrPIBeforeDocumentCreated(Node var1, Locator var2);

    protected abstract Element handleElementBeforeDocumentCreated(ResolvedName var1, ElementLocator var2);

    private void _handleElement(ResolvedName resolvedName, AttributeDeclarations attributeDeclarations, ElementLocator elementLocator, boolean bl) {
        Element element = null;
        if (resolvedName.getLocalName() != null) {
            if (this.getOwnerDocument() == null) {
                element = this.handleElementBeforeDocumentCreated(resolvedName, elementLocator);
            } else if (this._currentParent != this.getOwnerDocument()) {
                try {
                    element = this.getOwnerDocument().createElementNS(resolvedName.getNamespace(), resolvedName.getRawName());
                }
                catch (Exception exception) {
                    element = null;
                    this.getLogger().log(Level.WARNING, "Exception creating Element", exception);
                }
                if (element != null) {
                    this._currentParent.appendChild(element);
                }
            }
        }
        if (element != null) {
            this.mapToLocator(element, elementLocator);
            this._handleAttributes(element, attributeDeclarations);
            if (!bl) {
                this._currentParent = element;
            } else if (this._currentParent == null) {
                this._currentParent = element.getParentNode();
            }
        }
    }

    private void _handleAttributes(Element element, AttributeDeclarations attributeDeclarations) {
        ResolvedName resolvedName = null;
        String string = null;
        AttributeLocator attributeLocator = null;
        int n = 0;
        while (n < attributeDeclarations.getLength()) {
            Attr attr = null;
            resolvedName = attributeDeclarations.getResolvedName(n);
            string = attributeDeclarations.getValue(n);
            attributeLocator = attributeDeclarations.getLocator(n);
            if (resolvedName.getLocalName() != null) {
                try {
                    attr = this.getOwnerDocument().createAttributeNS(resolvedName.getNamespace(), resolvedName.getRawName());
                }
                catch (Exception exception) {
                    attr = null;
                    this.getLogger().log(Level.WARNING, "Exception creating Attr", exception);
                }
                if (attr != null) {
                    WhitespaceMode whitespaceMode;
                    WhitespaceResult whitespaceResult;
                    element.setAttributeNodeNS(attr);
                    if (string != null && (whitespaceResult = (whitespaceMode = this.getWhitespaceHandler().getAttributeContentWhitespaceMode(this.getTraversalForWhitespaceHandler(), element, resolvedName.getNamespace(), resolvedName.getLocalName())).apply(string)) != null) {
                        string = whitespaceResult.getValue();
                    }
                    if (string != null) {
                        attr.setValue(string);
                    }
                    this.mapToLocator(attr, attributeLocator);
                }
            }
            ++n;
        }
    }

    private TextLocator _makeTextLocator(String string, TextLocator textLocator, WhitespaceResult whitespaceResult) {
        ArrayList<EntityRefLocator> arrayList = new ArrayList<EntityRefLocator>(0);
        ArrayList<SimpleLocator> arrayList2 = new ArrayList<SimpleLocator>(0);
        int n = textLocator.getStartOffset();
        BitSet bitSet = whitespaceResult.getWhitespaceBitSet();
        Iterator iterator = textLocator.getContentLocators().iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            SimpleLocator simpleLocator = (SimpleLocator)iterator.next();
            if (simpleLocator.getLength() == 0) {
                if (!this.getLogger().isLoggable(Level.WARNING)) continue;
                this.getLogger().log(Level.WARNING, "zero-length locator {0} found inside {1} for text ||{2}||", new Object[]{simpleLocator, textLocator, string});
                continue;
            }
            boolean bl = false;
            if (simpleLocator instanceof EntityRefLocator) {
                EntityRefLocator entityRefLocator = (EntityRefLocator)simpleLocator;
                int n3 = entityRefLocator.getReplacementText().length();
                boolean bl2 = false;
                int n4 = entityRefLocator.getStartOffset() - n2;
                int n5 = 0;
                while (n5 < n3) {
                    if (!bitSet.get(n4 + n5)) {
                        bl2 = true;
                        break;
                    }
                    ++n5;
                }
                int n6 = entityRefLocator.getLength() - n3;
                n2 += n6;
                if (bl2) {
                    bl = true;
                } else if (!arrayList2.isEmpty()) {
                    entityRefLocator.attach(this._manager, true);
                    arrayList.add(entityRefLocator);
                }
            } else {
                int n7 = simpleLocator.getStartOffset() - n2;
                int n8 = simpleLocator.getEndOffset() - n2;
                int n9 = bitSet.nextSetBit(n7);
                if (n9 >= n8) {
                    bl = true;
                } else {
                    this._processEachCharForWhitespace(arrayList, arrayList2, bitSet, n2, n7, n8);
                }
            }
            if (!bl) continue;
            this._manager.attach(simpleLocator);
            arrayList2.add(simpleLocator);
        }
        int n10 = arrayList.size();
        if (n10 > 0) {
            int n11 = textLocator.getEndOffset();
            ListIterator listIterator = arrayList.listIterator(n10);
            while (listIterator.hasPrevious()) {
                Locator locator = (Locator)listIterator.previous();
                if (locator.getEndOffset() != n11) break;
                locator.attach(this._manager, false);
                listIterator.remove();
                n11 = locator.getStartOffset();
            }
        }
        return this._manager.createTextLocator(arrayList2, arrayList);
    }

    private void _processEachCharForWhitespace(List list, List list2, BitSet bitSet, int n, int n2, int n3) {
        int n4 = -1;
        boolean bl = false;
        int n5 = n2;
        while (n5 < n3) {
            boolean bl2 = bitSet.get(n5);
            if (n4 == -1) {
                bl = bl2;
                n4 = n5;
            } else if (bl2 != bl) {
                this._flushRun(list, list2, n, n4, n5, bl);
                bl = bl2;
                n4 = n5;
            }
            ++n5;
        }
        if (n4 != -1) {
            this._flushRun(list, list2, n, n4, n3, bl);
        }
    }

    private void _flushRun(List list, List list2, int n, int n2, int n3, boolean bl) {
        SimpleLocator simpleLocator = this._manager.createSimpleLocator(n + n2, n + n3);
        if (bl) {
            if (!list2.isEmpty()) {
                list.add(simpleLocator);
            }
        } else {
            list2.add(simpleLocator);
        }
    }

    private void _postProcessTrimTextNode(Text text) {
        boolean bl;
        Node node = text.getParentNode();
        boolean bl2 = node.getFirstChild() == text;
        boolean bl3 = bl = node.getLastChild() == text;
        if (bl2 || bl) {
            String string = text.getNodeValue();
            TextLocator textLocator = (TextLocator)this._locatorMap.get(text);
            if (" ".equals(string)) {
                this._locatorMap.remove(text);
                node.removeChild(text);
            } else {
                if (bl2 && string.startsWith(" ")) {
                    text.deleteData(0, 1);
                    textLocator.removeFirstCharFromContent();
                }
                if (bl && string.endsWith(" ")) {
                    text.deleteData(text.getLength() - 1, 1);
                    textLocator.removeLastCharFromContent();
                }
            }
        }
    }

    private boolean _parentAllowsCharacterContent() {
        boolean bl = true;
        if (this._currentParent == null || this._currentParent.getNodeType() == 9) {
            bl = false;
        }
        return bl;
    }

    private void _restore(Object object, Locator locator) {
        if (locator != null) {
            locator.attach(this._manager, true);
            this._locatorMap.put(object, locator);
        }
    }

    void $init$() {
        this._manager = null;
        this._locatorMap = null;
        this._currentParent = null;
        this._textNodesWithModeTrim = new LinkedList();
    }
}

