/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import org.w3c.dom.Node;

class AddOrRemoveEndTagLocatorChange
extends RelatedChange {
    private final NodeRef _nodeRef;
    private final SimpleLocator _newEndLocator;
    private final boolean _isAdd;
    private static final Logger _LOGGER = Logger.getLogger(AddOrRemoveEndTagLocatorChange.class.getName());

    public AddOrRemoveEndTagLocatorChange(Node node, SimpleLocator simpleLocator, boolean bl) {
        this(NodeRefFactory.getNodeRef((Node)node), simpleLocator, bl);
    }

    public AddOrRemoveEndTagLocatorChange(NodeRef nodeRef, SimpleLocator simpleLocator, boolean bl) {
        this._nodeRef = nodeRef;
        this._newEndLocator = simpleLocator;
        this._isAdd = bl;
    }

    public void preUndo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._isAdd) {
            this._removeEndTag(bufferDomModel);
        } else {
            this._addEndTag(bufferDomModel);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void postRedo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._isAdd) {
            this._addEndTag(bufferDomModel);
        } else {
            this._removeEndTag(bufferDomModel);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    private void _removeEndTag(BufferDomModel bufferDomModel) {
        Node node = TextSyncUtils.getNode(bufferDomModel, this._nodeRef);
        ElementLocator elementLocator = (ElementLocator)bufferDomModel.getLocator(node);
        bufferDomModel.getLocatorManager().removeEndTagAtLocator(elementLocator);
    }

    private void _addEndTag(BufferDomModel bufferDomModel) {
        Node node = TextSyncUtils.getNode(bufferDomModel, this._nodeRef);
        ElementLocator elementLocator = (ElementLocator)bufferDomModel.getLocator(node);
        bufferDomModel.getLocatorManager().addEndTagAtLocator(elementLocator, (SimpleLocator)Locator.getCopy(this._newEndLocator));
    }
}

