/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.buffer.AbstractBufferDomParser;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.javatools.buffer.ReadTextBuffer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BufferDomDocumentParser
extends AbstractBufferDomParser {
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final Object DECLARATION_LOCATOR_KEY;
    public static final Object DOCUMENT_TYPE_LOCATOR_KEY;
    private Document _document;
    private DocumentType _documentType;
    private XmlDeclarationInfo _xmlDeclarationInfo;
    private ArrayList _tempNodes;
    private ArrayList _tempLocators;
    private ElementLocator _fakeRootLocator;
    private int _numTempNodesBeforeDoctype;

    public BufferDomDocumentParser(DOMImplementation dOMImplementation, ParserConfiguration parserConfiguration, WhitespaceHandler whitespaceHandler) {
        super(dOMImplementation, parserConfiguration, whitespaceHandler);
        this.$init$();
    }

    public Document parse(ReadTextBuffer readTextBuffer, LocatorManager locatorManager, Map map) {
        if (readTextBuffer == null || locatorManager == null || map == null) {
            throw new IllegalArgumentException("parse() parameters cannot be null");
        }
        try {
            Document document = this._parse(readTextBuffer, locatorManager, map);
            this.doCleanup();
            return document;
        }
        catch (Throwable throwable) {
            this.doCleanup();
            throw throwable;
        }
    }

    public void handleXMLDeclaration(String string, String string2, String string3, DeclarationLocator declarationLocator) {
        if (this._xmlDeclarationInfo != null || this._document != null || this._documentType != null || !this._tempNodes.isEmpty()) {
            if (this.getLogger().isLoggable(Level.WARNING)) {
                this.getLogger().log(Level.WARNING, "XML declaration encountered but was not first in document; it was ignored. version={0} encoding={1} standalone={2} locator={3} oldDecl={4} doctype={5} doc={6} tempnodes={7}", new Object[]{string, string2, string3, declarationLocator, this._xmlDeclarationInfo, this._documentType, this._document, this._tempNodes});
            }
            return;
        }
        Float f = null;
        Boolean bl = null;
        try {
            if (string != null) {
                f = Float.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("yes".equals(string3)) {
            bl = Boolean.TRUE;
        } else if ("no".equals(string3)) {
            bl = Boolean.FALSE;
        }
        this._xmlDeclarationInfo = new XmlDeclarationInfo(f, string2, bl);
        this.mapToLocator(DECLARATION_LOCATOR_KEY, declarationLocator);
    }

    public void handleDocumentType(ResolvedName resolvedName, String string, String string2, SimpleLocator simpleLocator) {
        if (this._document == null) {
            String string3 = resolvedName.getRawName();
            if (string3 != null) {
                try {
                    this._documentType = this.getDOMImplementation().createDocumentType(resolvedName.getRawName(), string, string2);
                    this._numTempNodesBeforeDoctype = this._tempNodes.size();
                }
                catch (Exception exception) {
                    this._documentType = null;
                    this.getLogger().log(Level.WARNING, "Exception creating doctype", exception);
                }
            }
        } else {
            this.getLogger().log(Level.WARNING, "Doctype encountered after document created, at {0}", simpleLocator);
        }
        this.mapToLocator(DOCUMENT_TYPE_LOCATOR_KEY, simpleLocator);
    }

    static {
        $assertionsDisabled = BufferDomDocumentParser.class.desiredAssertionStatus() ^ true;
        DECLARATION_LOCATOR_KEY = "declaration locator";
        DOCUMENT_TYPE_LOCATOR_KEY = "doctype locator";
    }

    public void handleText(String string, TextLocator textLocator) {
        Element element;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (this._document == null) {
            arrayList = new ArrayList(this._tempNodes);
            arrayList2 = new ArrayList(this._tempLocators);
        }
        Document document = this._document;
        this._considerFakeRoot(textLocator.getStartOffset());
        super.handleText(string, textLocator);
        if (document == null && this._document != null && (element = this._document.getDocumentElement()) != null && element.getFirstChild() == null) {
            this._fakeRootLocator = null;
            this._document = null;
            this.setCurrentParent(null);
            this.clearRegularLocators();
            if (!$assertionsDisabled && arrayList == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && arrayList2 == null) {
                throw new AssertionError();
            }
            this._tempNodes = arrayList;
            this._tempLocators = arrayList2;
            if (this._documentType != null) {
                this._documentType = this.getDOMImplementation().createDocumentType(this._documentType.getName(), this._documentType.getPublicId(), this._documentType.getSystemId());
            }
        }
    }

    public void handleCDATASection(String string, SimpleLocator simpleLocator) {
        this._considerFakeRoot(simpleLocator.getStartOffset());
        super.handleCDATASection(string, simpleLocator);
    }

    protected Document getOwnerDocument() {
        return this._document;
    }

    protected void handleCommentOrPIBeforeDocumentCreated(Node node, Locator locator) {
        this._tempNodes.add(node);
        this._tempLocators.add(locator);
    }

    protected Element handleElementBeforeDocumentCreated(ResolvedName resolvedName, ElementLocator elementLocator) {
        ResolvedName resolvedName2;
        ResolvedName resolvedName3 = this.getParserConfiguration().getSimulatedRootName();
        if (resolvedName3 == null || resolvedName.matches(resolvedName3)) {
            resolvedName2 = resolvedName;
            resolvedName3 = null;
        } else {
            resolvedName2 = resolvedName3;
        }
        DOMImplementation dOMImplementation = this.getDOMImplementation();
        try {
            this._document = dOMImplementation.createDocument(resolvedName2.getNamespace(), resolvedName2.getRawName(), this._documentType);
        }
        catch (Exception exception) {
            this._document = null;
            this.getLogger().log(Level.WARNING, "Exception creating Document", exception);
        }
        if (this._document != null) {
            Element element;
            Element element2 = this._document.getDocumentElement();
            if (resolvedName3 != null) {
                element = this._document.createElementNS(resolvedName.getNamespace(), resolvedName.getRawName());
                element2.appendChild(element);
                this._createFakeRootLocator(elementLocator.getStartOffset());
                this.mapToLocator(element2, this._fakeRootLocator);
            } else {
                element = element2;
            }
            this._plugInTempNodes();
            return element;
        }
        return null;
    }

    private void _plugInTempNodes() {
        Element element = this._document.getDocumentElement();
        DocumentType documentType = this._document.getDoctype();
        Node node = null;
        Locator locator = null;
        int n = this._tempNodes.size();
        int n2 = 0;
        while (n2 < n) {
            node = (Node)this._tempNodes.get(n2);
            node = this._document.importNode(node, true);
            locator = (Locator)this._tempLocators.get(n2);
            this.mapToLocator(node, locator);
            if (documentType != null && n2 < this._numTempNodesBeforeDoctype) {
                this._document.insertBefore(node, documentType);
            } else {
                this._document.insertBefore(node, element);
            }
            ++n2;
        }
        this._tempNodes.clear();
        this._tempLocators.clear();
    }

    private void _considerFakeRoot(int n) {
        ResolvedName resolvedName;
        if (this._document == null && (resolvedName = this.getParserConfiguration().getSimulatedRootName()) != null) {
            this._document = this.getDOMImplementation().createDocument(resolvedName.getNamespace(), resolvedName.getRawName(), this._documentType);
            this._createFakeRootLocator(n);
            Element element = this._document.getDocumentElement();
            this.mapToLocator(element, this._fakeRootLocator);
            this.setCurrentParent(element);
            this._plugInTempNodes();
        }
    }

    private void _createFakeRootLocator(int n) {
        if (!$assertionsDisabled && this._fakeRootLocator != null) {
            throw new AssertionError();
        }
        SimpleLocator simpleLocator = this.getLocatorManager().createBackwardsBiasedSimpleLocator(n, n, false);
        SimpleLocator simpleLocator2 = (SimpleLocator)simpleLocator.getCopy();
        SimpleLocator simpleLocator3 = this.getLocatorManager().createSimpleLocator(n, n, false);
        this._fakeRootLocator = this.getLocatorManager().createElementLocator(simpleLocator, simpleLocator2, simpleLocator3);
    }

    private Document _parse(ReadTextBuffer readTextBuffer, LocatorManager locatorManager, Map map) {
        this._document = null;
        this._documentType = null;
        this._xmlDeclarationInfo = null;
        this._fakeRootLocator = null;
        this._numTempNodesBeforeDoctype = 0;
        this._tempNodes.clear();
        this._tempLocators.clear();
        this.doParse(readTextBuffer, locatorManager, map, null, null);
        if (this._document == null && !this.getDOMImplementation().getClass().getName().startsWith("MDS")) {
            this._considerFakeRoot(readTextBuffer.getLength());
            if (this._document == null) {
                this._document = this.getDOMImplementation().createDocument(null, "bogusRoot", this._documentType);
                this._document.removeChild(this._document.getDocumentElement());
                this._plugInTempNodes();
            }
        }
        if (this._fakeRootLocator != null) {
            int n = readTextBuffer.getLength();
            this._fakeRootLocator.getEndTagLocator().setStartOffset(n);
            this._fakeRootLocator.getEndTagLocator().setEndOffset(n);
            this._fakeRootLocator.attach(locatorManager, true);
        }
        Document document = this._document;
        this._document = null;
        this._documentType = null;
        this._fakeRootLocator = null;
        this._numTempNodesBeforeDoctype = 0;
        return document;
    }

    XmlDeclarationInfo __getXmlDeclarationInfo() {
        return this._xmlDeclarationInfo;
    }

    void $init$() {
        this._document = null;
        this._documentType = null;
        this._xmlDeclarationInfo = null;
        this._tempNodes = new ArrayList();
        this._tempLocators = new ArrayList();
        this._fakeRootLocator = null;
        this._numTempNodesBeforeDoctype = 0;
    }
}

