/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.buffer.AbstractBufferDomParser;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.SimulateInsertingFragmentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BufferDomFragmentParser
extends AbstractBufferDomParser {
    private Document _document;
    private TreeTraversal _traversal;
    private DocumentFragment _fragment;
    private Element _contextElement;

    public BufferDomFragmentParser(DOMImplementation dOMImplementation, ParserConfiguration parserConfiguration, WhitespaceHandler whitespaceHandler) {
        super(dOMImplementation, parserConfiguration, whitespaceHandler);
        this.$init$();
    }

    public DocumentFragment parseFragment(Document document, Node node, Map map, String string) {
        if (document == null) {
            throw new IllegalArgumentException("null owner document");
        }
        if (string == null) {
            throw new IllegalArgumentException("null text");
        }
        ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
        LocatorManager locatorManager = new LocatorManager(null);
        HashMap hashMap = new HashMap();
        this._document = document;
        this._fragment = document.createDocumentFragment();
        this._traversal = DocumentTreeTraversal.INSTANCE;
        this._contextElement = null;
        DocumentFragment documentFragment = null;
        try {
            NamespaceDeclarations namespaceDeclarations;
            if (node == null) {
                namespaceDeclarations = null;
                this._traversal = DocumentTreeTraversal.INSTANCE;
            } else {
                HashMap hashMap2 = new HashMap(27);
                if (DomUtils.isElement((Node)node)) {
                    this._contextElement = (Element)node;
                    this._traversal = new SimulateInsertingFragmentTreeTraversal(this._contextElement, this._fragment);
                }
                hashMap2.putAll(this.getParserConfiguration().getPrefixesInScope(node));
                hashMap2.putAll(map);
                namespaceDeclarations = new NamespaceDeclarations();
                for (Map.Entry entry : hashMap2.entrySet()) {
                    String string2 = (String)entry.getKey();
                    String string3 = (String)entry.getValue();
                    NamespaceDeclaration namespaceDeclaration = "".equals(string2) ? new NamespaceDeclaration(string3, -1) : new NamespaceDeclaration(string3, string2, -1);
                    namespaceDeclarations.addNamespaceDeclaration(namespaceDeclaration);
                }
            }
            this.doParse(readTextBuffer, locatorManager, hashMap, this._fragment, namespaceDeclarations);
        }
        finally {
            documentFragment = this._fragment;
            this._fragment = null;
            this._document = null;
            this._traversal = null;
            this._contextElement = null;
            this.doCleanup();
        }
        return documentFragment;
    }

    protected Document getOwnerDocument() {
        return this._document;
    }

    protected void handleCommentOrPIBeforeDocumentCreated(Node node, Locator locator) {
        throw new IllegalStateException("impossible, since fragment parser always has a document");
    }

    protected Element handleElementBeforeDocumentCreated(ResolvedName resolvedName, ElementLocator elementLocator) {
        throw new IllegalStateException("impossible, since fragment parser always has a document");
    }

    protected TreeTraversal getTraversalForWhitespaceHandler() {
        return this._traversal;
    }

    protected Element getPotentialParentElement(Node node) {
        if (node == this._fragment) {
            return this._contextElement;
        }
        return super.getPotentialParentElement(node);
    }

    public void handleXMLDeclaration(String string, String string2, String string3, DeclarationLocator declarationLocator) {
    }

    public void handleDocumentType(ResolvedName resolvedName, String string, String string2, SimpleLocator simpleLocator) {
    }

    void $init$() {
        this._document = null;
        this._traversal = null;
        this._fragment = null;
        this._contextElement = null;
    }
}

