/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.buffer.BufferDomDocumentParser;
import oracle.bali.xml.dom.buffer.BufferDomFragmentParser;
import oracle.bali.xml.dom.buffer.BufferDomTextSync;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ReformatPCWrapper;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.UndoableEditWrapper;
import oracle.bali.xml.share.WeakListenerProxy;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.util.NamedTimer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public final class BufferDomModel
extends BaseDomModel {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final int _DEFAULT_INDENTATION_SIZE = 2;
    private static final int _TIMER_DELAY = 750;
    private static final Timer _updateTimer;
    private volatile UpdateTimerTask _currentTask;
    private volatile boolean _forceParse;
    private volatile boolean _textSyncInProgress;
    private volatile int _synchedChangeCount;
    private volatile boolean _immediateParseInProgress;
    private volatile boolean _inUndoRedoTxn;
    private TextBuffer _textBuffer;
    private int _indentationSize;
    private LocatorManager _manager;
    private HashMap _locatorMap;
    private List _wfErrors;
    private XmlDeclarationInfo _xmlDeclarationInfo;
    private boolean _inSetUnspecifiedAttribute;
    private volatile boolean _subsequentWriteLocksShouldNotWriteLockBuffer;
    private ParserConfiguration _reformatPC;
    private TextBufferListener _weakTextBufferListenerWrapper;
    private final ParserConfiguration _parserConfiguration;
    private final BufferDomDocumentParser _parser;
    private final BufferDomTextSync _textSync;
    private final Comparator _nodeComparatorByLocator;
    private final TextBufferListener _textBufferListener;
    private final ReadWriteLock _domLock;
    private final LinkedList _bufferWriteUnlockers;
    private final Runnable _UNLOCKER_WRITE;
    private final Runnable _UNLOCKER_READ;

    public BufferDomModel(DomModelContext domModelContext, TextBuffer textBuffer, DOMImplementation dOMImplementation, ParserConfiguration parserConfiguration) {
        this(domModelContext, textBuffer, dOMImplementation, parserConfiguration, null);
    }

    public BufferDomModel(DomModelContext domModelContext, TextBuffer textBuffer, DOMImplementation dOMImplementation, ParserConfiguration parserConfiguration, WhitespaceHandler whitespaceHandler) {
        super(domModelContext, whitespaceHandler);
        this.$init$();
        this._textBuffer = textBuffer;
        this._parser = new BufferDomDocumentParser(dOMImplementation, parserConfiguration, this.getWhitespaceHandler());
        this._manager = new LocatorManager(this._textBuffer.getLineMap());
        this._locatorMap = new HashMap();
        this._attachTextBufferListener();
        this._parserConfiguration = parserConfiguration;
    }

    public void setTextBuffer(TextBuffer textBuffer) {
        this.verifyWriteLock();
        this._detachTextBufferListener();
        this._textBuffer = textBuffer;
        this._attachTextBufferListener();
        this._manager.setLineMap(textBuffer.getLineMap());
        this._forceParse = true;
    }

    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    protected Document getDocumentImpl() {
        if (this._forceParse) {
            this._ensureSynchronizedImmediate();
        }
        return this.getDocumentInternal();
    }

    public boolean isReadOnly() {
        this.verifyLock();
        return this._textBuffer.isReadOnly();
    }

    public void destroyDocument() {
        this.acquireWriteLock();
        try {
            if (this.getDocumentInternal() != null) {
                this.replaceDocument(null);
                this._manager.clear();
                this._locatorMap.clear();
                this._forceParse = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public int getIndentSize() {
        this.verifyLock();
        return this._indentationSize;
    }

    public Locator getLocator(Node node) {
        this.verifyLock();
        return this._getLocatorDirectly(node);
    }

    private Locator _getLocatorDirectly(Node node) {
        Locator locator = (Locator)this._locatorMap.get(node);
        if (locator != null) {
            return locator;
        }
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        if (node.getNodeType() == 10 && node.getOwnerDocument() == this.getDocument()) {
            return this.getDocumentTypeLocator();
        }
        return null;
    }

    public DeclarationLocator getXMLDeclarationLocator() {
        this.verifyLock();
        return (DeclarationLocator)this._locatorMap.get(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY);
    }

    public Locator getDocumentTypeLocator() {
        this.verifyLock();
        return (Locator)this._locatorMap.get(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY);
    }

    public void rollbackTransaction() {
        super.rollbackTransaction();
        this._inUndoRedoTxn = false;
    }

    public void commitTransaction() {
        super.commitTransaction();
        this._inUndoRedoTxn = false;
    }

    public boolean isUnspecifiedAttribute(Attr attr) {
        this.verifyLock();
        AttributeLocator attributeLocator = (AttributeLocator)this._getLocatorDirectly(attr);
        return attributeLocator.isSpecified() ^ true;
    }

    protected void acquireReadLockDirectly() {
        this._textBuffer.readLock();
        this._domLock.readLock();
    }

    protected void releaseReadLockDirectly() {
        this._domLock.readUnlock();
        this._textBuffer.readUnlock();
    }

    protected void acquireWriteLockDirectly() {
        boolean bl = this._textBuffer.isReadOnly() ^ true;
        this._acquireWriteLockDirectly(bl && !this._subsequentWriteLocksShouldNotWriteLockBuffer);
    }

    private void _acquireWriteLockDirectly(boolean bl) {
        if (bl) {
            this._domLock.readLock();
            try {
                Object e;
                if (!this._bufferWriteUnlockers.isEmpty() && (e = this._bufferWriteUnlockers.getLast()) == this._UNLOCKER_READ) {
                    bl = false;
                }
            }
            finally {
                this._domLock.readUnlock();
            }
        }
        if (bl) {
            this._textBuffer.writeLock();
        } else {
            this._textBuffer.readLock();
        }
        this._domLock.writeLock();
        if (bl && this._textBuffer.getLockStatus() == 1) {
            this.handleLockUpgradeAttempt(new IllegalStateException("attempted to get DomModel write lock while holding textbuffer read lock"));
        }
        Runnable runnable = bl ? this._UNLOCKER_WRITE : this._UNLOCKER_READ;
        this._bufferWriteUnlockers.add(runnable);
    }

    protected void releaseWriteLockDirectly() {
        Runnable runnable = (Runnable)this._bufferWriteUnlockers.removeLast();
        this._domLock.writeUnlock();
        runnable.run();
    }

    public int getLockStatus() {
        return this.getLockStatus(this._domLock);
    }

    public List getCurrentDomParseProblems() {
        this.verifyLock();
        if (this._wfErrors == null) {
            this._doWfCheck();
        }
        return Collections.unmodifiableList(this._wfErrors);
    }

    public DomModel.FragmentParseResult parseFragment(Node node, Map map, String string) {
        this.acquireReadLock();
        try {
            Document document = this.getDocument();
            if (document != null) {
                BufferDomFragmentParser bufferDomFragmentParser = new BufferDomFragmentParser(this.getDOMImplementation(), this.getParserConfiguration(), this.getWhitespaceHandler());
                DocumentFragment documentFragment = bufferDomFragmentParser.parseFragment(document, node, map, string);
                DomModel.FragmentParseResult fragmentParseResult = this.createFragmentParseResult(documentFragment);
                this.releaseReadLock();
                return fragmentParseResult;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return null;
    }

    public XmlDeclarationInfo getXmlDeclarationInfo() {
        this.verifyLock();
        return this._xmlDeclarationInfo;
    }

    protected UndoableEdit setXmlDeclarationInfoImpl(XmlDeclarationInfo xmlDeclarationInfo) {
        StringBuffer stringBuffer = null;
        DeclarationLocator declarationLocator = this.getXMLDeclarationLocator();
        if (xmlDeclarationInfo == null) {
            if (declarationLocator == null) {
                return null;
            }
        } else {
            if (declarationLocator != null && ((Locator)declarationLocator).getStartOffset() == 0 && xmlDeclarationInfo.equals(this._xmlDeclarationInfo)) {
                return null;
            }
            stringBuffer = xmlDeclarationInfo.getAsXml();
            stringBuffer.append('\n');
        }
        UndoableEdit undoableEdit = null;
        this._textSyncInProgress = true;
        this._textBuffer.beginEdit();
        try {
            if (declarationLocator != null) {
                Node node;
                int n = ((Locator)declarationLocator).getStartOffset();
                int n2 = ((Locator)declarationLocator).getEndOffset();
                Document document = this.getDocument();
                Node node2 = node = document == null ? null : document.getFirstChild();
                if (node != null) {
                    Locator locator = this._getLocatorDirectly(node);
                    n2 = Math.max(n2, locator.getStartOffset());
                }
                this._textBuffer.remove(n, n2 - n);
            }
            if (stringBuffer != null) {
                this._textBuffer.insert(0, stringBuffer.toString().toCharArray());
            }
        }
        finally {
            undoableEdit = this._textBuffer.endEdit();
            this._textSyncInProgress = false;
        }
        if (undoableEdit != null) {
            this._ensureSynchronizedImmediate();
            return new ForceReparseUndoableEditWrapper(this, undoableEdit);
        }
        return null;
    }

    protected void reformatSubtreeImpl(String string, Node node, Object object) {
        this.startTransaction(string);
        try {
            this.acquireWriteLockDirectly();
            this._reformatPC = new ReformatPCWrapper(this._parserConfiguration, this, node, object);
            if (DomUtils.isDocument((Node)node)) {
                NodeList nodeList;
                Element element = ((Document)node).getDocumentElement();
                ElementLocator elementLocator = (ElementLocator)this._getLocatorDirectly(element);
                if (elementLocator.getNameLocator().getLength() == 0) {
                    node = element;
                }
                if ((nodeList = node.getChildNodes()).getLength() > 0) {
                    Node[] nodeArray = new Node[nodeList.getLength()];
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Node node2 = nodeList.item(n);
                        if (node2.getNodeType() != 10) {
                            nodeArray[n] = node2;
                            this._removeUnspecifiedAttributes(node2);
                        }
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < nodeArray.length) {
                        Node node3 = nodeArray[n2];
                        if (node3 != null) {
                            node.removeChild(node3);
                        }
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < nodeArray.length) {
                        Node node4 = nodeArray[n3];
                        if (node4 != null) {
                            DomUtils.insertChildAtIndex((Node)node4, (Node)node, (int)n3);
                        }
                        ++n3;
                    }
                }
            } else {
                Node node5 = node.getParentNode();
                Node node6 = node.getNextSibling();
                node5.removeChild(node);
                node5.insertBefore(node, node6);
            }
            this.commitTransaction();
        }
        finally {
            this._reformatPC = null;
            this.releaseWriteLockDirectly();
        }
    }

    protected void startRedoTransaction() {
        super.startRedoTransaction();
        this._inUndoRedoTxn = true;
    }

    protected void startUndoTransaction() {
        super.startUndoTransaction();
        this._inUndoRedoTxn = true;
    }

    protected void refreshModel(boolean bl) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "refreshModel syncedCount={0} thread={1}", new Object[]{IntegerUtils.getInteger((int)this._synchedChangeCount), Thread.currentThread()});
        }
        if (bl) {
            this._forceParse = true;
        }
        this._ensureSynchronizedImmediate();
    }

    public boolean needsReparse() {
        return this._isOutOfSync();
    }

    protected LocatorManager getLocatorManager() {
        return this._manager;
    }

    protected void mapNodeToLocator(Node node, Locator locator) {
        if (node != null) {
            if (locator == null) {
                this._locatorMap.remove(node);
            } else {
                this._locatorMap.put(node, locator);
            }
        }
    }

    protected void nodeSubtreeInserted(Node node) {
        Locator locator = this._getLocatorDirectly(node);
        if (locator == null) {
            throw new IllegalArgumentException("Nodes must be mapped to Locators prior to calling this method.");
        }
        this._attachNodeLocators(node, false);
        this._manager.charactersAdded(locator.getStartOffset(), locator.getLength());
        this._attachNodeLocators(node, true);
    }

    protected void nodeSubtreeRemoved(Node node) {
        Locator locator = this._getLocatorDirectly(node);
        if (locator == null) {
            throw new IllegalArgumentException("Nodes must be mapped to Locators prior to calling this method.");
        }
        this._attachNodeLocators(node, false);
        this._manager.charactersRemoved(locator.getStartOffset(), locator.getLength());
    }

    protected void getTextOffsetsImpl(Node node, int[] nArray) {
        if (DomUtils.isDocument((Node)node)) {
            nArray[0] = 0;
            nArray[1] = this._textBuffer.getLength();
        } else {
            Locator locator = this._getLocatorDirectly(node);
            if (locator == null) {
                super.getTextOffsetsImpl(node, nArray);
            } else {
                nArray[0] = locator.getStartOffset();
                nArray[1] = locator.getEndOffset();
            }
        }
    }

    protected int getTextOffsetImpl(DomPosition domPosition) {
        Node node = domPosition.getTargetNode();
        int n = domPosition.getRelativePosition();
        Locator locator = this._getLocatorDirectly(node);
        if (locator != null) {
            switch (n) {
                case 1: {
                    return locator.getStartOffset();
                }
                case 2: {
                    return locator.getEndOffset();
                }
                case 0: {
                    if (domPosition.hasTextOffset()) {
                        return this._getSubNodeTextOffset(domPosition, locator);
                    }
                    if (DomUtils.isElement((Node)node)) {
                        Locator locator2;
                        Node node2 = node.getLastChild();
                        if (node2 != null && (locator2 = this._getLocatorDirectly(node2)) != null) {
                            return locator2.getEndOffset();
                        }
                        ElementLocator elementLocator = (ElementLocator)locator;
                        SimpleLocator simpleLocator = elementLocator.getEndTagLocator();
                        if (simpleLocator != null) {
                            return ((Locator)simpleLocator).getStartOffset();
                        }
                        return locator.getEndOffset();
                    }
                    return locator.getEndOffset();
                }
            }
        }
        return -1;
    }

    protected Node getNodeAtOffsetImpl(int n) {
        return this._getNodeAtOffsetHelper(this.getDocument(), n);
    }

    protected DomPosition getDomPositionImpl(int n, boolean bl) {
        DomPosition domPosition = null;
        Node node = this._getNodeContainingCaretPosition(this.getDocument(), n);
        if (node == null) {
            node = this.getDocument();
        }
        if (node != null) {
            SimpleLocator simpleLocator;
            ElementLocator elementLocator;
            if (node.getNodeType() == 1 && (elementLocator = (ElementLocator)this._getLocatorDirectly(node)) != null && (simpleLocator = elementLocator.getStartTagLocator()) != null && n > ((Locator)simpleLocator).getStartOffset() && n < ((Locator)simpleLocator).getEndOffset()) {
                Element element;
                NamedNodeMap namedNodeMap;
                if (bl && (namedNodeMap = (element = (Element)node).getAttributes()) != null) {
                    int n2 = namedNodeMap.getLength();
                    int n3 = 0;
                    while (n3 < n2) {
                        TextLocator textLocator;
                        Attr attr = (Attr)namedNodeMap.item(n3);
                        AttributeLocator attributeLocator = (AttributeLocator)this._getLocatorDirectly(attr);
                        if (attributeLocator != null && (textLocator = attributeLocator.getValueLocator()) != null && n > textLocator.getStartOffset() && n < textLocator.getEndOffset()) {
                            int n4 = this._convertToDomContentPosition(textLocator, n);
                            domPosition = DomPositionFactory.createAttributePosition((Attr)attr, (int)n4);
                            break;
                        }
                        ++n3;
                    }
                }
                if (domPosition == null) {
                    domPosition = DomPositionFactory.inside((Node)node);
                }
            }
            if (domPosition == null) {
                Node node2 = node.getFirstChild();
                if (node2 != null) {
                    Node node3 = node2;
                    Node node4 = null;
                    while (node3 != null) {
                        Locator locator = this._getLocatorDirectly(node3);
                        if (locator != null) {
                            if (n < locator.getEndOffset()) break;
                            node4 = node3;
                        }
                        node3 = node3.getNextSibling();
                    }
                    domPosition = node4 != null ? DomPositionFactory.after(node4) : DomPositionFactory.before((Node)node2);
                } else {
                    domPosition = DomPositionFactory.createInsideOrAfterPosition((Node)node);
                }
            }
        }
        return domPosition;
    }

    protected SortedSet getSortedAttributesSet(Node node) {
        TreeSet<Node> treeSet = new TreeSet<Node>(this.getNodeByLocatorComparator());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                treeSet.add(namedNodeMap.item(n));
                ++n;
            }
        }
        return treeSet;
    }

    protected Comparator getNodeByLocatorComparator() {
        return this._nodeComparatorByLocator;
    }

    protected void handleUncommittedMutationEventHook(DomChange domChange, MutationEvent mutationEvent, boolean bl) {
        super.handleUncommittedMutationEventHook(domChange, mutationEvent, bl);
        if (bl) {
            this._textSync.handleChange(domChange, mutationEvent);
        }
    }

    protected void handleChangeRollbackPreHook(DomChange domChange) {
        super.handleChangeRollbackPreHook(domChange);
        this._textSync.preRollbackChange(domChange);
    }

    protected void handleChangeRollbackPostHook(DomChange domChange) {
        super.handleChangeRollbackPostHook(domChange);
        this._textSync.postRollbackChange(domChange);
    }

    protected void handleUndoableEditHook(UndoableEdit undoableEdit) {
        super.handleUndoableEditHook(undoableEdit);
        if (undoableEdit instanceof DomChangesUndoableEdit) {
            this._textSyncInProgress = true;
            UndoableEdit undoableEdit2 = this._textSync.applyChanges();
            if (undoableEdit2 != null) {
                ((DomChangesUndoableEdit)undoableEdit).addSubEdit(undoableEdit2);
            }
            this._synchedChangeCount = this._textBuffer.getChangeId();
            this._textSyncInProgress = false;
        }
    }

    protected void handleUndoOccuredPreHook(DomChangesUndoableEdit domChangesUndoableEdit) {
        this._textSyncInProgress = true;
    }

    protected void handleUndoOccuredPostHook(DomChangesUndoableEdit domChangesUndoableEdit) {
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    protected void handleRedoOccuredPreHook(DomChangesUndoableEdit domChangesUndoableEdit) {
        this._textSyncInProgress = true;
    }

    protected void handleRedoOccuredPostHook(DomChangesUndoableEdit domChangesUndoableEdit) {
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    protected TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    protected Map getExtraPropertyChanges(Node node, int n, boolean bl) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "WFCheck getExtraProps: nested={0} target={1} flags={2}", new Object[]{bl, node, new Integer(n)});
        }
        if (!bl && (n & 0x1F) > 0) {
            List list = this._wfErrors;
            if (!this._inUndoRedoTxn && list != null && list.isEmpty() && node != null && node.getNodeType() != 9) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "WFCheck skipped: target={0} oldErrs={1} flags={2}", new Object[]{node, list, new Integer(n)});
                }
            } else {
                if (list != null && !list.isEmpty()) {
                    for (DomParseProblem domParseProblem : list) {
                        domParseProblem.dispose();
                    }
                }
                this._doWfCheck();
                Collections.sort(this._wfErrors);
                PropertyChange propertyChange = new PropertyChange("parseProblems", list, this._wfErrors);
                return Collections.singletonMap(propertyChange.getPropertyName(), propertyChange);
            }
        }
        return null;
    }

    protected final ParserConfiguration getParserConfiguration() {
        ParserConfiguration parserConfiguration = this._reformatPC;
        if (parserConfiguration != null) {
            return parserConfiguration;
        }
        return this._parserConfiguration;
    }

    protected UndoableEdit removeDocTypeImpl() {
        Locator locator = this.getDocumentTypeLocator();
        if (locator != null) {
            Locator locator2;
            Node node;
            int n = locator.getStartOffset();
            int n2 = locator.getEndOffset();
            DocumentType documentType = this._getDocType();
            if (documentType != null && (node = documentType.getNextSibling()) != null && (locator2 = this._getLocatorDirectly(node)) != null) {
                n2 = locator2.getStartOffset();
            }
            this._textBuffer.beginEdit();
            this._textSyncInProgress = true;
            UndoableEdit undoableEdit = null;
            try {
                this._textBuffer.remove(n, n2 - n);
            }
            finally {
                undoableEdit = this._textBuffer.endEdit();
                this._textSyncInProgress = false;
            }
            if (undoableEdit != null) {
                this._ensureSynchronizedImmediate();
                return new ForceReparseUndoableEditWrapper(this, undoableEdit);
            }
        }
        return null;
    }

    protected UndoableEdit setDocTypeImpl(String string, String string2, String string3) {
        int n = 34;
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<!DOCTYPE ");
        stringBuffer.append(string);
        if (string3 != null) {
            stringBuffer.append(" ");
            if (string2 != null) {
                stringBuffer.append("PUBLIC ");
                stringBuffer.append('\"');
                stringBuffer.append(string2);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append("SYSTEM");
            }
            stringBuffer.append(" ");
            stringBuffer.append('\"');
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        } else if (string2 != null) {
            this.getLogger().log(Level.WARNING, "Tried to set public ID to ''{0}'' with no system id!", string2);
        }
        stringBuffer.append(">");
        UndoableEdit undoableEdit = null;
        this._textSyncInProgress = true;
        this._textBuffer.beginEdit();
        try {
            int n2;
            Locator locator = this.getDocumentTypeLocator();
            if (locator != null) {
                n2 = locator.getStartOffset();
                this._textBuffer.remove(n2, locator.getLength());
            } else {
                DeclarationLocator declarationLocator = this.getXMLDeclarationLocator();
                if (declarationLocator != null) {
                    stringBuffer.insert(0, '\n');
                    n2 = ((Locator)declarationLocator).getEndOffset();
                } else {
                    n2 = 0;
                    stringBuffer.append('\n');
                }
            }
            this._textBuffer.insert(n2, stringBuffer.toString().toCharArray());
        }
        finally {
            this._textSyncInProgress = false;
            undoableEdit = this._textBuffer.endEdit();
        }
        this._ensureSynchronizedImmediate();
        if (undoableEdit == null) {
            return null;
        }
        return new ForceReparseUndoableEditWrapper(this, undoableEdit);
    }

    protected Attr setUnspecifiedAttributeImpl(Element element, String string, String string2, String string3) {
        this._inSetUnspecifiedAttribute = true;
        try {
            Attr attr = super.setUnspecifiedAttributeImpl(element, string, string2, string3);
            this._inSetUnspecifiedAttribute = false;
            return attr;
        }
        catch (Throwable throwable) {
            this._inSetUnspecifiedAttribute = false;
            throw throwable;
        }
    }

    boolean __isInSetUnspecifiedAttribute() {
        return this._inSetUnspecifiedAttribute;
    }

    private void _attachTextBufferListener() {
        if (this._textBuffer != null) {
            this._weakTextBufferListenerWrapper = (TextBufferListener)WeakListenerProxy.create(TextBufferListener.class, (Object)this._textBufferListener, (Object)this._textBuffer, (String)"removeTextBufferListener");
            this._textBuffer.addTextBufferListener(this._weakTextBufferListenerWrapper);
        }
    }

    private void _detachTextBufferListener() {
        if (this._textBuffer != null && this._weakTextBufferListenerWrapper != null) {
            this._textBuffer.removeTextBufferListener(this._weakTextBufferListenerWrapper);
            this._weakTextBufferListenerWrapper = null;
        }
    }

    private DocumentType _getDocType() {
        Document document = this.getDocument();
        if (document != null) {
            return document.getDoctype();
        }
        return null;
    }

    private int _convertToDomContentPosition(TextLocator textLocator, int n) {
        int n2 = 0;
        return n2;
    }

    private int _getSubNodeTextOffset(DomPosition domPosition, Locator locator) {
        Node node = domPosition.getTargetNode();
        int n = domPosition.getTextOffset();
        if (domPosition.hasAttributeQName()) {
            Attr attr = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)domPosition.getAttributeQName());
            if (attr == null || this.isUnspecifiedAttribute(attr)) {
                return -1;
            }
            node = attr;
            locator = this._getLocatorDirectly(attr);
        }
        if (n < 0 || n > node.getNodeValue().length()) {
            return -1;
        }
        switch (node.getNodeType()) {
            case 3: {
                return ((TextLocator)locator).getContentTextOffset(n);
            }
            case 2: {
                AttributeLocator attributeLocator = (AttributeLocator)locator;
                TextLocator textLocator = attributeLocator.getValueLocator();
                if (textLocator == null) {
                    return -1;
                }
                int n2 = textLocator.getContentTextOffset(n);
                if (n2 != -1 && attributeLocator.isStartQuotePresent()) {
                    ++n2;
                }
                return n2;
            }
            case 4: {
                return locator.getStartOffset() + 9 + n;
            }
            case 8: {
                return locator.getStartOffset() + 4 + n;
            }
        }
        throw new IllegalArgumentException("no subnode location for " + domPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node _getNodeAtOffsetHelper(Node node, int n) {
        boolean bl = false;
        if (node == null) return null;
        Locator locator = this._getLocatorDirectly(node);
        if (locator != null) {
            if (!locator.contains(n)) return null;
            bl = true;
        }
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            Node node2 = node.getFirstChild();
            Node node3 = null;
            while (node2 != null) {
                node3 = this._getNodeAtOffsetHelper(node2, n);
                if (node3 != null) {
                    return node3;
                }
                node2 = node2.getNextSibling();
            }
        }
        if (!bl) return null;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node _getNodeContainingCaretPosition(Node node, int n) {
        boolean bl = false;
        if (node == null) return null;
        Locator locator = this._getLocatorDirectly(node);
        if (locator != null) {
            if (n <= locator.getStartOffset() || n >= locator.getEndOffset()) return null;
            bl = true;
        }
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            Node node2 = node.getFirstChild();
            Node node3 = null;
            while (node2 != null) {
                node3 = this._getNodeContainingCaretPosition(node2, n);
                if (node3 != null) {
                    return node3;
                }
                node2 = node2.getNextSibling();
            }
        }
        if (!bl) return null;
        return node;
    }

    private void _ensureSynchronizedImmediate() {
        if (this._immediateParseInProgress) {
            return;
        }
        if (this._textSyncInProgress) {
            return;
        }
        try {
            this._immediateParseInProgress = true;
            this._realEnsureSynchronizedImmediate();
        }
        finally {
            this._immediateParseInProgress = false;
        }
    }

    private void _realEnsureSynchronizedImmediate() {
        if (this._currentTask != null) {
            this._currentTask.cancel();
            this._currentTask = null;
        }
        if (this._isOutOfSync()) {
            this._forceParse = false;
            Integer[] integerArray = new Integer[2];
            integerArray[0] = IntegerUtils.getInteger((int)this._synchedChangeCount);
            long l = System.currentTimeMillis();
            LocatorManager locatorManager = new LocatorManager(this._textBuffer.getLineMap());
            HashMap hashMap = new HashMap();
            Document document = BufferDomModel._parseCurrentTextBuffer(this._parser, this._textBuffer, locatorManager, hashMap, integerArray, this.getLogger());
            long l2 = System.currentTimeMillis();
            Logger logger = this.getLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "BufferDom parse time (foreground): {0}ms file={1}", new Object[]{new Long(l2 - l), this});
            }
            this._changeDocument(document, this._parser.__getXmlDeclarationInfo(), locatorManager, hashMap, integerArray);
        }
    }

    private void _ensureSynchronizedThreaded() {
        if (this._isOutOfSync()) {
            BufferDomDocumentParser bufferDomDocumentParser = new BufferDomDocumentParser(this._parser.getDOMImplementation(), this._parser.getParserConfiguration(), this._parser.getWhitespaceHandler());
            LocatorManager locatorManager = new LocatorManager(this._textBuffer.getLineMap());
            HashMap hashMap = new HashMap();
            Integer[] integerArray = new Integer[2];
            integerArray[0] = IntegerUtils.getInteger((int)this._synchedChangeCount);
            long l = System.currentTimeMillis();
            Document document = BufferDomModel._parseCurrentTextBuffer(bufferDomDocumentParser, this._textBuffer, locatorManager, hashMap, integerArray, this.getLogger());
            long l2 = System.currentTimeMillis();
            Logger logger = this.getLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "BufferDom parse time (background, thread={0}): {1}ms file={2}", new Object[]{Thread.currentThread(), new Long(l2 - l), this});
            }
            this._changeDocument(document, bufferDomDocumentParser.__getXmlDeclarationInfo(), locatorManager, hashMap, integerArray);
        }
    }

    private boolean _isOutOfSync() {
        if (this._textSyncInProgress) {
            return false;
        }
        if (this._forceParse) {
            return true;
        }
        return this._synchedChangeCount != this._textBuffer.getChangeId();
    }

    private static Document _parseCurrentTextBuffer(BufferDomDocumentParser bufferDomDocumentParser, TextBuffer textBuffer, LocatorManager locatorManager, HashMap hashMap, Integer[] integerArray, Logger logger) {
        Document document = null;
        locatorManager.clear();
        hashMap.clear();
        try {
            try {
                textBuffer.readLock();
                integerArray[1] = IntegerUtils.getInteger((int)textBuffer.getChangeId());
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "About to parse; oldCount={0} newCount={1} thread={2}", new Object[]{integerArray[0], integerArray[1], Thread.currentThread().getName()});
                }
                document = bufferDomDocumentParser.parse((ReadTextBuffer)textBuffer, locatorManager, hashMap);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "DONE parse; oldCount={0} newCount={1} thread={2}", new Object[]{integerArray[0], integerArray[1], Thread.currentThread().getName()});
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "BufferDomModel Parse Failed", exception);
                document = null;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return document;
    }

    static {
        $assertionsDisabled = BufferDomModel.class.desiredAssertionStatus() ^ true;
        _updateTimer = new NamedTimer("BufferDomModel background parse thread", 1, true);
    }

    private void _changeDocument(Document document, XmlDeclarationInfo xmlDeclarationInfo, LocatorManager locatorManager, HashMap hashMap, Integer[] integerArray) {
        if (!$assertionsDisabled && !BufferDomModel._assertLocatorStateAfterReparse(document, xmlDeclarationInfo, locatorManager, hashMap)) {
            throw new AssertionError();
        }
        if (integerArray[0] == this._synchedChangeCount) {
            this._acquireWriteLockDirectly(false);
            this._subsequentWriteLocksShouldNotWriteLockBuffer = true;
            try {
                this._synchedChangeCount = integerArray[1];
                this.firePropertyChange("textBufferModified", Boolean.FALSE, Boolean.TRUE);
                if (this._manager != locatorManager) {
                    this._manager.clear();
                    this._manager = locatorManager;
                }
                if (this._locatorMap != hashMap) {
                    this._locatorMap.clear();
                    this._locatorMap = hashMap;
                }
                this._xmlDeclarationInfo = xmlDeclarationInfo;
                this.replaceDocument(document);
                if (document != null) {
                    this._updateIndentationSize();
                }
            }
            finally {
                this._subsequentWriteLocksShouldNotWriteLockBuffer = false;
                this.releaseWriteLockDirectly();
            }
        }
    }

    private void _attachNodeLocators(Node node, boolean bl) {
        Locator locator = this._getLocatorDirectly(node);
        Locator.attach(this._manager, bl, locator);
        if (node.getNodeType() == 1) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this._attachNodeLocators(node2, bl);
                node2 = node2.getNextSibling();
            }
            Element element = (Element)node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr = (Attr)namedNodeMap.item(n2);
                    if (attr != null) {
                        this._attachNodeLocators(attr, bl);
                    }
                    ++n2;
                }
            }
        }
    }

    private void _updateIndentationSize() {
        Element element;
        Document document = this.getDocumentInternal();
        if (document != null && (element = document.getDocumentElement()) != null) {
            int[] nArray = new int[8];
            ElementLocator elementLocator = (ElementLocator)this._getLocatorDirectly(element);
            this._findIndentationSizeForChildren(element, elementLocator, nArray);
            int n = 0;
            int n2 = -1;
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] > n) {
                    n2 = n3 + 1;
                    n = nArray[n3];
                }
                ++n3;
            }
            if (n2 != -1) {
                this._indentationSize = n2;
            }
        }
    }

    private void _findIndentationSizeForChildren(Element element, ElementLocator elementLocator, int[] nArray) {
        this._findIndentationSizeForChildrenHelper(element, elementLocator, nArray, 0);
    }

    private void _findIndentationSizeForChildrenHelper(Element element, ElementLocator elementLocator, int[] nArray, int n) {
        SimpleLocator simpleLocator;
        if (n >= 8) {
            return;
        }
        if (elementLocator == null) {
            simpleLocator = null;
            this.getLogger().log(Level.SEVERE, "Null locator in findIndentationSize! node={0} model={1}", new Object[]{element.getNodeName(), this});
        } else {
            simpleLocator = elementLocator.getStartTagLocator();
        }
        int n2 = 0;
        Node node = element.getFirstChild();
        while (node != null && n2 < 10) {
            int n3;
            Locator locator = this._getLocatorDirectly(node);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                ElementLocator elementLocator2 = (ElementLocator)locator;
                n3 = simpleLocator == null ? -1 : this._getIndentationBetweenLocators(simpleLocator, elementLocator2.getStartTagLocator());
                this._findIndentationSizeForChildrenHelper(element2, elementLocator2, nArray, n + 1);
            } else {
                n3 = this._getIndentationBetweenLocators(simpleLocator, locator);
            }
            if (n3 > 0 && n3 <= 8) {
                int n4 = n3 - 1;
                nArray[n4] = nArray[n4] + 1;
            }
            node = node.getNextSibling();
            ++n2;
        }
    }

    private int _getIndentationBetweenLocators(Locator locator, Locator locator2) {
        if (locator.getStartLineNumber() == locator2.getStartLineNumber()) {
            return 0;
        }
        return locator2.getStartColumnNumber() - locator.getStartColumnNumber();
    }

    private void _doWfCheck() {
        this._wfErrors = this._parserConfiguration.doWellFormednessCheck(this, this.getTextBuffer());
    }

    private void _removeUnspecifiedAttributes(Node node) {
        Node node2;
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)DomUtils.getOwnerDocument((Node)node))).createNodeIterator(node, 1, null, false);
        ArrayList<Attr> arrayList = new ArrayList<Attr>(5);
        while ((node2 = nodeIterator.nextNode()) != null) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                if (this.isUnspecifiedAttribute(attr)) {
                    arrayList.add(attr);
                }
                ++n;
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            Attr attr = (Attr)arrayList.get(n);
            attr.getOwnerElement().removeAttributeNode(attr);
            ++n;
        }
        nodeIterator.detach();
    }

    private static boolean _assertLocatorStateAfterReparse(Document document, XmlDeclarationInfo xmlDeclarationInfo, LocatorManager locatorManager, Map map) {
        if (!$assertionsDisabled && document == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && locatorManager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        BufferDomModel._assertLocatorStateForNode(document, locatorManager, map);
        if (xmlDeclarationInfo != null) {
            BufferDomModel._assertLocatorOK(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY, map, locatorManager);
        }
        return true;
    }

    private static void _assertLocatorStateForNode(Node node, LocatorManager locatorManager, Map map) {
        BufferDomModel._assertLocatorOK(node, map, locatorManager);
        if (node.getNodeType() != 2) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                BufferDomModel._assertLocatorStateForNode(node2, locatorManager, map);
                node2 = node2.getNextSibling();
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    BufferDomModel._assertLocatorStateForNode(namedNodeMap.item(n), locatorManager, map);
                    ++n;
                }
            }
        }
    }

    private static void _assertLocatorOK(Object object, Map map, LocatorManager locatorManager) {
        if (object instanceof DocumentType) {
            object = BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY;
        } else if (object instanceof Document) {
            return;
        }
        Object v = map.get(object);
        if (!$assertionsDisabled && v == null) {
            throw new AssertionError((Object)("locator null for key " + object));
        }
        if (!$assertionsDisabled && !(v instanceof Locator)) {
            throw new AssertionError((Object)("locator has wrong type for key " + object));
        }
    }

    void $init$() {
        this._currentTask = null;
        this._forceParse = true;
        this._textSyncInProgress = false;
        this._immediateParseInProgress = false;
        this._inUndoRedoTxn = false;
        this._indentationSize = 2;
        this._xmlDeclarationInfo = null;
        this._inSetUnspecifiedAttribute = false;
        this._subsequentWriteLocksShouldNotWriteLockBuffer = false;
        this._reformatPC = null;
        this._textSync = new BufferDomTextSync(this);
        this._nodeComparatorByLocator = new NodeComparatorByLocator(null);
        this._textBufferListener = new TextBufferChangeListener(null);
        this._domLock = new ReadWriteLock();
        this._bufferWriteUnlockers = new LinkedList();
        this._UNLOCKER_WRITE = new 2();
        this._UNLOCKER_READ = new 1();
    }

    static boolean ra$_textSyncInProgress(BufferDomModel bufferDomModel) {
        return bufferDomModel._textSyncInProgress;
    }

    static UpdateTimerTask ra$_currentTask(BufferDomModel bufferDomModel) {
        return bufferDomModel._currentTask;
    }

    static void wa$_currentTask(BufferDomModel bufferDomModel, UpdateTimerTask updateTimerTask) {
        bufferDomModel._currentTask = updateTimerTask;
    }

    static Timer ra$_updateTimer() {
        return _updateTimer;
    }

    static void mav$handleReadOnlyStatusChange(BufferDomModel bufferDomModel) {
        bufferDomModel.handleReadOnlyStatusChange();
    }

    static Locator mav$_getLocatorDirectly(BufferDomModel bufferDomModel, Node node) {
        return bufferDomModel._getLocatorDirectly(node);
    }

    static void mav$_ensureSynchronizedThreaded(BufferDomModel bufferDomModel) {
        bufferDomModel._ensureSynchronizedThreaded();
    }

    static void wa$_textSyncInProgress(BufferDomModel bufferDomModel, boolean bl) {
        bufferDomModel._textSyncInProgress = bl;
    }

    static void mav$_ensureSynchronizedImmediate(BufferDomModel bufferDomModel) {
        bufferDomModel._ensureSynchronizedImmediate();
    }

    static TextBuffer ra$_textBuffer(BufferDomModel bufferDomModel) {
        return bufferDomModel._textBuffer;
    }

    private class TextBufferChangeListener
    implements TextBufferListener {
        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            this._onTextBufferModification();
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            this._onTextBufferModification();
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
            if (n == 2) {
                BufferDomModel.mav$handleReadOnlyStatusChange(BufferDomModel.this);
            }
        }

        private void _onTextBufferModification() {
            if (!BufferDomModel.ra$_textSyncInProgress(BufferDomModel.this)) {
                if (BufferDomModel.ra$_currentTask(BufferDomModel.this) != null) {
                    BufferDomModel.ra$_currentTask(BufferDomModel.this).cancel();
                }
                BufferDomModel.wa$_currentTask(BufferDomModel.this, new UpdateTimerTask(BufferDomModel.this));
                BufferDomModel.ra$_updateTimer().schedule((TimerTask)BufferDomModel.ra$_currentTask(BufferDomModel.this), 750L);
            }
        }

        private TextBufferChangeListener() {
        }

        TextBufferChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class NodeComparatorByLocator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            return this._compare((Node)object, (Node)object2);
        }

        private int _compare(Node node, Node node2) {
            Locator locator = BufferDomModel.mav$_getLocatorDirectly(BufferDomModel.this, node);
            Locator locator2 = BufferDomModel.mav$_getLocatorDirectly(BufferDomModel.this, node2);
            if (locator == null) {
                return -1;
            }
            if (locator2 == null) {
                return 1;
            }
            int n = locator.getStartOffset() - locator2.getStartOffset();
            if (n == 0) {
                return locator.getEndOffset() - locator2.getEndOffset();
            }
            return n;
        }

        private NodeComparatorByLocator() {
        }

        NodeComparatorByLocator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class UpdateTimerTask
    extends TimerTask {
        private final Reference _modelRef;

        public UpdateTimerTask(BufferDomModel bufferDomModel) {
            this._modelRef = bufferDomModel.getDomModelReference();
        }

        public void run() {
            BufferDomModel bufferDomModel = (BufferDomModel)this._modelRef.get();
            if (bufferDomModel != null) {
                BufferDomModel.mav$_ensureSynchronizedThreaded(bufferDomModel);
            }
        }
    }

    private static class ForceReparseUndoableEditWrapper
    extends UndoableEditWrapper {
        private final UndoableEdit _textEdit;
        private final Reference _modelRef;

        public ForceReparseUndoableEditWrapper(BufferDomModel bufferDomModel, UndoableEdit undoableEdit) {
            this._textEdit = undoableEdit;
            this._modelRef = bufferDomModel.getDomModelReference();
        }

        protected UndoableEdit getBaseEdit() {
            return this._textEdit;
        }

        public void redo() throws CannotRedoException {
            BufferDomModel bufferDomModel = (BufferDomModel)this._modelRef.get();
            if (bufferDomModel == null) {
                super.redo();
            } else {
                BufferDomModel.wa$_textSyncInProgress(bufferDomModel, true);
                try {
                    super.redo();
                }
                finally {
                    BufferDomModel.wa$_textSyncInProgress(bufferDomModel, false);
                }
                BufferDomModel.mav$_ensureSynchronizedImmediate(bufferDomModel);
            }
        }

        public void undo() throws CannotUndoException {
            BufferDomModel bufferDomModel = (BufferDomModel)this._modelRef.get();
            if (bufferDomModel == null) {
                super.undo();
            } else {
                BufferDomModel.wa$_textSyncInProgress(bufferDomModel, true);
                try {
                    super.undo();
                }
                finally {
                    BufferDomModel.wa$_textSyncInProgress(bufferDomModel, false);
                }
                BufferDomModel.mav$_ensureSynchronizedImmediate(bufferDomModel);
            }
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            BufferDomModel.ra$_textBuffer(BufferDomModel.this).writeUnlock();
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            BufferDomModel.ra$_textBuffer(BufferDomModel.this).readUnlock();
        }
    }
}

