/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.SyncToTextDomChangeHandler;
import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.textsync.BufferChange;
import oracle.bali.xml.dom.buffer.textsync.Reformatter;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.share.ReverseListIterator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.events.MutationEvent;

public class BufferDomTextSync {
    private final List _bufferChanges;
    private final Reformatter _reformatter;
    private final BufferDomModel _model;
    private static final Logger _LOGGER = Logger.getLogger(BufferDomTextSync.class.getName());

    public BufferDomTextSync(BufferDomModel bufferDomModel) {
        this.$init$();
        this._model = bufferDomModel;
    }

    public void handleChange(DomChange domChange, MutationEvent mutationEvent) {
        this._model.getWhitespaceHandler().beginCacheablePeriod();
        TextSyncContext textSyncContext = new TextSyncContext(this._model, mutationEvent, domChange);
        SyncToTextDomChangeHandler syncToTextDomChangeHandler = new SyncToTextDomChangeHandler(textSyncContext);
        try {
            try {
                domChange.process(syncToTextDomChangeHandler);
                this._reformatter.trackChange(domChange, textSyncContext);
            }
            catch (RuntimeException runtimeException) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)"Exception in text sync! model={0} change={1} event={2}", (Object[])new Object[]{this._model, domChange, mutationEvent}, (Throwable)runtimeException);
                throw runtimeException;
            }
        }
        finally {
            this._bufferChanges.add(textSyncContext.getBufferChange());
            this._model.getWhitespaceHandler().endCacheablePeriod();
        }
    }

    public void preRollbackChange(DomChange domChange) {
        int n = this._bufferChanges.size() - 1;
        BufferChange bufferChange = (BufferChange)this._bufferChanges.get(n);
        DomChange domChange2 = bufferChange.getCorrespondingDomChange();
        if (domChange != domChange2) {
            throw new IllegalStateException("Asked to rollback DOM change " + domChange + " but last buffer change does not " + "correspond! Buffer change=" + bufferChange);
        }
        this._reformatter.untrackChange(domChange2);
    }

    public void postRollbackChange(DomChange domChange) {
        int n = this._bufferChanges.size() - 1;
        BufferChange bufferChange = (BufferChange)this._bufferChanges.get(n);
        if (domChange != bufferChange.getCorrespondingDomChange()) {
            throw new IllegalStateException("Asked to rollback DOM change " + domChange + " but last buffer change does not " + "correspond! Buffer change=" + bufferChange);
        }
        this._bufferChanges.remove(n);
    }

    public UndoableEdit applyChanges() {
        UndoableEdit undoableEdit;
        this._model.getWhitespaceHandler().beginCacheablePeriod();
        this._buffer().beginEdit();
        try {
            BufferChange bufferChange = null;
            this._debugBuffer("before starting to apply changes");
            int n = 0;
            while (n < this._bufferChanges.size()) {
                bufferChange = (BufferChange)this._bufferChanges.get(n);
                bufferChange.apply(this._buffer());
                this._debugBuffer("after change #" + n);
                ++n;
            }
            if (bufferChange != null) {
                ReformatTextSyncContext reformatTextSyncContext = new ReformatTextSyncContext(this._model, bufferChange.getCorrespondingDomChange());
                this._reformatter.doReformatting(reformatTextSyncContext, this._buffer());
            }
        }
        finally {
            undoableEdit = this._buffer().endEdit();
            this._bufferChanges.clear();
            this._reformatter.reset();
            this._model.getWhitespaceHandler().endCacheablePeriod();
        }
        return undoableEdit;
    }

    private void _debugBuffer(String string) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "--- buffer {0} below ---\n{1}\n--- buffer {0} above ---", new Object[]{string, this._buffer().getString(0, this._buffer().getLength())});
        }
    }

    private TextBuffer _buffer() {
        return this._model.getTextBuffer();
    }

    void $init$() {
        this._bufferChanges = new ArrayList();
        this._reformatter = new Reformatter();
    }

    private static class ReformatTextSyncContext
    extends TextSyncContext {
        private final ReformatRelatedChange _relatedHandler;

        public ReformatTextSyncContext(BufferDomModel bufferDomModel, DomChange domChange) {
            super(bufferDomModel, null, domChange);
            this.$init$();
            domChange.addRelatedChange(this._relatedHandler);
        }

        public void addRelatedChange(RelatedChange relatedChange) {
            this._relatedHandler.add(relatedChange);
        }

        void $init$() {
            this._relatedHandler = new ReformatRelatedChange(null);
        }
    }

    private static class ReformatRelatedChange
    extends RelatedChange {
        private final List _realChanges;

        public void add(RelatedChange relatedChange) {
            this._realChanges.add(relatedChange);
        }

        public void postRedo(DomModel domModel, DomChange domChange) {
            for (RelatedChange relatedChange : this._realChanges) {
                relatedChange.preRedo(domModel, domChange);
                relatedChange.postRedo(domModel, domChange);
            }
        }

        public void preUndo(DomModel domModel, DomChange domChange) {
            ReverseListIterator reverseListIterator = new ReverseListIterator(this._realChanges);
            while (reverseListIterator.hasNext()) {
                RelatedChange relatedChange = (RelatedChange)reverseListIterator.next();
                relatedChange.preUndo(domModel, domChange);
                relatedChange.postUndo(domModel, domChange);
            }
        }

        void $init$() {
            this._realChanges = new ArrayList(2);
        }

        private ReformatRelatedChange() {
            this.$init$();
        }

        ReformatRelatedChange(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

