/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;

class CharsLocatorChange
extends RelatedChange {
    private final int _offset;
    private final int _length;
    private static final Logger _LOGGER = Logger.getLogger(CharsLocatorChange.class.getName());

    public CharsLocatorChange(int n, int n2) {
        this._offset = n;
        this._length = n2;
    }

    public void preUndo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._length < 0) {
            bufferDomModel.getLocatorManager().charactersAdded(this._offset, -this._length);
        } else {
            bufferDomModel.getLocatorManager().charactersRemoved(this._offset, this._length);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void postRedo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._length > 0) {
            bufferDomModel.getLocatorManager().charactersAdded(this._offset, this._length);
        } else {
            bufferDomModel.getLocatorManager().charactersRemoved(this._offset, -this._length);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }
}

