/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import org.w3c.dom.Node;

class MapNodeLocatorChange
extends RelatedChange {
    private final NodeRef _nodeRef;
    private final Locator _oldLocator;
    private final Locator _newLocator;
    private static final Logger _LOGGER = Logger.getLogger(MapNodeLocatorChange.class.getName());

    public MapNodeLocatorChange(NodeRef nodeRef, Locator locator, Locator locator2) {
        this._nodeRef = nodeRef;
        this._oldLocator = locator;
        this._newLocator = locator2;
    }

    public void preUndo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._oldLocator == null) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._nodeRef);
            Locator locator = bufferDomModel.getLocator(node);
            if (locator != null) {
                bufferDomModel.nodeSubtreeRemoved(node);
            }
            bufferDomModel.mapNodeToLocator(node, Locator.getCopy(this._oldLocator));
        }
    }

    public void postUndo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._oldLocator != null) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._nodeRef);
            Locator locator = bufferDomModel.getLocator(node);
            if (locator != null) {
                bufferDomModel.nodeSubtreeRemoved(node);
            }
            bufferDomModel.mapNodeToLocator(node, Locator.getCopy(this._oldLocator));
            bufferDomModel.nodeSubtreeInserted(node);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void preRedo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._newLocator == null) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._nodeRef);
            Locator locator = bufferDomModel.getLocator(node);
            if (locator != null) {
                bufferDomModel.nodeSubtreeRemoved(node);
            }
            bufferDomModel.mapNodeToLocator(node, Locator.getCopy(this._newLocator));
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void postRedo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._newLocator != null) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._nodeRef);
            Locator locator = bufferDomModel.getLocator(node);
            if (locator != null) {
                bufferDomModel.nodeSubtreeRemoved(node);
            }
            bufferDomModel.mapNodeToLocator(node, Locator.getCopy(this._newLocator));
            bufferDomModel.nodeSubtreeInserted(node);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }
}

