/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import org.w3c.dom.Node;

class MapSubtreeLocatorChange
extends RelatedChange {
    private final NodeRef _subtreeRoot;
    private final boolean _isInsert;
    private final ArrayList _nodeRefs;
    private final ArrayList _oldLocators;
    private final ArrayList _newLocators;
    private static final Logger _LOGGER = Logger.getLogger(MapSubtreeLocatorChange.class.getName());

    public MapSubtreeLocatorChange(Node node, boolean bl) {
        this(NodeRefFactory.getNodeRef((Node)node), bl);
    }

    public MapSubtreeLocatorChange(NodeRef nodeRef, boolean bl) {
        this.$init$();
        this._subtreeRoot = nodeRef;
        this._isInsert = bl;
    }

    public void addNode(Node node, Locator locator, Locator locator2) {
        this.addNode(NodeRefFactory.getNodeRef((Node)node), locator, locator2);
    }

    public void addNode(NodeRef nodeRef, Locator locator, Locator locator2) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "AddNode: {0} from {1} to {2}", new Object[]{nodeRef, locator, locator2});
        }
        this._nodeRefs.add(nodeRef);
        this._oldLocators.add(locator);
        this._newLocators.add(locator2);
    }

    public void doneAddingNodes() {
        this._nodeRefs.trimToSize();
        this._oldLocators.trimToSize();
        this._newLocators.trimToSize();
    }

    public void preUndo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._isInsert) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._subtreeRoot);
            bufferDomModel.nodeSubtreeRemoved(node);
            this._mapToLocators(bufferDomModel, this._oldLocators);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void postUndo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (!this._isInsert) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._subtreeRoot);
            this._mapToLocators(bufferDomModel, this._oldLocators);
            bufferDomModel.nodeSubtreeInserted(node);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void postRedo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (this._isInsert) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._subtreeRoot);
            this._mapToLocators(bufferDomModel, this._newLocators);
            bufferDomModel.nodeSubtreeInserted(node);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    public void preRedo(DomModel domModel, DomChange domChange) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
        if (!this._isInsert) {
            Node node = TextSyncUtils.getNode(bufferDomModel, this._subtreeRoot);
            bufferDomModel.nodeSubtreeRemoved(node);
            this._mapToLocators(bufferDomModel, this._newLocators);
        }
        TextSyncUtils.debugRootLocator(bufferDomModel, _LOGGER);
    }

    private void _mapToLocators(BufferDomModel bufferDomModel, ArrayList arrayList) {
        int n = 0;
        while (n < this._nodeRefs.size()) {
            NodeRef nodeRef = (NodeRef)this._nodeRefs.get(n);
            Locator locator = (Locator)arrayList.get(n);
            Node node = TextSyncUtils.getNode(bufferDomModel, nodeRef);
            locator = Locator.getCopy(locator);
            if (_LOGGER.isLoggable(Level.FINEST)) {
                _LOGGER.log(Level.FINEST, "MapSubtree: {0} --> {1}", new Object[]{node, locator});
            }
            bufferDomModel.mapNodeToLocator(node, locator);
            ++n;
        }
    }

    void $init$() {
        this._nodeRefs = new ArrayList();
        this._oldLocators = new ArrayList();
        this._newLocators = new ArrayList();
    }
}

