/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfigurationDecorator;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptionsDecorator;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ReformatPCWrapper
extends ParserConfigurationDecorator {
    private final Set _singleQuoteAttributes;
    private final Set _elementsWithEndTags;
    private final TextSyncOptions _tso;

    public ReformatPCWrapper(ParserConfiguration parserConfiguration, BufferDomModel bufferDomModel, Node node, Object object) {
        super(parserConfiguration);
        this.$init$();
        this._tso = "rule5".equals(object) ? new Rule5TSO(null) : new ReformatTSO(null);
        this._gatherInformation(bufferDomModel, node);
    }

    public TextSyncOptions getTextSyncOptions() {
        return this._tso;
    }

    private void _gatherInformation(BufferDomModel bufferDomModel, Node node) {
        this._findSingleQuoteAttrs(bufferDomModel, node);
        this._checkForNonMinimizedElement(bufferDomModel, node);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this._gatherInformation(bufferDomModel, node2);
            node2 = node2.getNextSibling();
        }
    }

    private void _checkForNonMinimizedElement(BufferDomModel bufferDomModel, Node node) {
        ElementLocator elementLocator;
        if (DomUtils.isElement((Node)node) && (elementLocator = (ElementLocator)bufferDomModel.getLocator(node)).getEndTagLocator() != null) {
            this._elementsWithEndTags.add(node);
        }
    }

    private void _findSingleQuoteAttrs(BufferDomModel bufferDomModel, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                AttributeLocator attributeLocator;
                Node node2 = namedNodeMap.item(n);
                Locator locator = bufferDomModel.getLocator(node2);
                if (locator instanceof AttributeLocator && (attributeLocator = (AttributeLocator)locator).getQuoteStyle() == 0) {
                    this._singleQuoteAttributes.add(node2);
                }
                ++n;
            }
        }
    }

    void $init$() {
        this._singleQuoteAttributes = new HashSet(27);
        this._elementsWithEndTags = new HashSet(27);
    }

    static Set ra$_elementsWithEndTags(ReformatPCWrapper reformatPCWrapper) {
        return reformatPCWrapper._elementsWithEndTags;
    }

    static Set ra$_singleQuoteAttributes(ReformatPCWrapper reformatPCWrapper) {
        return reformatPCWrapper._singleQuoteAttributes;
    }

    static TextSyncOptions mas$getTextSyncOptions(ReformatPCWrapper reformatPCWrapper) {
        return super.getTextSyncOptions();
    }

    private class ReformatTSO
    extends TextSyncOptionsDecorator {
        protected final TextSyncOptions getBaseTextSyncOptions() {
            return ReformatPCWrapper.mas$getTextSyncOptions(ReformatPCWrapper.this);
        }

        public boolean isDefaultQuoteStyleDouble(Attr attr) {
            if (ReformatPCWrapper.ra$_singleQuoteAttributes(ReformatPCWrapper.this).contains(attr)) {
                return false;
            }
            return super.isDefaultQuoteStyleDouble(attr);
        }

        public boolean useMinimizedForm(Element element) {
            if (ReformatPCWrapper.ra$_elementsWithEndTags(ReformatPCWrapper.this).contains(element)) {
                return false;
            }
            return super.useMinimizedForm(element);
        }

        public boolean prefersWhitespaceInside(Element element) {
            Node node = element.getFirstChild();
            if (DomUtils.isText((Node)node) && node == element.getLastChild()) {
                return false;
            }
            return super.prefersWhitespaceInside(element);
        }

        private ReformatTSO() {
        }

        ReformatTSO(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Rule5TSO
    extends ReformatTSO {
        public TextSyncOptions.AttributeWrapMode getAttributeWrapMode(Element element) {
            return TextSyncOptions.ATTR_WRAP_ALWAYS_JUST_INDENTED;
        }

        public boolean prefersWhitespaceInside(Element element) {
            return true;
        }

        public boolean useMinimizedForm(Element element) {
            return false;
        }

        public boolean wrapBeforeEndOfStartTag(Element element) {
            return true;
        }

        public boolean prefersWhitespaceInsideWhenEmpty(Element element) {
            return true;
        }

        private Rule5TSO() {
            super(null);
        }

        Rule5TSO(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

