/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import org.w3c.dom.Node;

class SimpleMapNodeToLocatorChange
extends RelatedChange {
    private final NodeRef _nodeRef;
    private final Locator _newLoc;
    private final Locator _oldLoc;

    public SimpleMapNodeToLocatorChange(NodeRef nodeRef, Locator locator, Locator locator2) {
        this._nodeRef = nodeRef;
        this._newLoc = locator;
        this._oldLoc = locator2;
    }

    public void preUndo(DomModel domModel, DomChange domChange) {
        this._map(domModel, this._oldLoc);
    }

    public void postRedo(DomModel domModel, DomChange domChange) {
        this._map(domModel, this._newLoc);
    }

    private void _map(DomModel domModel, Locator locator) {
        BufferDomModel bufferDomModel = (BufferDomModel)domModel;
        Node node = TextSyncUtils.getNode(domModel, this._nodeRef);
        LocatorManager locatorManager = bufferDomModel.getLocatorManager();
        Locator locator2 = bufferDomModel.getLocator(node);
        if (locator2 != null) {
            locator2.attach(locatorManager, false);
        }
        locator = Locator.getCopy(locator);
        bufferDomModel.mapNodeToLocator(node, locator);
        if (locator != null) {
            locator.attach(locatorManager, true);
        }
    }
}

