/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.DetachAttachEndTagLocatorsChange;
import oracle.bali.xml.dom.buffer.MapSubtreeLocatorChange;
import oracle.bali.xml.dom.buffer.TextSyncConfiguration;
import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.AbstractAttrChange;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.share.string.StringChange;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class SyncToTextDomChangeHandler
implements DomChangeHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final TextSyncContext _context;
    private int _curInsertOffset;
    private final StringBuffer _insertBuffer;
    private static final Logger _LOGGER;
    private static final Character _DOUBLE_QUOTE;
    private static final Character _SINGLE_QUOTE;

    public SyncToTextDomChangeHandler(TextSyncContext textSyncContext) {
        this.$init$();
        this._context = textSyncContext;
    }

    public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        Element element = this._getOwnerElement(attrAddedChange);
        this._context.requireNonNullAndInDocument(element, "attribute owner element");
        Attr attr = this._context.getEventAttr();
        this._context.requireNonNullAndInDocument(attr, "added attribute");
        if (!this._allowsAttributes(element)) {
            this._context.getModel().getLogger().log(Level.SEVERE, "Attrs unexpectedly added to {0}, which does not allow attributes. Attr={1}", new Object[]{element.getNodeName(), attr.getNodeName()});
            this._context.setBufferChangeNoOp();
            return;
        }
        this._addAttr(attrAddedChange, element, attr);
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        Element element = this._getOwnerElement(attrRemovedChange);
        this._context.requireNonNullAndInDocument(element, "attribute owner element");
        Attr attr = this._context.getEventAttr();
        this._context.requireNonNullAndInDocument(attr, "removed attribute");
        this._removeAttr(element, attr, false);
    }

    public void handleAttrValueChange(AttrValueChange attrValueChange) {
        Attr attr = this._context.getEventAttr();
        this._context.requireNonNullAndInDocument(attr, "attr whose value changed");
        boolean bl = this._checkAndWarnNullValuedAttr(attr) ^ true;
        if (bl) {
            this._removeAttr(attr.getOwnerElement(), attr, true);
        } else {
            AttributeLocator attributeLocator = (AttributeLocator)this._context.getLocatorRequired(attr);
            if (attributeLocator.isSpecified()) {
                this._changeAttr(attrValueChange, attr);
            } else {
                this._addAttr(attrValueChange, attr.getOwnerElement(), attr);
            }
        }
    }

    public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
        Node node = this._context.getEventTargetNode();
        this._context.requireNonNullAndInDocument(node, "inserted node");
        Node node2 = node.getParentNode();
        this._context.requireNonNullAndInDocument(node2, "inserted node's parent");
        short s = node2.getNodeType();
        switch (s) {
            case 1: {
                this._insertSubtreeIntoElement((Element)node2, node);
                break;
            }
            case 9: {
                this._insertSubtreeIntoDocument((Document)node2, node);
                break;
            }
            default: {
                this._context.logAssertFailure("Parent of inserted node {0} had type {1}! parent={2}", new Object[]{node, String.valueOf(node2.getNodeType()), node2});
                throw new IllegalStateException("messages logged");
            }
        }
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
        boolean bl;
        Node node = this._context.getEventTargetNode();
        this._context.requireNonNullAndInDocument(node, "removed node");
        NodeRef nodeRef = NodeRefFactory.getNodeRef((Node)node);
        Node node2 = node.getParentNode();
        this._context.requireNonNullAndInDocument(node2, "parent of removed node");
        boolean bl2 = bl = node2.getFirstChild() == node && node2.getLastChild() == node;
        if (bl && node2.getNodeType() == 1 && this._usesMinimizedForm((Element)node2)) {
            this._removeSubtreeCollapsingElement((Element)node2, node, nodeRef);
        } else {
            this._removeSubtree(node, nodeRef);
        }
    }

    public void handleNodeValueChange(NodeValueChange nodeValueChange) {
        Node node = nodeValueChange.getNodeRef().getCorrespondingNode(this._context.getModel().getDocument());
        this._context.requireNonNullAndInDocument(node, "node whose value changed");
        String string = nodeValueChange.getPrevValue();
        String string2 = nodeValueChange.getNewValue();
        if (string2.equals(string)) {
            this._context.setBufferChangeNoOp();
        } else {
            Locator locator = this._context.getLocatorRequired(node);
            if (locator instanceof SimpleLocator) {
                this._changeSimpleNodeValue(node, string2, (SimpleLocator)locator);
            } else if (locator instanceof TextLocator) {
                this._changeTextNodeValue((Text)node, (TextLocator)locator, nodeValueChange.getStringChange(), string, string2);
            } else {
                throw new IllegalStateException("invalid locator type: " + locator);
            }
        }
    }

    private void _addAttr(AbstractAttrChange abstractAttrChange, Element element, Attr attr) {
        ElementLocator elementLocator = this._context.getElementLocatorRequired(element);
        this._context.checkElementLocatorParts(elementLocator, element, true, true, false);
        SimpleLocator simpleLocator = elementLocator.getStartTagLocator();
        SimpleLocator simpleLocator2 = elementLocator.getSlashLocator();
        int n = simpleLocator2 != null ? ((Locator)simpleLocator2).getStartOffset() : (elementLocator.isStartTagComplete() ? ((Locator)simpleLocator).getEndOffset() - this._config().getStartTagEnd(element).length() : ((Locator)simpleLocator).getEndOffset());
        if (!this._checkAndWarnNullValuedAttr(attr) || this._context.getModel().__isInSetUnspecifiedAttribute()) {
            AttributeLocator attributeLocator = this._context.createZeroLengthAttrLocator(n);
            this._context.mapNodeToLocator((Node)attr, attributeLocator, null);
            this._context.setBufferChangeNoOp();
            return;
        }
        Locator locator = this._context.getLastAttributeOrNameLocator(element, elementLocator, true);
        boolean bl = locator.getEndOffset() == n;
        Locator locator2 = Locator.getCopy(this._context.getLocator(attr));
        String string = "";
        if (bl) {
            string = " ";
        }
        int n2 = n;
        this._context.noteCharactersAdded(n2, string.length());
        MapSubtreeLocatorChange mapSubtreeLocatorChange = new MapSubtreeLocatorChange(attr, true);
        abstractAttrChange.addRelatedChange(mapSubtreeLocatorChange);
        String string2 = this._createAttrTextAndLocator(mapSubtreeLocatorChange, attr, n2 + string.length(), locator2);
        mapSubtreeLocatorChange.doneAddingNodes();
        this._context.getModel().nodeSubtreeInserted(attr);
        this._context.setBufferChangeInsert(n2, string + string2);
    }

    private void _removeAttr(Element element, Attr attr, boolean bl) {
        AttributeLocator attributeLocator;
        Locator locator = this._context.getLocatorRequired(attr);
        int n = locator.getStartOffset();
        int n2 = locator.getLength();
        SortedSet sortedSet = this._context.getModel().getSortedAttributesSet(element);
        SortedSet<Attr> sortedSet2 = sortedSet.headSet(attr);
        Locator locator2 = sortedSet2.isEmpty() ? this._context.getElementLocatorRequired(element).getNameLocator() : this._context.getLocatorRequired(sortedSet2.last());
        int n3 = locator2.getEndOffset();
        int n4 = n - n3;
        this._context.getModel().nodeSubtreeRemoved(attr);
        if (bl) {
            attributeLocator = this._context.createZeroLengthAttrLocator(n3);
            this._context.attachLocator(attributeLocator);
        } else {
            attributeLocator = null;
        }
        this._context.mapAttrToLocator(element, attr, attributeLocator);
        if (n4 > 0) {
            n = n3;
            n2 += n4;
            this._context.noteCharactersRemoved(n3, n4);
        }
        if (n2 > 0) {
            this._context.setBufferChangeRemoval(n, n2);
        } else {
            this._context.setBufferChangeNoOp();
        }
    }

    private void _changeAttr(AttrValueChange attrValueChange, Attr attr) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        AttributeLocator attributeLocator = (AttributeLocator)this._context.getLocatorRequired(attr);
        short s = this._getDefaultQuoteStyle(attr);
        SimpleLocator simpleLocator = null;
        TextLocator textLocator = attributeLocator.getValueLocator();
        if (textLocator == null) {
            n2 = 0;
            n = attributeLocator.getEndOffset();
            SimpleLocator simpleLocator2 = attributeLocator.getEqualsLocator();
            if (simpleLocator2 == null) {
                stringBuffer.append('=');
                simpleLocator = this._context.createSimpleLocator(attributeLocator.getEndOffset(), 1);
            }
        } else {
            n = ((Locator)textLocator).getStartOffset();
            n2 = textLocator.getLength();
            short s2 = attributeLocator.getQuoteStyle();
            if (s2 != 2) {
                s = s2;
            }
            this._context.detachLocator(textLocator);
        }
        TextLocator textLocator2 = this._createTextAndTextLocator(stringBuffer, attr, attrValueChange.getNewValue(), s, n + stringBuffer.length());
        String string = stringBuffer.toString();
        this._context.getModel().nodeSubtreeRemoved(attr);
        Locator locator = attributeLocator.getCopy();
        attributeLocator.setValueLocator(textLocator2);
        if (simpleLocator != null) {
            attributeLocator.setEqualsLocator(simpleLocator);
        }
        this._context.mapNodeToLocator(attr, NodeRefFactory.getNodeRef((Node)attr), attributeLocator, locator);
        this._context.getModel().nodeSubtreeInserted(attr);
        this._context.setBufferChangeReplace(n, n2, string);
    }

    private void _insertSubtreeIntoElement(Element element, Node node) {
        ElementLocator elementLocator = this._context.getElementLocatorRequired(element);
        this._context.checkElementLocatorParts(elementLocator, element, true, true, false);
        if (elementLocator.getEndTagLocator() == null) {
            this._insertSubtreeIntoEmptyElement(element, elementLocator, node);
        } else {
            this._insertSubtreeIntoNonEmptyElement(element, node);
        }
    }

    static {
        $assertionsDisabled = SyncToTextDomChangeHandler.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(SyncToTextDomChangeHandler.class.getName());
        _DOUBLE_QUOTE = new Character('\"');
        _SINGLE_QUOTE = new Character('\'');
    }

    private void _insertSubtreeIntoEmptyElement(Element element, ElementLocator elementLocator, Node node) {
        int n;
        if (!($assertionsDisabled || node == element.getFirstChild() && node == element.getLastChild())) {
            throw new AssertionError();
        }
        Locator locator = elementLocator.getCopy();
        SimpleLocator simpleLocator = elementLocator.getStartTagLocator();
        String string = this._isFakeElementLocator(elementLocator) ? "" : this._config().getEndTag(element);
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        SimpleLocator simpleLocator2 = elementLocator.getSlashLocator();
        if (simpleLocator2 == null) {
            int n2 = elementLocator.isStartTagComplete() && !this._isFakeElementLocator(elementLocator) ? this._config().getStartTagEnd(element).length() : 0;
            n = ((Locator)simpleLocator).getEndOffset() - n2;
        } else {
            this._context.noteCharactersRemoved(((Locator)simpleLocator2).getStartOffset(), simpleLocator2.getLength());
            n = ((Locator)simpleLocator2).getStartOffset();
            this._curInsertOffset = n + simpleLocator2.getLength();
        }
        this._insertHelper(n, node);
        int n3 = this._getIndentationSize(DomPositionFactory.inside((Node)element));
        this._addWhitespaceAndUpdateLocators(n3);
        SimpleLocator simpleLocator3 = this._context.createSimpleLocator(this._curInsertOffset, string.length());
        this._context.setSlashAndComplete(element, ((ElementLocator)locator).getSlashLocator(), null, true);
        this._context.addEndTagLocator(element, simpleLocator3);
        this._insertBuffer.append(string);
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Changed parent locator from {0} to {1}", new Object[]{locator, elementLocator});
        }
        this._context.setBufferChangeReplace(n, 2, ">" + this._insertBuffer.toString());
    }

    private void _insertSubtreeIntoNonEmptyElement(Element element, Node node) {
        LinkedList<NodeRef> linkedList = null;
        Node node2 = node.getPreviousSibling();
        while (DomUtils.isElement((Node)node2)) {
            ElementLocator elementLocator = this._context.getElementLocatorRequired((Element)node2);
            SimpleLocator simpleLocator = elementLocator.getEndTagLocator();
            if (simpleLocator != null && simpleLocator.getLength() == 0) {
                if (linkedList == null) {
                    linkedList = new LinkedList<NodeRef>();
                }
                linkedList.add(NodeRefFactory.getNodeRef((Node)node2));
            }
            node2 = node2.getLastChild();
        }
        DetachAttachEndTagLocatorsChange detachAttachEndTagLocatorsChange = null;
        if (linkedList != null) {
            detachAttachEndTagLocatorsChange = new DetachAttachEndTagLocatorsChange(linkedList);
            detachAttachEndTagLocatorsChange.apply(this._context.getModel(), false);
        }
        Locator locator = this._getPreceedingLocator(node, element);
        Locator locator2 = this._getSucceedingLocator(node, element);
        if (!$assertionsDisabled && locator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && locator2 == null) {
            throw new AssertionError();
        }
        int n = locator.getEndOffset();
        int n2 = locator2.getStartOffset() - n;
        if (n2 < 0) {
            _LOGGER.log(Level.WARNING, "Negative whitespace to remove before insertion! parent={0} inserted={1} preceedingLocator={2} succeedingLocator={3} model={4}", new Object[]{element, node, locator, locator2, this._context.getModel()});
            n2 = 0;
        }
        this._context.noteCharactersRemoved(n, n2);
        this._curInsertOffset = n;
        boolean bl = this._insertHelper(n, node);
        if (bl && this._spaceOnEnd(node.getPreviousSibling(), false)) {
            --n;
            ++n2;
            this._insertBuffer.insert(0, " ");
        }
        DomPosition domPosition = element.getLastChild() == node ? DomPositionFactory.inside((Node)element) : DomPositionFactory.after((Node)node);
        int n3 = this._getIndentationSize(domPosition);
        this._addWhitespaceAndUpdateLocators(n3);
        if (detachAttachEndTagLocatorsChange != null) {
            detachAttachEndTagLocatorsChange.apply(this._context.getModel(), true);
            this._context.addRelatedChange(detachAttachEndTagLocatorsChange);
        }
        this._context.setBufferChangeReplace(n, n2, this._insertBuffer.toString());
    }

    private void _insertSubtreeIntoDocument(Document document, Node node) {
        DeclarationLocator declarationLocator;
        Node node2 = document.getFirstChild();
        int n = node == node2 ? ((declarationLocator = this._context.getModel().getXMLDeclarationLocator()) != null ? ((Locator)declarationLocator).getEndOffset() : 0) : this._getStartOffsetAfterPreviousSibling(node);
        this._curInsertOffset = n;
        this._insertHelper(n, node);
        if (n == 0) {
            int n2 = n + this._insertBuffer.length();
            this._context.noteCharactersAdded(n2, 1);
            this._insertBuffer.append('\n');
        }
        this._context.setBufferChangeInsert(n, this._insertBuffer.toString());
    }

    private boolean _insertHelper(int n, Node node) {
        int n2;
        boolean bl = false;
        if (n != 0 && (n2 = this._getIndentationSize(DomPositionFactory.before((Node)node))) >= 0) {
            bl = true;
            this._addWhitespaceAndUpdateLocators(n2);
        }
        MapSubtreeLocatorChange mapSubtreeLocatorChange = new MapSubtreeLocatorChange(node, true);
        this._createTextAndLocatorForSubtree(mapSubtreeLocatorChange, node, true);
        this._context.addRelatedChange(mapSubtreeLocatorChange);
        this._context.getModel().nodeSubtreeInserted(node);
        mapSubtreeLocatorChange.doneAddingNodes();
        return bl;
    }

    private int _getStartOffsetAfterPreviousSibling(Node node) {
        Node node2 = node.getPreviousSibling();
        this._context.requireNonNullAndInDocument(node2, "previous sibling of inserted node");
        int n = this._context.getLocatorRequired(node2).getEndOffset();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Putting new node {0} after sibling {1}, which had end offset {2}", new Object[]{node, node2, new Integer(n)});
        }
        return n;
    }

    private void _removeSubtreeCollapsingElement(Element element, Node node, NodeRef nodeRef) {
        ElementLocator elementLocator = this._context.getElementLocatorRequired(element);
        this._context.checkElementLocatorParts(elementLocator, element, true, true, true);
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "Collapsing parent {0}: before={1}", new Object[]{element, elementLocator});
            TextSyncUtils.debugRootLocator(this._context.getModel(), _LOGGER);
        }
        SimpleLocator simpleLocator = elementLocator.getEndTagLocator();
        boolean bl = elementLocator.isStartTagComplete();
        int n = elementLocator.getStartTagLocator().getEndOffset();
        if (bl) {
            --n;
        }
        int n2 = simpleLocator.getEndOffset();
        this._context.getModel().nodeSubtreeRemoved(node);
        TextSyncUtils.debugRootLocator(this._context.getModel(), _LOGGER);
        MapSubtreeLocatorChange mapSubtreeLocatorChange = new MapSubtreeLocatorChange(nodeRef, false);
        this._context.unmapSubtreeLocators(node, nodeRef, mapSubtreeLocatorChange);
        this._context.addRelatedChange(mapSubtreeLocatorChange);
        int n3 = elementLocator.getStartTagLocator().getEndOffset();
        int n4 = simpleLocator.getStartOffset() - n3;
        if (n4 > 0) {
            this._context.noteCharactersRemoved(n3, n4);
        }
        if (bl) {
            this._context.noteCharactersAdded(n, 1);
        } else {
            this._context.noteCharactersAdded(n - 1, 2);
        }
        this._context.removeEndTagLocator(element);
        TextSyncUtils.debugRootLocator(this._context.getModel(), _LOGGER);
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Collapsing parent {0}: after={1}", new Object[]{element, elementLocator});
        }
        this._context.setSlashAndComplete(element, elementLocator.getSlashLocator(), this._context.createSimpleLocator(n, 1), true);
        TextSyncUtils.debugRootLocator(this._context.getModel(), _LOGGER);
        this._context.setBufferChangeReplace(n, n2 - n, "/>");
    }

    private void _removeSubtree(Node node, NodeRef nodeRef) {
        Locator locator = this._context.getLocator(node);
        Node node2 = node.getParentNode();
        int n = 0;
        Locator locator2 = this._getPreceedingLocator(node, node2);
        if (locator2 != null) {
            int n2 = locator2.getEndOffset();
            int n3 = locator.getStartOffset();
            n = n3 - n2;
        }
        int n4 = locator.getStartOffset();
        int n5 = locator.getEndOffset() - n4;
        this._context.getModel().nodeSubtreeRemoved(node);
        MapSubtreeLocatorChange mapSubtreeLocatorChange = new MapSubtreeLocatorChange(nodeRef, false);
        this._context.unmapSubtreeLocators(node, nodeRef, mapSubtreeLocatorChange);
        this._context.addRelatedChange(mapSubtreeLocatorChange);
        if (n < 0) {
            this._context.logAssertFailure("Negative preceeding whitespace {0} when removing {1} at {2}", new Object[]{new Integer(n), node, nodeRef});
        } else if (n > 0) {
            n5 += n;
            this._context.noteCharactersRemoved(n4 -= n, n);
        }
        this._context.setBufferChangeRemoval(n4, n5);
    }

    private Locator _getPreceedingLocator(Node node, Node node2) {
        Node node3 = node.getPreviousSibling();
        if (node3 != null) {
            return this._context.getLocator(node3);
        }
        if (node2 == null) {
            return null;
        }
        switch (node2.getNodeType()) {
            case 9: {
                return this._context.getModel().getXMLDeclarationLocator();
            }
            case 1: {
                return this._context.getElementLocator(node2).getStartTagLocator();
            }
        }
        return this._context.getLocator(node2);
    }

    private Locator _getSucceedingLocator(Node node, Node node2) {
        Node node3 = node.getNextSibling();
        if (node3 != null) {
            return this._context.getLocator(node3);
        }
        if (node2 == null) {
            return null;
        }
        switch (node2.getNodeType()) {
            case 9: {
                return null;
            }
            case 1: {
                return this._context.getElementLocator(node2).getEndTagLocator();
            }
        }
        return null;
    }

    private void _changeSimpleNodeValue(Node node, String string, SimpleLocator simpleLocator) {
        int n = simpleLocator.getStartOffset();
        int n2 = simpleLocator.getLength();
        if (!$assertionsDisabled && node.getNodeType() == 3) {
            throw new AssertionError();
        }
        String string2 = this._getNodeText(node, string);
        this._context.changeLocatorLength(node, simpleLocator, string2.length());
        this._context.setBufferChangeReplace(n, n2, string2);
    }

    private void _changeTextNodeValue(Text text, TextLocator textLocator, StringChange stringChange, String string, String string2) {
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "TextChange: |{0}| to |{1}|; change={2}", new Object[]{string, string2, stringChange});
        }
        if (stringChange.getRemovalCount() < string.length()) {
            try {
                this._doSubTextNodeUpdate(text, textLocator, stringChange);
                return;
            }
            catch (BreakOut breakOut) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Error doing sub-node update of text node from {0} to {1}", (Object[])new Object[]{string, string2}, (Throwable)breakOut);
            }
        }
        this._doEntireTextNoteReplacement(text, textLocator, string2);
    }

    private void _doSubTextNodeUpdate(Node node, TextLocator textLocator, StringChange stringChange) throws BreakOut {
        String string;
        int[] nArray;
        int n;
        int n2 = textLocator.getContentTextOffset(stringChange.getOffset());
        if (stringChange.getRemovalCount() > 0) {
            int n3 = stringChange.getOffset() + stringChange.getRemovalCount();
            int n4 = textLocator.getContentTextOffset(n3);
            n = n4 - n2;
            nArray = new int[]{n2, n4};
        } else {
            n = 0;
            nArray = new int[]{n2};
        }
        List list = TextLocator.copyLocatorList(textLocator.getContentLocators());
        List list2 = TextLocator.copyLocatorList(textLocator.getWhitespaceLocators());
        boolean bl = TextSyncUtils.splitLocatorList(list, nArray);
        if (!bl) {
            throw new BreakOut(null);
        }
        bl = TextSyncUtils.updateWhitespaceLocatorsForRemoval(list2, n2, n);
        if (!bl) {
            throw new BreakOut(null);
        }
        if (n > 0) {
            int n5 = n2 + n;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SimpleLocator simpleLocator = (SimpleLocator)iterator.next();
                int n6 = simpleLocator.getStartOffset();
                if (n6 >= n2 && n6 < n5) {
                    iterator.remove();
                    continue;
                }
                if (n6 < n5) continue;
                simpleLocator.move(-n);
            }
        }
        if (stringChange.getInsertedChars() != null) {
            String string2 = stringChange.getInsertedChars();
            StringBuffer stringBuffer = new StringBuffer();
            List list3 = this._createTextAndContentLocators(stringBuffer, node, string2, (short)-1, n2);
            int n7 = stringBuffer.length();
            ListIterator listIterator = list.listIterator();
            boolean bl2 = false;
            while (listIterator.hasNext()) {
                SimpleLocator simpleLocator = (SimpleLocator)listIterator.next();
                if (simpleLocator.getStartOffset() < n2) continue;
                if (!bl2) {
                    listIterator.previous();
                    this._addAll(listIterator, list3);
                    bl2 = true;
                    listIterator.next();
                }
                simpleLocator.move(n7);
            }
            if (!bl2) {
                list.addAll(list3);
                bl2 = true;
            }
            TextSyncUtils.adjustLocatorsForAddition(list2, n2, n7);
            string = stringBuffer.toString();
        } else {
            string = "";
        }
        TextSyncUtils.minimizeNumberOfLocators(list);
        TextLocator textLocator2 = this._context.createTextLocator(list, list2);
        this._context.getModel().nodeSubtreeRemoved(node);
        this._context.mapNodeToLocator(node, textLocator2, (Locator)textLocator);
        this._context.getModel().nodeSubtreeInserted(node);
        this._context.setBufferChangeReplace(n2, n, string);
    }

    private boolean _checkAndWarnNullValuedAttr(Attr attr) {
        boolean bl;
        boolean bl2 = bl = attr.getValue() != null;
        if (!bl) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Attr set to null value. DOM is unclear on this, but it makes no sense to set an attr to null value. Removing the attr or setting it to \"\" are both valid options. Attr will be treated as unset. attr={0} owning element={1}", (Object[])new Object[]{attr.getNodeName(), attr.getOwnerElement().getNodeName()}, (Throwable)new Throwable("stack trace -- caller set attr to null value"));
        }
        return bl;
    }

    private void _addAll(ListIterator listIterator, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            listIterator.add(iterator.next());
        }
    }

    private void _doEntireTextNoteReplacement(Node node, TextLocator textLocator, String string) {
        int n = textLocator.getStartOffset();
        int n2 = textLocator.getLength();
        this._context.getModel().nodeSubtreeRemoved(node);
        StringBuffer stringBuffer = new StringBuffer();
        TextLocator textLocator2 = this._createTextAndTextLocator(stringBuffer, node, string, (short)-1, n);
        this._context.mapNodeToLocator(node, textLocator2, (Locator)textLocator);
        this._context.getModel().nodeSubtreeInserted(node);
        this._context.setBufferChangeReplace(n, n2, stringBuffer.toString());
    }

    private boolean _usesMinimizedForm(Element element) {
        return this._context.getConfig().allowsMinimizedForm(element) && this._context.getOptions().useMinimizedForm(element);
    }

    private TextSyncConfiguration _config() {
        return this._context.getConfig();
    }

    private String _getNodeText(Node node) {
        return this._getNodeText(node, node.getNodeValue());
    }

    private String _getNodeText(Node node, String string) {
        short s = node.getNodeType();
        switch (s) {
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                return "<?" + processingInstruction.getTarget() + " " + string + "?>";
            }
            case 4: {
                return "<![CDATA[" + string + "]]>";
            }
            case 8: {
                Comment comment = (Comment)node;
                return this._config().getCommentStart(comment) + string + this._config().getCommentEnd(comment);
            }
        }
        throw new IllegalStateException("Don't know how to get value for type " + s + "; val=" + string);
    }

    private Element _getOwnerElement(AbstractAttrChange abstractAttrChange) {
        return abstractAttrChange.getOwnerElement(this._context.getModel().getDocument());
    }

    private void _createTextAndLocatorForSubtree(MapSubtreeLocatorChange mapSubtreeLocatorChange, Node node, boolean bl) {
        short s = node.getNodeType();
        if (!bl && s != 2) {
            int n = this._getIndentationSize(DomPositionFactory.before((Node)node));
            this._addIndentationWhitespace(n);
        }
        switch (s) {
            case 2: {
                String string = this._createAttrTextAndLocator(mapSubtreeLocatorChange, (Attr)node, this._curInsertOffset, null);
                this._insertBuffer.append(string);
                this._curInsertOffset += string.length();
                break;
            }
            case 3: {
                TextLocator textLocator = this._createTextAndTextLocator(this._insertBuffer, node, node.getNodeValue(), (short)-1, this._curInsertOffset);
                this._context.getModel().mapNodeToLocator(node, textLocator);
                mapSubtreeLocatorChange.addNode(node, null, Locator.getCopy(textLocator));
                this._curInsertOffset += textLocator.getLength();
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                String string = this._getNodeText(node);
                this._insertBuffer.append(string);
                SimpleLocator simpleLocator = this._context.createSimpleLocator(this._curInsertOffset, string.length());
                this._context.getModel().mapNodeToLocator(node, simpleLocator);
                mapSubtreeLocatorChange.addNode(node, null, Locator.getCopy(simpleLocator));
                this._curInsertOffset += string.length();
                break;
            }
            case 1: {
                this._createElementTextAndLocator(mapSubtreeLocatorChange, (Element)node);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to make text for node type " + node.getNodeType());
            }
        }
    }

    private TextLocator _createTextAndTextLocator(StringBuffer stringBuffer, Node node, String string, short s, int n) {
        List list = this._createTextAndContentLocators(stringBuffer, node, string, s, n);
        return this._context.createTextLocator(list);
    }

    private List _createTextAndContentLocators(StringBuffer stringBuffer, Node node, String string, short s, int n) {
        if (string.indexOf(13) >= 0) {
            StringBuffer stringBuffer2 = new StringBuffer(5 * string.length());
            int n2 = 0;
            while (n2 < string.length()) {
                if (n2 != 0) {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append(Integer.toHexString(string.charAt(n2)));
                ++n2;
            }
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"\\r characters found in text! This is not a good idea, since they stripped by the TextBuffer. Caller should be fixed to not insert the \\r's. Treating \\r as a space to continue.\nnode={0} nodeValue={1} nodeValue chars in hex={2}", (Object[])new Object[]{node, string, stringBuffer2}, (Throwable)new Throwable("stack trace"));
            string = string.replaceAll("\r", " ");
        }
        LinkedList<SimpleLocator> linkedList = new LinkedList<SimpleLocator>();
        Character c = SyncToTextDomChangeHandler._getQuoteChar(s);
        if (c == null && s != -1) {
            throw new IllegalStateException("invalid quote style: " + s);
        }
        int n3 = n;
        int n4 = 0;
        if (c != null) {
            stringBuffer.append(c);
            ++n4;
        }
        int n5 = 0;
        while (n5 < string.length()) {
            String string2;
            char c2 = string.charAt(n5);
            String string3 = c != null && c2 == c.charValue() ? ((string2 = this._config().getEntityToOutput(node, c2)) != null ? string2 : (c2 == '\"' ? "&quot;" : "&apos;")) : this._config().getEntityToOutput(node, c2);
            if (string3 == null) {
                stringBuffer.append(c2);
                ++n4;
            } else {
                stringBuffer.append(string3);
                if (n4 > 0) {
                    SimpleLocator simpleLocator = this._context.createSimpleLocator(n3, n4);
                    linkedList.add(simpleLocator);
                    n3 += n4;
                    n4 = 0;
                }
                int n6 = n3 + string3.length();
                EntityRefLocator entityRefLocator = this._context.createEntityRefLocator(n3, n6, string3, String.valueOf(c2));
                linkedList.add(entityRefLocator);
                n3 = n6;
            }
            ++n5;
        }
        if (c != null) {
            stringBuffer.append(c);
            ++n4;
        }
        if (n4 > 0 || linkedList.isEmpty()) {
            SimpleLocator simpleLocator = this._context.createSimpleLocator(n3, n4);
            linkedList.add(simpleLocator);
        }
        return linkedList;
    }

    private static Character _getQuoteChar(short s) {
        switch (s) {
            case 1: {
                return _DOUBLE_QUOTE;
            }
            case 0: {
                return _SINGLE_QUOTE;
            }
        }
        return null;
    }

    private void _createElementTextAndLocator(MapSubtreeLocatorChange mapSubtreeLocatorChange, Element element) {
        SimpleLocator simpleLocator;
        SimpleLocator simpleLocator2;
        SimpleLocator simpleLocator3;
        boolean bl;
        int n = this._curInsertOffset;
        String string = this._config().getStartTagBeginning(element);
        this._insertBuffer.append(string);
        this._curInsertOffset += string.length();
        String string2 = this._config().getStartTagName(element);
        this._insertBuffer.append(string2);
        SimpleLocator simpleLocator4 = this._context.createSimpleLocator(this._curInsertOffset, string2.length());
        this._curInsertOffset += string2.length();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (this._allowsAttributes(element)) {
            if (namedNodeMap != null) {
                int n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    Attr attr = (Attr)namedNodeMap.item(n2);
                    boolean bl2 = this._checkAndWarnNullValuedAttr(attr);
                    if (bl2) {
                        this._insertBuffer.append(" ");
                        ++this._curInsertOffset;
                        this._createTextAndLocatorForSubtree(mapSubtreeLocatorChange, namedNodeMap.item(n2), false);
                    } else {
                        AttributeLocator attributeLocator = this._context.createZeroLengthAttrLocator(this._curInsertOffset);
                        this._context.getModel().mapNodeToLocator(attr, attributeLocator);
                        mapSubtreeLocatorChange.addNode(attr, null, Locator.getCopy(attributeLocator));
                    }
                    ++n2;
                }
            }
        } else if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
            this._context.getModel().getLogger().log(Level.SEVERE, "Attrs unexpectedly found on {0}, which does not allow attributes. Ignoring.", element.getNodeName());
        }
        Node node = element.getFirstChild();
        boolean bl3 = bl = node != null;
        if (!bl && this._usesMinimizedForm(element)) {
            simpleLocator3 = null;
            String string3 = "/>";
            int n3 = this._curInsertOffset;
            simpleLocator2 = this._context.createSimpleLocator(n3, 1);
            this._insertBuffer.append(string3);
            this._curInsertOffset += string3.length();
            simpleLocator = this._context.createSimpleLocator(n, this._curInsertOffset - n);
        } else {
            String string4 = this._config().getStartTagEnd(element);
            this._insertBuffer.append(string4);
            this._curInsertOffset += string4.length();
            simpleLocator2 = null;
            simpleLocator = this._context.createSimpleLocator(n, this._curInsertOffset - n);
            while (node != null) {
                this._createTextAndLocatorForSubtree(mapSubtreeLocatorChange, node, false);
                node = node.getNextSibling();
            }
            if (bl || this._context.getOptions().prefersWhitespaceInsideWhenEmpty(element)) {
                int n4 = this._getIndentationSize(DomPositionFactory.inside((Node)element));
                this._addIndentationWhitespace(n4);
            }
            String string5 = this._config().getEndTag(element);
            int n5 = string5.length();
            this._insertBuffer.append(string5);
            simpleLocator3 = this._context.createSimpleLocator(this._curInsertOffset, n5);
            this._curInsertOffset += n5;
        }
        ElementLocator elementLocator = this._context.createElementLocator(simpleLocator, simpleLocator4, simpleLocator3, simpleLocator2);
        this._context.getModel().mapNodeToLocator(element, elementLocator);
        mapSubtreeLocatorChange.addNode(element, null, Locator.getCopy(elementLocator));
    }

    private String _createAttrTextAndLocator(MapSubtreeLocatorChange mapSubtreeLocatorChange, Attr attr, int n, Locator locator) {
        short s;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = attr.getValue();
        if (this._config().omitAttributeName(attr)) {
            string = "";
            s = -1;
        } else {
            string = attr.getNodeName();
            s = this._changeQuoteStyleForValue(this._getDefaultQuoteStyle(attr), string2);
        }
        int n2 = n;
        if (string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("=");
        }
        TextLocator textLocator = this._createTextAndTextLocator(stringBuffer, attr, string2, s, n + stringBuffer.length());
        short s2 = s == -1 ? (short)2 : s;
        AttributeLocator attributeLocator = this._context.createAttributeLocator(n2, string.length(), textLocator, s2);
        this._context.getModel().mapNodeToLocator(attr, attributeLocator);
        mapSubtreeLocatorChange.addNode(attr, locator, Locator.getCopy(attributeLocator));
        return stringBuffer.toString();
    }

    private short _getDefaultQuoteStyle(Attr attr) {
        if (this._context.getOptions().isDefaultQuoteStyleDouble(attr)) {
            return 1;
        }
        return 0;
    }

    private short _changeQuoteStyleForValue(short s, String string) {
        if (this._containsQuoteChar(s, string)) {
            short s2;
            short s3 = s2 = s == 1 ? (short)0 : 1;
            if (!this._containsQuoteChar(s2, string)) {
                return s2;
            }
        }
        return s;
    }

    private boolean _containsQuoteChar(short s, String string) {
        char c = SyncToTextDomChangeHandler._getQuoteChar(s).charValue();
        return string.indexOf(c) != -1;
    }

    private boolean _allowsExtraWhitespace(DomPosition domPosition) {
        Node node = domPosition.getContainerNode();
        Element element = DomUtils.asElement((Node)node);
        if (element == null) {
            return true;
        }
        if (!this._context.getOptions().prefersWhitespaceInside(element)) {
            return false;
        }
        WhitespaceMode whitespaceMode = this._context.getElementContentWhitespaceMode((Element)node);
        Boolean bl = whitespaceMode.allowsAddingExtraWhitespace(domPosition);
        if (bl == null) {
            return this._hasSpaceAlready(domPosition);
        }
        return bl;
    }

    private boolean _hasSpaceAlready(DomPosition domPosition) {
        Node node = domPosition.getTargetNode();
        if (domPosition.isBefore()) {
            if (this._spaceOnEnd(node, true)) {
                return true;
            }
            if (this._spaceOnEnd(node.getPreviousSibling(), false)) {
                return true;
            }
        } else if (domPosition.isAfter()) {
            if (this._spaceOnEnd(node, false)) {
                return true;
            }
            if (this._spaceOnEnd(node.getNextSibling(), true)) {
                return true;
            }
        }
        return false;
    }

    private boolean _spaceOnEnd(Node node, boolean bl) {
        if (node != null && node.getNodeType() == 3) {
            String string = node.getNodeValue();
            if (bl) {
                return string.startsWith(" ");
            }
            return string.endsWith(" ");
        }
        return false;
    }

    private int _getIndentationSize(DomPosition domPosition) {
        boolean bl = this._allowsExtraWhitespace(domPosition);
        if (bl) {
            int n = 0;
            Node node = domPosition.getContainerNode();
            if (domPosition.isInside()) {
                --n;
            }
            while (node.getNodeType() == 1) {
                ElementLocator elementLocator = this._context.getElementLocator(node);
                if (!this._isFakeElementLocator(elementLocator)) {
                    ++n;
                }
                node = node.getParentNode();
            }
            return n * this._context.getModel().getIndentSize();
        }
        return -1;
    }

    private void _addWhitespaceAndUpdateLocators(int n) {
        this._addWhitespaceAndUpdateLocators(this._curInsertOffset, n);
    }

    private void _addWhitespaceAndUpdateLocators(int n, int n2) {
        if (n2 >= 0) {
            this._context.noteCharactersAdded(n, n2 + 1);
            this._addIndentationWhitespace(n2);
        }
    }

    private void _addIndentationWhitespace(int n) {
        if (n >= 0) {
            this._curInsertOffset += n + 1;
            this._insertBuffer.append('\n');
            int n2 = 0;
            while (n2 < n) {
                this._insertBuffer.append(' ');
                ++n2;
            }
        }
    }

    private boolean _allowsAttributes(Element element) {
        ElementLocator elementLocator = this._context.getElementLocator(element);
        return (elementLocator == null || !this._isFakeElementLocator(elementLocator)) && this._config().allowsAttributes(element);
    }

    private boolean _isFakeElementLocator(ElementLocator elementLocator) {
        return elementLocator != null && elementLocator.getStartTagLocator().getLength() == 0;
    }

    void $init$() {
        this._insertBuffer = new StringBuffer();
    }

    private class BreakOut
    extends Exception {
        private BreakOut() {
        }

        BreakOut(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

