/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.AddOrRemoveEndTagLocatorChange;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.CharsLocatorChange;
import oracle.bali.xml.dom.buffer.MapNodeLocatorChange;
import oracle.bali.xml.dom.buffer.MapSubtreeLocatorChange;
import oracle.bali.xml.dom.buffer.SimpleMapNodeToLocatorChange;
import oracle.bali.xml.dom.buffer.SlashAndCompleteLocatorChange;
import oracle.bali.xml.dom.buffer.TextSyncConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.BufferChange;
import oracle.bali.xml.dom.buffer.textsync.InsertBufferChange;
import oracle.bali.xml.dom.buffer.textsync.NoOpBufferChange;
import oracle.bali.xml.dom.buffer.textsync.RemoveBufferChange;
import oracle.bali.xml.dom.buffer.textsync.ReplaceBufferChange;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class TextSyncContext {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final BufferDomModel _model;
    private final MutationEvent _event;
    private final DomChange _change;
    private final TextSyncOptions _options;
    private BufferChange _retBufferChange;
    private static final Logger _LOGGER;

    TextSyncContext(BufferDomModel bufferDomModel, MutationEvent mutationEvent, DomChange domChange) {
        this.$init$();
        this._model = bufferDomModel;
        this._event = mutationEvent;
        this._change = domChange;
    }

    public BufferDomModel getModel() {
        return this._model;
    }

    public Node getEventTargetNode() {
        return (Node)((Object)this._event.getTarget());
    }

    public void setBufferChangeNoOp() {
        this._setRetBufferChange(new NoOpBufferChange(this._change));
    }

    static {
        $assertionsDisabled = TextSyncContext.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(TextSyncContext.class.getName());
    }

    public void setBufferChangeInsert(int n, String string) {
        this._checkOffsetNonNegative(n);
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string.length() <= 0) {
            throw new AssertionError();
        }
        this._setRetBufferChange(new InsertBufferChange(this._change, n, string));
    }

    public void setBufferChangeRemoval(int n, int n2) {
        this._checkOffsetLengthNonNegative(n, n2);
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        this._setRetBufferChange(new RemoveBufferChange(this._change, n, n2));
    }

    public void setBufferChangeReplace(int n, int n2, String string) {
        this._checkOffsetLengthNonNegative(n, n2);
        if (n2 == 0) {
            this.setBufferChangeInsert(n, string);
        } else if (string == null || "".equals(string)) {
            this.setBufferChangeRemoval(n, n2);
        } else {
            this._setRetBufferChange(new ReplaceBufferChange(this._change, n, n2, string));
        }
    }

    private void _setRetBufferChange(BufferChange bufferChange) {
        if (!$assertionsDisabled && this._retBufferChange != null) {
            throw new AssertionError();
        }
        this._retBufferChange = bufferChange;
    }

    public BufferChange getBufferChange() {
        if (this._retBufferChange == null) {
            throw new IllegalStateException("No return buffer change! domChange=" + this._change);
        }
        return this._retBufferChange;
    }

    public void changeLocatorLength(Node node, SimpleLocator simpleLocator, int n) {
        Locator locator = Locator.getCopy(simpleLocator);
        this._manager().locatorLengthChanged(simpleLocator, n);
        this.mapNodeToLocator(node, NodeRefFactory.getNodeRef((Node)node), simpleLocator, locator);
    }

    public void mapAttrToLocator(Node node, Attr attr, Locator locator) {
        this.mapNodeToLocator((Node)attr, NodeRefFactory.getAttrRef((Node)node, (Attr)attr), locator);
    }

    public void mapNodeToLocatorDirectly(Node node, Locator locator) {
        this._model.mapNodeToLocator(node, locator);
    }

    public void mapNodeToLocator(Node node, Locator locator, Locator locator2) {
        this.mapNodeToLocator(node, NodeRefFactory.getNodeRef((Node)node), locator, locator2);
    }

    public void mapNodeToLocator(Node node, NodeRef nodeRef, Locator locator) {
        this.mapNodeToLocator(node, nodeRef, locator, this._model.getLocator(node));
    }

    public void mapNodeToLocator(Node node, NodeRef nodeRef, Locator locator, Locator locator2) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "MapNode: {0} from {1} to {2}", new Object[]{nodeRef, locator2, locator});
        }
        this.mapNodeToLocatorDirectly(node, locator);
        this.addRelatedChange(new MapNodeLocatorChange(nodeRef, Locator.getCopy(locator2), Locator.getCopy(locator)));
    }

    public void simpleMapNodeToLocator(Node node, Locator locator, Locator locator2) {
        this.mapNodeToLocatorDirectly(node, locator);
        this.addRelatedChange(new SimpleMapNodeToLocatorChange(NodeRefFactory.getNodeRef((Node)node), locator, locator2));
    }

    public void requireNonNullAndInDocument(Node node, Object object) {
        if (node == null) {
            this.logAssertFailure("Node was null when handling change {0}! Node info: {1}", new Object[]{this._change, object});
        } else if (DomUtils.getOwnerDocument((Node)node) != this.getModel().getDocument()) {
            this.logAssertFailure("Node was not in model's document when handling change {0}! Node info: {1} {2}  Node doc: {3}  Model doc: {4}", new Object[]{this._change, node.getNodeName(), object, String.valueOf(node.getOwnerDocument()), String.valueOf(this.getModel().getDocument())});
        }
    }

    public void checkElementLocatorParts(ElementLocator elementLocator, Element element, boolean bl, boolean bl2, boolean bl3) {
        if (bl && elementLocator.getNameLocator() == null) {
            this.logAssertFailure("ElementLocator for {0} has null name locator! locator={1}", element.getNodeName(), elementLocator);
        }
        if (bl2 && elementLocator.getStartTagLocator() == null) {
            this.logAssertFailure("ElementLocator for {0} has null start tag locator! locator={1}", element.getNodeName(), elementLocator);
        }
        if (bl3 && elementLocator.getEndTagLocator() == null) {
            this.logAssertFailure("ElementLocator for {0} has null end tag locator! locator={1}", element.getNodeName(), elementLocator);
        }
    }

    public ElementLocator getElementLocatorRequired(Element element) {
        Locator locator = this.getLocatorRequired(element);
        if (!(locator instanceof ElementLocator)) {
            this.logAssertFailure("Locator for {0} was not an ElementLocator! locator={1}", element.getNodeName(), locator);
        }
        return (ElementLocator)locator;
    }

    public Locator getLocatorRequired(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        Locator locator = this.getLocator(node);
        if (locator == null) {
            this.logAssertFailure("Locator for {0} was null!", node.getNodeName());
        }
        return locator;
    }

    public Locator getLocator(Node node) {
        return this.getModel().getLocator(node);
    }

    public ElementLocator getElementLocator(Node node) {
        return (ElementLocator)this.getLocator(node);
    }

    public Attr getEventAttr() {
        return (Attr)this._event.getRelatedNode();
    }

    public void logAssertFailure(String string, Object object, Object object2) {
        this.logAssertFailure(string, new Object[]{object, object2});
    }

    public void logAssertFailure(String string, Object object) {
        this.logAssertFailure(string, new Object[]{object});
    }

    public void logAssertFailure(String string, Object[] objectArray) {
        LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)string, (Object[])objectArray, (Throwable)new RuntimeException("stack trace"));
        this._logBuffer(Level.SEVERE, "when previously logged error occurred");
        throw new RuntimeException("Assertion failure; detail messages logged.");
    }

    public void unmapSubtreeLocators(Node node, NodeRef nodeRef, MapSubtreeLocatorChange mapSubtreeLocatorChange) {
        mapSubtreeLocatorChange.addNode(nodeRef, Locator.getCopy(this.getModel().getLocator(node)), null);
        this.getModel().mapNodeToLocator(node, null);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                NodeRef nodeRef2 = NodeRefFactory.getAttrRef((NodeRef)nodeRef, (Attr)attr);
                mapSubtreeLocatorChange.addNode(nodeRef2, Locator.getCopy(this.getModel().getLocator(attr)), null);
                this.getModel().mapNodeToLocator(attr, null);
                ++n;
            }
        }
        if (node.getNodeType() != 2) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                NodeRef nodeRef3 = nodeRef.getChildNodeRef(node2);
                this.unmapSubtreeLocators(node2, nodeRef3, mapSubtreeLocatorChange);
                node2 = node2.getNextSibling();
            }
        }
    }

    public void noteCharactersAdded(int n, int n2) {
        this._checkOffsetLengthNonNegative(n, n2);
        if (n2 != 0) {
            if (_LOGGER.isLoggable(Level.FINEST)) {
                _LOGGER.log(Level.FINEST, "CharactersAdded: {0} at {1}", new Object[]{String.valueOf(n2), String.valueOf(n)});
            }
            this._manager().charactersAdded(n, n2);
            this.addRelatedChange(new CharsLocatorChange(n, n2));
        }
    }

    public void addRelatedChange(RelatedChange relatedChange) {
        this._change.addRelatedChange(relatedChange);
    }

    public void noteCharactersRemoved(int n, int n2) {
        this._checkOffsetLengthNonNegative(n, n2);
        if (n2 > 0) {
            if (_LOGGER.isLoggable(Level.FINEST)) {
                _LOGGER.log(Level.FINEST, "CharactersRemoved: {0} at {1}", new Object[]{String.valueOf(n2), String.valueOf(n)});
            }
            this._manager().charactersRemoved(n, n2);
            this.addRelatedChange(new CharsLocatorChange(n, -n2));
        }
    }

    public void setSlashAndComplete(Element element, SimpleLocator simpleLocator, SimpleLocator simpleLocator2, boolean bl) {
        ElementLocator elementLocator = this.getElementLocatorRequired(element);
        boolean bl2 = elementLocator.isStartTagComplete();
        if (bl2 != bl || !this._same(simpleLocator, simpleLocator2)) {
            this.addRelatedChange(new SlashAndCompleteLocatorChange(element, (SimpleLocator)Locator.getCopy(simpleLocator), (SimpleLocator)Locator.getCopy(simpleLocator2), bl2, bl));
            if (simpleLocator != null) {
                this._manager().detach(simpleLocator);
            }
            if (simpleLocator2 != null) {
                this._manager().attach(simpleLocator2);
            }
            elementLocator.setSlashLocator(simpleLocator2);
            elementLocator.setStartTagComplete(bl);
        }
    }

    public void addEndTagLocator(Element element, SimpleLocator simpleLocator) {
        ElementLocator elementLocator = this.getElementLocatorRequired(element);
        this._manager().addEndTagAtLocator(elementLocator, simpleLocator);
        this.addRelatedChange(new AddOrRemoveEndTagLocatorChange(element, (SimpleLocator)Locator.getCopy(simpleLocator), true));
    }

    public void removeEndTagLocator(Element element) {
        ElementLocator elementLocator = this.getElementLocatorRequired(element);
        SimpleLocator simpleLocator = elementLocator.getEndTagLocator();
        if (!$assertionsDisabled && simpleLocator == null) {
            throw new AssertionError();
        }
        this._manager().removeEndTagAtLocator(elementLocator);
        this._manager().detach(simpleLocator);
        this.addRelatedChange(new AddOrRemoveEndTagLocatorChange(element, simpleLocator, false));
    }

    public SimpleLocator createSimpleLocator(int n, int n2) {
        return this._manager().createSimpleLocator(n, n + n2, false);
    }

    public AttributeLocator createAttributeLocator(int n, int n2, TextLocator textLocator, short s) {
        SimpleLocator simpleLocator = this.createSimpleLocator(n, n2);
        int n3 = simpleLocator.getEndOffset();
        SimpleLocator simpleLocator2 = this._manager().createSimpleLocator(n3, textLocator.getStartOffset(), false);
        AttributeLocator attributeLocator = this._manager().createAttributeLocator(simpleLocator, simpleLocator2, textLocator, s, (short)0);
        return attributeLocator;
    }

    public ElementLocator createElementLocator(SimpleLocator simpleLocator, SimpleLocator simpleLocator2, SimpleLocator simpleLocator3, SimpleLocator simpleLocator4) {
        ElementLocator elementLocator = this._manager().createElementLocator(simpleLocator, simpleLocator2, simpleLocator3);
        elementLocator.setSlashLocator(simpleLocator4);
        return elementLocator;
    }

    public EntityRefLocator createEntityRefLocator(int n, int n2, String string, String string2) {
        EntityRefLocator entityRefLocator = this._manager().createEntityRefLocator(n, n2, string, string2, false);
        return entityRefLocator;
    }

    public TextLocator createTextLocator(List list) {
        return this._manager().createTextLocator(list);
    }

    public TextLocator createTextLocator(List list, List list2) {
        return this._manager().createTextLocator(list, list2);
    }

    public AttributeLocator createZeroLengthAttrLocator(int n) {
        return this._manager().createUnspecifiedAttributeLocator(n);
    }

    public void attachLocators(Collection collection) {
        for (Locator locator : collection) {
            this.attachLocator(locator);
        }
    }

    public void detachLocators(Collection collection) {
        for (Locator locator : collection) {
            this.detachLocator(locator);
        }
    }

    public void attachLocator(Locator locator) {
        Locator.attach(this._manager(), true, locator);
    }

    public void detachLocator(Locator locator) {
        Locator.attach(this._manager(), false, locator);
    }

    public SortedMap getSortedNodeToLocatorMap(Collection collection) {
        TreeMap<Node, Locator> treeMap = new TreeMap<Node, Locator>(this._model.getNodeByLocatorComparator());
        for (Node node : collection) {
            Locator locator = this.getLocator(node);
            if (locator == null) continue;
            treeMap.put(node, locator);
        }
        return treeMap;
    }

    public SortedSet getSortedAttributesSet(Node node) {
        return this.getModel().getSortedAttributesSet(node);
    }

    public TextSyncOptions getOptions() {
        return this._options;
    }

    public TextSyncConfiguration getConfig() {
        return this._model.getParserConfiguration().getTextSyncConfiguration();
    }

    public WhitespaceMode getElementContentWhitespaceMode(Element element) {
        WhitespaceHandler whitespaceHandler = this.getModel().getWhitespaceHandler();
        return whitespaceHandler.getElementContentWhitespaceMode(null, element);
    }

    public boolean isPastRightMargin(int n) {
        return n > this.getOptions().getRightMargin();
    }

    public boolean isPastRightMargin(Node node, Locator locator) {
        return this.isPastRightMargin(this.getEndColumnForWrapping(node, locator));
    }

    public int getEndColumnForWrapping(Node node, Locator locator) {
        Element element;
        Attr attr;
        if (DomUtils.isAttribute((Node)node) && (attr = (Attr)this.getSortedAttributesSet(element = ((Attr)node).getOwnerElement()).last()) == node) {
            node = element;
            locator = this.getElementLocatorRequired(element).getStartTagLocator();
        }
        return locator.getEndColumnNumber() - 1;
    }

    public Locator getLastAttributeOrNameLocator(Element element, ElementLocator elementLocator, boolean bl) {
        int n = DomUtils.getAttributeCount((Node)element);
        if (n == 0 || bl && n == 1) {
            return elementLocator.getNameLocator();
        }
        SortedSet sortedSet = this.getSortedAttributesSet(element);
        return this.getLocatorRequired((Attr)sortedSet.last());
    }

    private void _checkOffsetLengthNonNegative(int n, int n2) {
        if (n < 0 || n2 < 0) {
            this.logAssertFailure("Negative offset or length! offset={0} length={1}", new Integer(n), new Integer(n2));
        }
    }

    private void _checkOffsetNonNegative(int n) {
        if (n < 0) {
            this.logAssertFailure("Negative offset! offset={0}", new Integer(n));
        }
    }

    private boolean _same(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void _logBuffer(Level level, String string) {
        if (_LOGGER.isLoggable(level)) {
            _LOGGER.log(level, "--- buffer {0} below ---\n{1}\n--- buffer {0} above ---", new Object[]{string, this._buffer().getString(0, this._buffer().getLength())});
        }
    }

    private LocatorManager _manager() {
        return this._model.getLocatorManager();
    }

    private TextBuffer _buffer() {
        return this._model.getTextBuffer();
    }

    void $init$() {
        this._options = new TolerantTextSyncOptions(null);
    }

    static BufferDomModel ra$_model(TextSyncContext textSyncContext) {
        return textSyncContext._model;
    }

    static Logger ra$_LOGGER() {
        return _LOGGER;
    }

    private class TolerantTextSyncOptions
    implements TextSyncOptions {
        public TextSyncOptions.AttributeWrapMode getAttributeWrapMode(Element element) {
            try {
                TextSyncOptions.AttributeWrapMode attributeWrapMode = this._real().getAttributeWrapMode(element);
                return attributeWrapMode;
            }
            catch (Throwable throwable) {
                this._log(element, throwable);
                TextSyncOptions.AttributeWrapMode attributeWrapMode = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.getAttributeWrapMode(element);
                return attributeWrapMode;
            }
        }

        public int getRightMargin() {
            try {
                int n = this._real().getRightMargin();
                return n;
            }
            catch (Throwable throwable) {
                this._log(throwable);
                int n = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.getRightMargin();
                return n;
            }
        }

        public boolean isDefaultQuoteStyleDouble(Attr attr) {
            try {
                boolean bl = this._real().isDefaultQuoteStyleDouble(attr);
                return bl;
            }
            catch (Throwable throwable) {
                this._log(attr, throwable);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.isDefaultQuoteStyleDouble(attr);
                return bl;
            }
        }

        public boolean prefersWhitespaceInside(Element element) {
            try {
                boolean bl = this._real().prefersWhitespaceInside(element);
                return bl;
            }
            catch (Throwable throwable) {
                this._log(element, throwable);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.prefersWhitespaceInside(element);
                return bl;
            }
        }

        public boolean prefersWhitespaceInsideWhenEmpty(Element element) {
            try {
                boolean bl = this._real().prefersWhitespaceInsideWhenEmpty(element);
                return bl;
            }
            catch (Throwable throwable) {
                this._log(element, throwable);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.prefersWhitespaceInsideWhenEmpty(element);
                return bl;
            }
        }

        public boolean useMinimizedForm(Element element) {
            try {
                boolean bl = this._real().useMinimizedForm(element);
                return bl;
            }
            catch (Throwable throwable) {
                this._log(element, throwable);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.useMinimizedForm(element);
                return bl;
            }
        }

        public boolean wrapBeforeEndOfStartTag(Element element) {
            try {
                boolean bl = this._real().wrapBeforeEndOfStartTag(element);
                return bl;
            }
            catch (Throwable throwable) {
                this._log(element, throwable);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.wrapBeforeEndOfStartTag(element);
                return bl;
            }
        }

        public String toString() {
            return super.toString() + "-" + this._real();
        }

        private void _log(Node node, Throwable throwable) {
            LogUtils.log((Logger)TextSyncContext.ra$_LOGGER(), (Level)Level.WARNING, (String)"Exception calling text sync options {0} with param {1}!", (Object[])new Object[]{this._real(), node == null ? "null" : node.getNodeName()}, (Throwable)throwable);
        }

        private void _log(Throwable throwable) {
            LogUtils.log((Logger)TextSyncContext.ra$_LOGGER(), (Level)Level.WARNING, (String)"Exception calling text sync options {0}!", (Object)this._real(), (Throwable)throwable);
        }

        private TextSyncOptions _real() {
            return TextSyncContext.ra$_model(TextSyncContext.this).getParserConfiguration().getTextSyncOptions();
        }

        private TolerantTextSyncOptions() {
        }

        TolerantTextSyncOptions(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

