/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.grammar.schema.error.XmlErrorLog;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WellFormednessChecker {
    private final BufferDomModel _model;
    private static final Pattern _XDK_ERR_PATTERN = Pattern.compile("(<Line [0-9]+, Column [0-9]+>:)? ([^:]+): \\(([^)]+)\\) (.*)", 32);
    private static final Logger _LOGGER = Logger.getLogger(WellFormednessChecker.class.getName());

    public static XmlErrorLog doWFCheck(Locale locale, InputSource inputSource) {
        XmlErrorLog xmlErrorLog = new XmlErrorLog();
        SAXParser sAXParser = new SAXParser();
        try {
            sAXParser.setLocale(locale);
        }
        catch (SAXException sAXException) {
            _LOGGER.log(Level.WARNING, "SAXException encountered in SAXParser.setLocale", sAXException);
        }
        sAXParser.setDoctype(new DTD());
        sAXParser.setValidationMode(0);
        sAXParser.setErrorHandler((ErrorHandler)xmlErrorLog);
        try {
            sAXParser.parse(inputSource);
        }
        catch (IOException iOException) {
        }
        catch (XMLParseException xMLParseException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            _LOGGER.log(Level.SEVERE, "Unexpected exception from XDK in WFCheck", throwable);
            SAXParseException sAXParseException = new SAXParseException(throwable.getMessage(), null);
            sAXParseException.initCause(throwable);
            try {
                xmlErrorLog.fatalError(sAXParseException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return xmlErrorLog;
    }

    public WellFormednessChecker(BufferDomModel bufferDomModel) {
        this._model = bufferDomModel;
    }

    public List check() {
        Logger logger = _LOGGER;
        if (logger.isLoggable(Level.FINE)) {
            long l = System.currentTimeMillis();
            List list = this._check();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            logger.log(Level.FINE, "WFCheck completed in {0}ms", new Long(l3));
            return list;
        }
        return this._check();
    }

    private List _check() {
        Reader reader = null;
        try {
            reader = TextBufferFactory.createReader((ReadTextBuffer)this._getBuffer());
            InputSource inputSource = new InputSource(reader);
            XmlErrorLog xmlErrorLog = WellFormednessChecker.doWFCheck(this._model.getContext().getLocale(), inputSource);
            List list = this._processLog(xmlErrorLog);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    _LOGGER.log(Level.SEVERE, "IOException closing text buffer reader", iOException);
                }
            }
            return list;
        }
        catch (Throwable throwable) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    _LOGGER.log(Level.SEVERE, "IOException closing text buffer reader", iOException);
                }
            }
            throw throwable;
        }
    }

    private TextBuffer _getBuffer() {
        return this._model.getTextBuffer();
    }

    private LocatorManager _getLocatorManager() {
        return this._model.getLocatorManager();
    }

    private List _processLog(XmlErrorLog xmlErrorLog) {
        XmlErrorLog.Error[] errorArray = xmlErrorLog.getErrors();
        XmlErrorLog.Error[] errorArray2 = xmlErrorLog.getFatalErrors();
        XmlErrorLog.Error[] errorArray3 = xmlErrorLog.getWarnings();
        ArrayList arrayList = new ArrayList(errorArray.length + errorArray2.length + errorArray3.length);
        this._appendErrors(arrayList, errorArray, 2);
        this._appendErrors(arrayList, errorArray2, 3);
        this._appendErrors(arrayList, errorArray3, 1);
        return arrayList;
    }

    private void _appendErrors(List list, XmlErrorLog.Error[] errorArray, int n) {
        int n2 = 0;
        while (n2 < errorArray.length) {
            XmlErrorLog.Error error = errorArray[n2];
            int n3 = this._getOffset(error.getLine() - 1, error.getColumn() - 1);
            SimpleLocator simpleLocator = n3 >= 0 ? this._createLocator(n3, n3) : null;
            String string = error.getMessage();
            String string2 = null;
            Matcher matcher = _XDK_ERR_PATTERN.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(4);
                string2 = matcher.group(2);
            }
            WFError wFError = new WFError(n, string, string2, simpleLocator);
            list.add(wFError);
            ++n2;
        }
    }

    private SimpleLocator _createLocator(int n, int n2) {
        return this._getLocatorManager().createSimpleLocator(n, n2, true);
    }

    private int _getOffset(int n, int n2) {
        LineMap lineMap;
        int n3;
        if (n >= 0 && (n3 = (lineMap = this._getBuffer().getLineMap()).getLineStartOffset(n)) >= 0) {
            if (n2 > 0) {
                n3 += n2;
            }
            return n3;
        }
        return -1;
    }

    static LocatorManager mav$_getLocatorManager(WellFormednessChecker wellFormednessChecker) {
        return wellFormednessChecker._getLocatorManager();
    }

    public class WFError
    extends DomParseProblem {
        private final int _severity;
        private final String _message;
        private final String _errCode;
        private SimpleLocator _locator;

        public WFError(int n, String string, String string2, SimpleLocator simpleLocator) {
            this._severity = n;
            this._message = string;
            this._errCode = string2;
            this._locator = simpleLocator;
        }

        public String getMessage() {
            return this._message;
        }

        public String getErrCode() {
            return this._errCode;
        }

        public int getProblemTextEndOffset() {
            if (this._locator != null) {
                return this._locator.getEndOffset();
            }
            return super.getProblemTextEndOffset();
        }

        public int getProblemTextStartOffset() {
            if (this._locator != null) {
                return this._locator.getStartOffset();
            }
            return super.getProblemTextStartOffset();
        }

        public int getSeverity() {
            return this._severity;
        }

        public void dispose() {
            super.dispose();
            if (this._locator != null) {
                WellFormednessChecker.mav$_getLocatorManager(WellFormednessChecker.this).detach(this._locator);
            }
            this._locator = null;
        }

        public int getLineNumber() {
            if (this._locator != null) {
                return this._locator.getLineNumber();
            }
            return -1;
        }

        public int getColumnNumber() {
            if (this._locator != null) {
                return this._locator.getColumnNumber();
            }
            return -1;
        }

        public String toString() {
            return "[" + this.getProblemTextStartOffset() + " - " + this.getProblemTextEndOffset() + "] " + this.getMessage() + " (severity " + this.getSeverity() + ")";
        }
    }
}

