/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;

public class XMLLexer
extends AbstractLexer
implements XMLTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipComments = false;

    public XMLLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        int n;
        block28: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            int n2 = -1;
            n = -1;
            this.lastToken = 0;
            try {
                block11: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            if (n2 == -1) {
                                n2 = this.currentPos - 1;
                            }
                            n = this.currentPos;
                            continue block11;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '<': {
                            if (n2 != -1) {
                                this.lastToken = 16;
                                --this.currentPos;
                                this.startOffset = n2;
                                break block11;
                            }
                            this.lastToken = 12;
                            if (this.textBuffer.getChar(this.currentPos) == '!') {
                                ++this.currentPos;
                                this.lastToken = 16;
                                if (this.textBuffer.getChar(this.currentPos) == '-' && this.textBuffer.getChar(this.currentPos + 1) == '-') {
                                    this.currentPos += 2;
                                    this.lastToken = 13;
                                    this.skipComment();
                                    if (this.skipComments) {
                                        this.lastToken = 0;
                                        break;
                                    }
                                    break block28;
                                }
                                if (this.textBuffer.getChar(this.currentPos) == '[') {
                                    if (this.textBuffer.getChar(this.currentPos + 1) == 'C' && this.textBuffer.getChar(this.currentPos + 2) == 'D' && this.textBuffer.getChar(this.currentPos + 3) == 'A' && this.textBuffer.getChar(this.currentPos + 4) == 'T' && this.textBuffer.getChar(this.currentPos + 5) == 'A' && this.textBuffer.getChar(this.currentPos + 6) == '[') {
                                        this.lastToken = 17;
                                        this.skipCDATASection();
                                        break block11;
                                    }
                                    break block28;
                                } else if (this.textBuffer.getChar(this.currentPos) == 'D' && this.textBuffer.getChar(this.currentPos + 1) == 'O' && this.textBuffer.getChar(this.currentPos + 2) == 'C' && this.textBuffer.getChar(this.currentPos + 3) == 'T' && this.textBuffer.getChar(this.currentPos + 4) == 'Y' && this.textBuffer.getChar(this.currentPos + 5) == 'P' && this.textBuffer.getChar(this.currentPos + 6) == 'E') {
                                    this.lastToken = 18;
                                    this.skipDocumentType();
                                    break block11;
                                }
                                break block28;
                            }
                            if (this.textBuffer.getChar(this.currentPos) == '?') {
                                ++this.currentPos;
                                this.lastToken = 15;
                                if (this.textBuffer.getChar(this.currentPos) == 'x' && this.textBuffer.getChar(this.currentPos + 1) == 'm' && this.textBuffer.getChar(this.currentPos + 2) == 'l') {
                                    this.lastToken = 14;
                                    switch (this.textBuffer.getChar(this.currentPos + 3)) {
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case '\r': 
                                        case ' ': 
                                        case '?': {
                                            this.skipDeclaration();
                                            break;
                                        }
                                        default: {
                                            this.lastToken = 15;
                                            this.skipProcessingInstruction();
                                            break;
                                        }
                                    }
                                    break block11;
                                }
                                this.skipProcessingInstruction();
                                break block11;
                            }
                            this.lastToken = this.skipElementTag();
                            break block11;
                        }
                        default: {
                            if (n2 == -1) {
                                n2 = this.currentPos - 1;
                            }
                            n = this.currentPos;
                            break;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    if (n2 != -1) {
                        this.lastToken = 16;
                        this.startOffset = n2;
                    } else {
                        this.startOffset = this.currentPos;
                    }
                }
                if (!this.skipComments || this.lastToken != 13) break block28;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = n == -1 ? this.currentPos : n;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    private void skipComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private int skipElementTag() {
        boolean bl = this.skipToTagEnd();
        if (bl) {
            return 11;
        }
        return 12;
    }

    private void skipDocumentType() {
        this.currentPos += 7;
        char c = '\u0000';
        boolean bl = false;
        block7: while (true) {
            char c2 = this.textBuffer.getChar(this.currentPos++);
            switch (c2) {
                case '\"': 
                case '\'': {
                    if (c != '\u0000') {
                        if (c != c2) continue block7;
                        c = '\u0000';
                        break;
                    }
                    c = c2;
                    break;
                }
                case '[': {
                    if (c != '\u0000') continue block7;
                    bl = true;
                    break;
                }
                case ']': {
                    if (c != '\u0000') continue block7;
                    bl = false;
                    break;
                }
                case '>': {
                    if (c != '\u0000' || bl) continue block7;
                    return;
                }
                case '<': {
                    if (bl) continue block7;
                    --this.currentPos;
                    return;
                }
            }
        }
    }

    private void skipCDATASection() {
        char c;
        this.currentPos += 7;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != ']' || this.textBuffer.getChar(this.currentPos) != ']' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipDeclaration() {
        this.skipToTagEnd();
    }

    private void skipProcessingInstruction() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '?' || this.textBuffer.getChar(this.currentPos) != '>') {
        }
        ++this.currentPos;
    }

    private boolean skipToTagEnd() {
        char c = '\u0000';
        block5: while (true) {
            char c2 = this.textBuffer.getChar(this.currentPos++);
            switch (c2) {
                case '\"': 
                case '\'': {
                    if (c != '\u0000') {
                        if (c != c2) continue block5;
                        c = '\u0000';
                        break;
                    }
                    c = c2;
                    break;
                }
                case '>': {
                    if (c != '\u0000') continue block5;
                    return true;
                }
                case '<': {
                    --this.currentPos;
                    return false;
                }
            }
        }
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 11: {
                return "TK_XML_ELEMENT";
            }
            case 12: {
                return "TK_XML_ELEMENT_INCOMPLETE";
            }
            case 13: {
                return "TK_XML_COMMENT";
            }
            case 14: {
                return "TK_XML_DECLARATION";
            }
            case 15: {
                return "TK_XML_PROCESSING_INSTRUCTION";
            }
            case 16: {
                return "TK_XML_TEXT";
            }
            case 17: {
                return "TK_XML_CDATA";
            }
            case 18: {
                return "TK_XML_DOCUMENT_TYPE";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 11: {
                return "XML Element";
            }
            case 12: {
                return "XML Element Incomplete";
            }
            case 13: {
                return "XML Comment";
            }
            case 14: {
                return "XML Declaration";
            }
            case 15: {
                return "XML Processing Instruction";
            }
            case 16: {
                return "XML Text";
            }
            case 17: {
                return "XML CDATA Section";
            }
            case 18: {
                return "XML Document Type";
            }
        }
        return "**UNKNOWN**";
    }
}

