/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLTagTokens;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;

public class XMLTagLexer
extends AbstractLexer
implements XMLTagTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipSymbols = false;
    private int nextNameType;

    public XMLTagLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipSymbols(boolean bl) {
        this.skipSymbols = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        block11: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            this.lastToken = 0;
            try {
                block9: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block9;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '=': {
                            this.nextNameType = 23;
                        }
                        case '/': 
                        case '<': 
                        case '>': 
                        case '?': {
                            this.lastToken = 24;
                            if (!this.skipSymbols) break block9;
                            this.lastToken = 0;
                            continue block9;
                        }
                        default: {
                            this.lastToken = this.nextNameType;
                            this.nextNameType = 22;
                            --this.currentPos;
                            this.skipNameOrValue();
                            break block9;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block11;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
        this.nextNameType = 21;
    }

    public int skipNameOrValue(boolean bl) {
        char c = '\u0000';
        block6: while (true) {
            char c2 = this.textBuffer.getChar(this.currentPos++);
            switch (c2) {
                case '[': {
                    if (!bl) continue block6;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '=': 
                case '>': 
                case '?': {
                    if (c != '\u0000') continue block6;
                    --this.currentPos;
                    return this.currentPos;
                }
                case '<': {
                    --this.currentPos;
                    return this.currentPos;
                }
                case '\"': 
                case '\'': {
                    if (c != '\u0000') {
                        if (c != c2) continue block6;
                        c = '\u0000';
                        break;
                    }
                    c = c2;
                    break;
                }
            }
        }
    }

    private void skipNameOrValue() {
        this.skipNameOrValue(false);
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 21: {
                return "TK_ELEMENT_NAME";
            }
            case 22: {
                return "TK_ATTRIBUTE_NAME";
            }
            case 23: {
                return "TK_ATTRIBUTE_VALUE";
            }
            case 24: {
                return "TK_SYMBOL";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 21: {
                return "Element name";
            }
            case 22: {
                return "Attribute name";
            }
            case 23: {
                return "Attribute value";
            }
            case 24: {
                return "Tag symbol";
            }
        }
        return "**UNKNOWN**";
    }
}

