/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.javatools.buffer.LineMap;

public class AttributeLocator
extends Locator {
    public static final short STYLE_SINGLE = 0;
    public static final short STYLE_DOUBLE = 1;
    public static final short STYLE_MISSING = 2;
    public static final short USAGE_NORMAL = 0;
    public static final short USAGE_MISSING_START = 1;
    public static final short USAGE_MISSING_END = 2;
    public static final short USAGE_MISSING_BOTH = 3;
    private SimpleLocator _nameLocator;
    private SimpleLocator _equalsLocator;
    private TextLocator _valueLocator;
    private short _quoteStyle;
    private short _quoteUsage;
    private boolean _specified;

    public Locator getCopy() {
        AttributeLocator attributeLocator = new AttributeLocator(this.getLineMap(), (SimpleLocator)Locator.getCopy(this._nameLocator));
        attributeLocator.setQuoteStyle(this._quoteStyle);
        attributeLocator.setQuoteUsage(this._quoteUsage);
        if (this._equalsLocator != null) {
            attributeLocator.setEqualsLocator((SimpleLocator)this._equalsLocator.getCopy());
        }
        if (this._valueLocator != null) {
            attributeLocator.setValueLocator((TextLocator)this._valueLocator.getCopy());
        }
        attributeLocator.setSpecified(this.isSpecified());
        return attributeLocator;
    }

    public int getStartOffset() {
        return this._nameLocator.getStartOffset();
    }

    public int getEndOffset() {
        if (this._valueLocator != null) {
            return this._valueLocator.getEndOffset();
        }
        if (this._equalsLocator != null) {
            return this._equalsLocator.getEndOffset();
        }
        return this._nameLocator.getEndOffset();
    }

    public void attach(LocatorManager locatorManager, boolean bl) {
        Locator.attach(locatorManager, bl, this._nameLocator);
        Locator.attach(locatorManager, bl, this._equalsLocator);
        Locator.attach(locatorManager, bl, this._valueLocator);
    }

    public SimpleLocator getNameLocator() {
        return this._nameLocator;
    }

    public void setNameLocator(SimpleLocator simpleLocator) {
        this._nameLocator = simpleLocator;
    }

    public TextLocator getValueLocator() {
        return this._valueLocator;
    }

    public void setValueLocator(TextLocator textLocator) {
        this._valueLocator = textLocator;
    }

    public SimpleLocator getEqualsLocator() {
        return this._equalsLocator;
    }

    public void setEqualsLocator(SimpleLocator simpleLocator) {
        this._equalsLocator = simpleLocator;
    }

    public short getQuoteStyle() {
        return this._quoteStyle;
    }

    public void setQuoteStyle(short s) {
        this._quoteStyle = s;
    }

    public short getQuoteUsage() {
        return this._quoteUsage;
    }

    public void setQuoteUsage(short s) {
        this._quoteUsage = s;
    }

    public boolean isSpecified() {
        return this._specified;
    }

    public void setSpecified(boolean bl) {
        this._specified = bl;
    }

    public final boolean isStartQuotePresent() {
        return this._quoteUsage == 0 || this._quoteUsage == 2;
    }

    public final boolean isEndQuotePresent() {
        return this._quoteUsage == 0 || this._quoteUsage == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("attrLocator[");
        stringBuffer.append("name: " + this._nameLocator);
        stringBuffer.append(", equals: " + this._equalsLocator);
        stringBuffer.append(", value: " + this._valueLocator);
        stringBuffer.append(this._usageAndStyle());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String _usageAndStyle() {
        switch (this._quoteUsage) {
            case 3: {
                return ", missing both";
            }
            case 2: {
                return ", missing end, " + this._style();
            }
            case 1: {
                return ", missing start, " + this._style();
            }
            case 0: {
                return ", normal, " + this._style();
            }
        }
        return "invalid value";
    }

    private String _style() {
        switch (this._quoteStyle) {
            case 1: {
                return "\"";
            }
            case 0: {
                return "'";
            }
        }
        return "missing";
    }

    protected AttributeLocator(LineMap lineMap, SimpleLocator simpleLocator) {
        super(lineMap);
        this.$init$();
        this._nameLocator = simpleLocator;
    }

    void $init$() {
        this._nameLocator = null;
        this._equalsLocator = null;
        this._valueLocator = null;
        this._quoteStyle = (short)2;
        this._quoteUsage = (short)3;
        this._specified = true;
    }
}

