/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.javatools.buffer.LineMap;

public abstract class Locator
implements org.xml.sax.Locator {
    private final LineMap _lineMap;

    public static void attach(LocatorManager locatorManager, boolean bl, Locator locator) {
        if (locator != null) {
            locator.attach(locatorManager, bl);
        }
    }

    public static Locator getCopy(Locator locator) {
        if (locator == null) {
            return null;
        }
        return locator.getCopy();
    }

    public static int getColumnNumber(LineMap lineMap, int n) {
        int n2 = -1;
        int n3 = Locator.getLineNumber(lineMap, n);
        if (n3 > 0) {
            int n4 = lineMap.getLineStartOffset(n3 - 1);
            n2 = n - n4 + 1;
        }
        return n2;
    }

    public static int getLineNumber(LineMap lineMap, int n) {
        int n2 = -1;
        if (n != -1) {
            n2 = lineMap.getLineFromOffset(n) + 1;
        }
        return n2;
    }

    public abstract Locator getCopy();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public abstract void attach(LocatorManager var1, boolean var2);

    public final int getColumnNumber() {
        return this.getEndColumnNumber();
    }

    public final int getLineNumber() {
        return this.getEndLineNumber();
    }

    public final int getEndColumnNumber() {
        return Locator.getColumnNumber(this._lineMap, this.getEndOffset());
    }

    public final int getEndLineNumber() {
        return Locator.getLineNumber(this._lineMap, this.getEndOffset());
    }

    public final int getStartColumnNumber() {
        return Locator.getColumnNumber(this._lineMap, this.getStartOffset());
    }

    public final int getStartLineNumber() {
        return Locator.getLineNumber(this._lineMap, this.getStartOffset());
    }

    public final int getLength() {
        int n = this.getEndOffset() - this.getStartOffset();
        if (n < 0) {
            throw new IllegalStateException("locator.getLength called but length is negative! " + this);
        }
        return n;
    }

    public final boolean contains(int n) {
        return n >= this.getStartOffset() && n < this.getEndOffset();
    }

    public final boolean containsNotAtStart(int n) {
        return n > this.getStartOffset() && n < this.getEndOffset();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    protected LineMap getLineMap() {
        return this._lineMap;
    }

    protected Locator(LineMap lineMap) {
        this._lineMap = lineMap;
    }
}

