/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.BackwardsBiasedSimpleLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.javatools.buffer.LineMap;

public class LocatorManager {
    private LinkedHashSet _locatorSet;
    private LineMap _lineMap;
    private static final Logger _LOGGER = Logger.getLogger(LocatorManager.class.getName());

    public LocatorManager(LineMap lineMap) {
        this._lineMap = lineMap;
        this._locatorSet = new LinkedHashSet();
    }

    public SimpleLocator createSimpleLocator(int n, int n2) {
        return this.createSimpleLocator(n, n2, true);
    }

    public SimpleLocator createSimpleLocator(int n, int n2, boolean bl) {
        SimpleLocator simpleLocator = new SimpleLocator(this._lineMap, n, n2);
        if (bl) {
            this.attach(simpleLocator);
        }
        return simpleLocator;
    }

    public SimpleLocator createBackwardsBiasedSimpleLocator(int n, int n2, boolean bl) {
        BackwardsBiasedSimpleLocator backwardsBiasedSimpleLocator = new BackwardsBiasedSimpleLocator(this._lineMap, n, n2);
        if (bl) {
            this.attach(backwardsBiasedSimpleLocator);
        }
        return backwardsBiasedSimpleLocator;
    }

    public EntityRefLocator createEntityRefLocator(int n, int n2, String string, String string2, boolean bl) {
        EntityRefLocator entityRefLocator = new EntityRefLocator(this._lineMap, n, n2, string, string2);
        if (bl) {
            this.attach(entityRefLocator);
        }
        return entityRefLocator;
    }

    public ElementLocator createElementLocator(SimpleLocator simpleLocator) {
        return this.createElementLocator(simpleLocator, null);
    }

    public ElementLocator createElementLocator(SimpleLocator simpleLocator, SimpleLocator simpleLocator2) {
        return this.createElementLocator(simpleLocator, simpleLocator2, null);
    }

    public ElementLocator createElementLocator(SimpleLocator simpleLocator, SimpleLocator simpleLocator2, SimpleLocator simpleLocator3) {
        ElementLocator elementLocator = new ElementLocator(this._lineMap, simpleLocator);
        if (simpleLocator2 != null) {
            elementLocator.setNameLocator(simpleLocator2);
        }
        if (simpleLocator3 != null) {
            elementLocator.setEndTagLocator(simpleLocator3);
        }
        return elementLocator;
    }

    public DeclarationLocator createDeclarationLocator(SimpleLocator simpleLocator) {
        return this.createDeclarationLocator(simpleLocator, null, null, null);
    }

    public DeclarationLocator createDeclarationLocator(SimpleLocator simpleLocator, AttributeLocator attributeLocator, AttributeLocator attributeLocator2, AttributeLocator attributeLocator3) {
        DeclarationLocator declarationLocator = new DeclarationLocator(this._lineMap, simpleLocator);
        declarationLocator.setVersionLocator(attributeLocator);
        declarationLocator.setEncodingLocator(attributeLocator2);
        declarationLocator.setStandaloneLocator(attributeLocator3);
        return declarationLocator;
    }

    public AttributeLocator createAttributeLocator(SimpleLocator simpleLocator) {
        return this.createAttributeLocator(simpleLocator, null, null, (short)2, (short)3);
    }

    public AttributeLocator createAttributeLocator(SimpleLocator simpleLocator, SimpleLocator simpleLocator2, TextLocator textLocator, short s, short s2) {
        AttributeLocator attributeLocator = new AttributeLocator(this._lineMap, simpleLocator);
        if (simpleLocator2 != null) {
            attributeLocator.setEqualsLocator(simpleLocator2);
        }
        if (textLocator != null) {
            attributeLocator.setValueLocator(textLocator);
            attributeLocator.setQuoteStyle(s);
            attributeLocator.setQuoteUsage(s2);
        }
        return attributeLocator;
    }

    public AttributeLocator createUnspecifiedAttributeLocator(int n) {
        SimpleLocator simpleLocator = this.createSimpleLocator(n, n);
        SimpleLocator simpleLocator2 = this.createSimpleLocator(n, n);
        SimpleLocator simpleLocator3 = this.createSimpleLocator(n, n);
        TextLocator textLocator = this.createTextLocator(Collections.singletonList(simpleLocator3));
        AttributeLocator attributeLocator = this.createAttributeLocator(simpleLocator, simpleLocator2, textLocator, (short)2, (short)3);
        attributeLocator.setSpecified(false);
        return attributeLocator;
    }

    public TextLocator createTextLocator(List list, List list2) {
        return new TextLocator(this.getLineMap(), list, list2);
    }

    public TextLocator createTextLocator(List list) {
        return this.createTextLocator(list, Collections.EMPTY_LIST);
    }

    public void attach(SimpleLocator simpleLocator, boolean bl) {
        if (bl) {
            this.attach(simpleLocator);
        } else {
            this.detach(simpleLocator);
        }
    }

    public void attach(SimpleLocator simpleLocator) {
        if (simpleLocator != null) {
            this._locatorSet.add(simpleLocator);
        }
    }

    public void detach(SimpleLocator simpleLocator) {
        if (simpleLocator != null) {
            this._locatorSet.remove(simpleLocator);
        }
    }

    public boolean isAttached(SimpleLocator simpleLocator) {
        return this._locatorSet.contains(simpleLocator);
    }

    public void charactersAdded(int n, int n2) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "LM: charactersAdded; offset={0} length={1}", new Object[]{String.valueOf(n), String.valueOf(n2)});
        }
        for (SimpleLocator simpleLocator : this._locatorSet) {
            simpleLocator.adjustForCharactersAdded(n, n2);
        }
    }

    public void charactersRemoved(int n, int n2) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "LM: charactersRemoved; offset={0} length={1}", new Object[]{String.valueOf(n), String.valueOf(n2)});
        }
        Iterator iterator = this._locatorSet.iterator();
        while (iterator.hasNext()) {
            SimpleLocator simpleLocator = (SimpleLocator)iterator.next();
            boolean bl = simpleLocator.adjustForCharactersRemoved(n, n2);
            if (!bl) continue;
            iterator.remove();
        }
    }

    public void charactersAdded(Locator locator) {
        locator.attach(this, false);
        this.charactersAdded(locator.getStartOffset(), locator.getLength());
        locator.attach(this, true);
    }

    public void charactersRemoved(Locator locator) {
        locator.attach(this, false);
        this.charactersRemoved(locator.getStartOffset(), locator.getLength());
    }

    public void locatorLengthChanged(SimpleLocator simpleLocator, int n) {
        int n2 = simpleLocator.getStartOffset();
        int n3 = simpleLocator.getEndOffset();
        int n4 = n2 + n;
        simpleLocator.setEndOffset(n4);
        this.detach(simpleLocator);
        if (n4 > n3) {
            this.charactersAdded(n3, n4 - n3);
        } else if (n4 < n3) {
            this.charactersRemoved(n4, n3 - n4);
        }
        this.attach(simpleLocator);
    }

    public void addEndTagAtLocator(ElementLocator elementLocator, SimpleLocator simpleLocator) {
        this.charactersAdded(simpleLocator);
        elementLocator.setEndTagLocator(simpleLocator);
    }

    public void removeEndTagAtLocator(ElementLocator elementLocator) {
        SimpleLocator simpleLocator = elementLocator.getEndTagLocator();
        elementLocator.setEndTagLocator(null);
        if (simpleLocator != null) {
            this.charactersRemoved(simpleLocator);
        }
    }

    public void addSlashAtLocator(ElementLocator elementLocator, SimpleLocator simpleLocator) {
        this.charactersAdded(simpleLocator);
        elementLocator.setSlashLocator(simpleLocator);
    }

    public void removeSlashAtLocator(ElementLocator elementLocator) {
        SimpleLocator simpleLocator = elementLocator.getSlashLocator();
        elementLocator.setSlashLocator(null);
        if (simpleLocator != null) {
            this.charactersRemoved(simpleLocator);
        }
    }

    public final LineMap getLineMap() {
        return this._lineMap;
    }

    public final void setLineMap(LineMap lineMap) {
        this._lineMap = lineMap;
    }

    public final void clear() {
        this._locatorSet.clear();
    }

    private String _setQuoteStyle(AttributeLocator attributeLocator, String string) {
        int n = 0;
        int n2 = string.length();
        short s = 2;
        short s2 = 3;
        if (n2 - n >= 1) {
            char c = string.charAt(n);
            if (c == '\"') {
                s = 1;
            } else if (c == '\'') {
                s = 0;
            }
            if (s != 2) {
                s2 = 2;
                ++n;
            }
        }
        if (n2 - n >= 1) {
            char c = string.charAt(n2 - 1);
            if (c == '\"') {
                if (s == 1) {
                    s2 = 0;
                } else if (s == 2) {
                    s = 1;
                    s2 = 1;
                }
            } else if (c == '\'') {
                if (s == 0) {
                    s2 = 0;
                } else if (s == 2) {
                    s = 0;
                    s2 = 1;
                }
            }
            if (s2 == 0 || s2 == 1) {
                --n2;
            }
        }
        String string2 = string.substring(n, n2);
        if (attributeLocator != null) {
            attributeLocator.setQuoteStyle(s);
            attributeLocator.setQuoteUsage(s2);
        }
        return string2;
    }
}

