/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.javatools.buffer.LineMap;

public class SimpleLocator
extends Locator
implements Comparable {
    private int _startOffset;
    private int _endOffset;

    public Locator getCopy() {
        return new SimpleLocator(this.getLineMap(), this._startOffset, this._endOffset);
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public void attach(LocatorManager locatorManager, boolean bl) {
        locatorManager.attach(this, bl);
    }

    public void setStartOffset(int n) {
        this._startOffset = n;
    }

    public void setEndOffset(int n) {
        this._endOffset = n;
    }

    public void move(int n) {
        this.setStartOffset(this.getStartOffset() + n);
        this.setEndOffset(this.getEndOffset() + n);
    }

    public int getDomLength() {
        return this.getLength();
    }

    public String toString() {
        return this._startOffset + "-" + this._endOffset;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof SimpleLocator)) {
            throw new IllegalArgumentException("can't compare " + this + " and " + object);
        }
        SimpleLocator simpleLocator = (SimpleLocator)object;
        int n = this.getStartOffset() - simpleLocator.getStartOffset();
        if (n != 0) {
            return n;
        }
        return this.getEndOffset() - simpleLocator.getEndOffset();
    }

    protected void adjustForCharactersAdded(int n, int n2) {
        if (this.getLength() == 0) {
            if (this._startOffset >= n) {
                this.move(n2);
            }
        } else {
            if (this._startOffset >= n) {
                this._startOffset += n2;
            }
            if (this._endOffset > n) {
                this._endOffset += n2;
            }
        }
    }

    protected boolean adjustForCharactersRemoved(int n, int n2) {
        int n3 = n + n2;
        if (this.getLength() == 0 && this._startOffset >= n3) {
            this.move(-n2);
            return false;
        }
        if (this._startOffset >= n) {
            if (this._endOffset <= n3) {
                return true;
            }
            if (this._startOffset < n3) {
                throw new IllegalArgumentException("charactersRemoved called with dubious offset and length. offset=" + n + " length=" + n2 + " dubious locator=" + this);
            }
            this._startOffset -= n2;
        }
        if (this._endOffset > n) {
            if (this._endOffset >= n3) {
                this._endOffset -= n2;
            } else {
                throw new IllegalArgumentException("charactersRemoved called with dubious offset and length. offset=" + n + " length=" + n2 + " dubious locator=" + this);
            }
        }
        return false;
    }

    protected SimpleLocator(LineMap lineMap, int n, int n2) {
        super(lineMap);
        this.$init$();
        this._startOffset = n;
        this._endOffset = n2;
    }

    void $init$() {
        this._startOffset = 0;
        this._endOffset = 0;
    }
}

