/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.util.CollectionUtils;
import oracle.javatools.buffer.LineMap;

public class TextLocator
extends Locator {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final List _whitespaceLocators;
    private List _contentLocators;
    private SimpleLocator _firstLocator;
    private SimpleLocator _lastLocator;

    public static List copyLocatorList(List list) {
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Locator> arrayList = new ArrayList<Locator>(list.size());
        for (Locator locator : list) {
            arrayList.add(locator.getCopy());
        }
        return arrayList;
    }

    public Locator getCopy() {
        List list = TextLocator.copyLocatorList(this._contentLocators);
        List list2 = TextLocator.copyLocatorList(this._whitespaceLocators);
        TextLocator textLocator = new TextLocator(this.getLineMap(), list, list2);
        return textLocator;
    }

    public int getStartOffset() {
        return this._firstLocator.getStartOffset();
    }

    public int getEndOffset() {
        return this._lastLocator.getEndOffset();
    }

    public List getContentLocators() {
        return this._contentLocators;
    }

    public List getWhitespaceLocators() {
        return this._whitespaceLocators;
    }

    public void attach(LocatorManager locatorManager, boolean bl) {
        this._attachAll(locatorManager, this._contentLocators, bl);
        this._attachAll(locatorManager, this._whitespaceLocators, bl);
    }

    public int getContentTextOffset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative content index: " + n);
        }
        Iterator iterator = this._contentLocators.iterator();
        while (iterator.hasNext()) {
            SimpleLocator simpleLocator = (SimpleLocator)iterator.next();
            int n2 = simpleLocator.getDomLength();
            if (n2 > n) {
                if (simpleLocator instanceof EntityRefLocator) {
                    EntityRefLocator entityRefLocator = (EntityRefLocator)simpleLocator;
                    return entityRefLocator.getStartOffset();
                }
                return simpleLocator.getStartOffset() + n;
            }
            if (n2 == n && !iterator.hasNext()) {
                return this.getEndOffset();
            }
            n -= n2;
        }
        throw new IllegalArgumentException("index not found: " + n);
    }

    static {
        $assertionsDisabled = TextLocator.class.desiredAssertionStatus() ^ true;
    }

    public void removeFirstCharFromContent() {
        this._firstLocator.setStartOffset(this._firstLocator.getStartOffset() + 1);
        if (this._firstLocator.getLength() == 0) {
            if (!$assertionsDisabled && this._contentLocators.size() <= 1) {
                throw new AssertionError();
            }
            this._makeContentLocatorModifiable();
            this._contentLocators.remove(0);
            this._firstLocator = (SimpleLocator)this._contentLocators.get(0);
        }
    }

    public void removeLastCharFromContent() {
        this._lastLocator.setEndOffset(this._lastLocator.getEndOffset() - 1);
        if (this._lastLocator.getLength() == 0) {
            if (!$assertionsDisabled && this._contentLocators.size() <= 1) {
                throw new AssertionError();
            }
            int n = this._contentLocators.size() - 1;
            this._makeContentLocatorModifiable();
            this._contentLocators.remove(n);
            this._lastLocator = (SimpleLocator)this._contentLocators.get(n - 1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TextLocator{");
        stringBuffer.append("content=");
        stringBuffer.append(this._contentLocators);
        stringBuffer.append(" ws=");
        stringBuffer.append(this._whitespaceLocators);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected TextLocator(LineMap lineMap, List list, List list2) {
        super(lineMap);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("need at least one content locator");
        }
        this._contentLocators = list;
        this._whitespaceLocators = list2;
        this._sort(this._contentLocators);
        SimpleLocator simpleLocator = (SimpleLocator)this._contentLocators.get(0);
        SimpleLocator simpleLocator2 = (SimpleLocator)this._contentLocators.get(this._contentLocators.size() - 1);
        if (!this._whitespaceLocators.isEmpty()) {
            this._sort(this._whitespaceLocators);
            SimpleLocator simpleLocator3 = (SimpleLocator)this._whitespaceLocators.get(0);
            if (simpleLocator3.compareTo(simpleLocator) < 0) {
                simpleLocator = simpleLocator3;
            }
            if ((simpleLocator3 = (SimpleLocator)this._whitespaceLocators.get(this._whitespaceLocators.size() - 1)).compareTo(simpleLocator2) > 0) {
                simpleLocator2 = simpleLocator3;
            }
        }
        this._firstLocator = simpleLocator;
        this._lastLocator = simpleLocator2;
    }

    private void _attachAll(LocatorManager locatorManager, List list, boolean bl) {
        for (Locator locator : list) {
            locator.attach(locatorManager, bl);
        }
    }

    private void _sort(List list) {
        if (list.size() > 1) {
            Collections.sort(list);
        }
    }

    private void _makeContentLocatorModifiable() {
        if (CollectionUtils.isUnmodifiableList(this._contentLocators, 0)) {
            this._contentLocators = new ArrayList(this._contentLocators);
        }
    }
}

