/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.DocumentScannerScope;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class DocumentScanner {
    private ReadTextBuffer _buffer;
    private DocumentHandler _handler;
    private LocatorManager _manager;
    private Lexer _documentLexer;
    private Lexer _elementLexer;
    private ElementDeclaration _currentElementDecl;
    private boolean _reuseAttributeDecls;
    private int _caretPosition;
    private boolean _stopRequested;
    private static final HashMap _predefinedEntities = new HashMap(13);
    private static final char[] _defaultEntityStartCharacters;

    public DocumentScanner(Lexer lexer, Lexer lexer2) {
        this.$init$();
        if (lexer == null || lexer2 == null) {
            throw new IllegalArgumentException("DocumentScanner() parametersmust not be null");
        }
        this._documentLexer = lexer;
        this._elementLexer = lexer2;
    }

    public final void scanDocument(ReadTextBuffer readTextBuffer, DocumentHandler documentHandler, LocatorManager locatorManager) {
        this.scanDocument(readTextBuffer, documentHandler, locatorManager, null);
    }

    public final void scanDocument(ReadTextBuffer readTextBuffer, DocumentHandler documentHandler, LocatorManager locatorManager, NamespaceDeclarations namespaceDeclarations) {
        this.scanDocument(readTextBuffer, documentHandler, locatorManager, namespaceDeclarations, -1);
    }

    public final void scanDocument(ReadTextBuffer readTextBuffer, DocumentHandler documentHandler, LocatorManager locatorManager, NamespaceDeclarations namespaceDeclarations, int n) {
        if (readTextBuffer == null || documentHandler == null || locatorManager == null) {
            throw new IllegalArgumentException("first three scanDocument() parameters must not be null");
        }
        boolean bl = false;
        this._caretPosition = n;
        if (this._caretPosition > -1) {
            bl = true;
        }
        this._stopRequested = false;
        this._handler = documentHandler;
        this._buffer = readTextBuffer;
        this._manager = locatorManager;
        this.initializeScannerState();
        this._documentLexer.setTextBuffer(this._buffer);
        this._documentLexer.setPosition(0);
        this._elementLexer.setTextBuffer(this._buffer);
        this._elementLexer.setPosition(0);
        this._currentElementDecl = new ElementDeclaration();
        if (namespaceDeclarations == null) {
            namespaceDeclarations = new NamespaceDeclarations();
        }
        this.addBuiltInNamespaceDeclarations(namespaceDeclarations);
        ArrayList<DocumentScannerScope> arrayList = new ArrayList<DocumentScannerScope>();
        arrayList.add(new DocumentScannerScope(-1));
        LexerToken lexerToken = this._documentLexer.createLexerToken();
        this._documentLexer.lex(lexerToken);
        boolean bl2 = false;
        while (lexerToken.getToken() != 0) {
            if (this._stopRequested || bl && lexerToken.getStartOffset() > this._caretPosition) {
                bl2 = true;
                break;
            }
            this.parseDocumentToken(lexerToken, namespaceDeclarations, arrayList);
            this._documentLexer.lex(lexerToken);
        }
        if (!bl2) {
            this.simulateEndElements(namespaceDeclarations, arrayList, 0, lexerToken.getStartOffset());
        }
        this.cleanupScannerState();
    }

    public void setReuseAttributeDeclarations(boolean bl) {
        this._reuseAttributeDecls = bl;
    }

    public void stopScanning() {
        this._stopRequested = true;
    }

    protected abstract boolean parseDocumentToken(LexerToken var1, NamespaceDeclarations var2, List var3);

    protected abstract boolean parseElementToken(LexerToken var1, ElementDeclaration var2, NamespaceDeclarations var3, DocumentScannerScope var4, int var5, int var6);

    protected abstract void addBuiltInNamespaceDeclarations(NamespaceDeclarations var1);

    protected void initializeScannerState() {
    }

    protected void cleanupScannerState() {
    }

    protected void preProcessElement(LexerToken lexerToken, NamespaceDeclarations namespaceDeclarations, List list, boolean bl) {
    }

    protected void postProcessElement(ResolvedName resolvedName, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations) {
    }

    protected void postProcessAttribute(ResolvedName resolvedName, String string, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope) {
    }

    protected void updateAttributeNames(ResolvedName resolvedName, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope) {
    }

    protected ResolvedName createResolvedName(String string, NamespaceDeclarations namespaceDeclarations, boolean bl) {
        return new ResolvedName(string, namespaceDeclarations, bl);
    }

    protected void parseElement(LexerToken lexerToken, NamespaceDeclarations namespaceDeclarations, List list, boolean bl) {
        this.preProcessElement(lexerToken, namespaceDeclarations, list, bl);
        this._currentElementDecl.clear(this._reuseAttributeDecls);
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
        ElementLocator elementLocator = this._manager.createElementLocator(simpleLocator);
        elementLocator.setStartTagComplete(bl);
        this._currentElementDecl.setElementLocator(elementLocator);
        DocumentScannerScope documentScannerScope = (DocumentScannerScope)list.get(list.size() - 1);
        DocumentScannerScope documentScannerScope2 = new DocumentScannerScope(documentScannerScope.getNamespaceScope() + 1);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        LexerToken lexerToken2 = this._elementLexer.createLexerToken();
        this._elementLexer.setPosition(n);
        this._elementLexer.lex(lexerToken2);
        while (lexerToken2.getEndOffset() <= n2 && lexerToken2.getToken() != 0) {
            n5 = lexerToken2.getToken();
            n3 = lexerToken2.getStartOffset();
            n4 = lexerToken2.getEndOffset();
            this.parseElementToken(lexerToken2, this._currentElementDecl, namespaceDeclarations, documentScannerScope2, n3, n4);
            this._elementLexer.lex(lexerToken2);
        }
        if (this._currentElementDecl.getCurrentAttributeName() != null) {
            this.commitCurrentAttribute(this._currentElementDecl, namespaceDeclarations, documentScannerScope2);
        }
        ResolvedName resolvedName = this.createResolvedName(this._currentElementDecl.getRawElementName(), namespaceDeclarations, false);
        documentScannerScope2.setElementName(resolvedName);
        this.updateAttributeNames(resolvedName, this._currentElementDecl, namespaceDeclarations, documentScannerScope2);
        this.postProcessElement(resolvedName, this._currentElementDecl, namespaceDeclarations);
        if (this._currentElementDecl.isStartTag()) {
            if (this._currentElementDecl.isEndTag()) {
                this._handler.handleEmptyElement(resolvedName, this._currentElementDecl.getAttributeDeclarations(), this._currentElementDecl.getElementLocator());
                namespaceDeclarations.removeNamespaceDeclarations(documentScannerScope2.getNamespaceScope());
            } else {
                this._handler.handleStartElement(resolvedName, this._currentElementDecl.getAttributeDeclarations(), this._currentElementDecl.getElementLocator());
                list.add(documentScannerScope2);
            }
        } else if (this._currentElementDecl.isEndTag()) {
            if (this.caretInsideLocator(simpleLocator, this._caretPosition, bl)) {
                this._handler.handleEndElement(resolvedName, simpleLocator, bl);
            } else {
                DocumentScannerScope documentScannerScope3 = null;
                ResolvedName resolvedName2 = null;
                int n6 = list.size() - 1;
                while (n6 > 0) {
                    documentScannerScope3 = (DocumentScannerScope)list.get(n6);
                    resolvedName2 = documentScannerScope3.getElementName();
                    if (resolvedName2 != null && resolvedName2.matches(resolvedName)) break;
                    --n6;
                }
                if (n6 > 0) {
                    this.simulateEndElements(namespaceDeclarations, list, n6, simpleLocator.getStartOffset());
                    this._handler.handleEndElement(resolvedName, simpleLocator, true);
                    namespaceDeclarations.removeNamespaceDeclarations(documentScannerScope3.getNamespaceScope());
                    list.remove(n6);
                }
            }
        }
    }

    protected void parseElementName(LexerToken lexerToken, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope, int n, int n2) {
        elementDeclaration.setRawElementName(this.getStringValue(n, n2));
        SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
        elementDeclaration.getElementLocator().setNameLocator(simpleLocator);
    }

    protected void parseAttributeName(LexerToken lexerToken, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope, int n, int n2) {
        if (elementDeclaration.getCurrentAttributeName() != null) {
            this.commitCurrentAttribute(elementDeclaration, namespaceDeclarations, documentScannerScope);
        }
        elementDeclaration.setCurrentAttributeName(this.getStringValue(n, n2));
        elementDeclaration.setCurrentAttributeValue(null);
        SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
        AttributeLocator attributeLocator = this._manager.createAttributeLocator(simpleLocator);
        elementDeclaration.setCurrentAttributeLocator(attributeLocator);
    }

    protected void parseAttributeValue(LexerToken lexerToken, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope, int n, int n2) {
        AttributeLocator attributeLocator = elementDeclaration.getCurrentAttributeLocator();
        String string = this.parseAttributeValue(attributeLocator, n, n2);
        elementDeclaration.setCurrentAttributeValue(string);
    }

    protected String parseAttributeValue(AttributeLocator attributeLocator, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        short s = 2;
        short s2 = 3;
        if (n4 - n3 >= 1) {
            char c = this._buffer.getChar(n3);
            if (c == '\"') {
                s = 1;
            } else if (c == '\'') {
                s = 0;
            }
            if (s != 2) {
                s2 = 2;
                ++n3;
            }
        }
        if (n4 - n3 >= 1) {
            char c = this._buffer.getChar(n4 - 1);
            if (c == '\"') {
                if (s == 1) {
                    s2 = 0;
                } else if (s == 2) {
                    s = 1;
                    s2 = 1;
                }
            } else if (c == '\'') {
                if (s == 0) {
                    s2 = 0;
                } else if (s == 2) {
                    s = 0;
                    s2 = 1;
                }
            }
            if (s2 == 0 || s2 == 1) {
                --n4;
            }
        }
        StringAndLocator stringAndLocator = this.parseContentString(n3, n4, true);
        stringAndLocator.loc.attach(this._manager, false);
        ArrayList<SimpleLocator> arrayList = new ArrayList<SimpleLocator>(stringAndLocator.loc.getContentLocators());
        if (n != n3) {
            SimpleLocator simpleLocator = (SimpleLocator)arrayList.get(0);
            boolean bl = simpleLocator instanceof EntityRefLocator;
            if (simpleLocator.getStartOffset() == n3 && !bl) {
                simpleLocator.setStartOffset(n);
            } else {
                arrayList.add(0, this._manager.createSimpleLocator(n, n3));
            }
        }
        if (n2 != n4) {
            SimpleLocator simpleLocator = (SimpleLocator)arrayList.get(arrayList.size() - 1);
            boolean bl = simpleLocator instanceof EntityRefLocator;
            if (simpleLocator.getEndOffset() == n4 && !bl) {
                simpleLocator.setEndOffset(n2);
            } else {
                arrayList.add(this._manager.createSimpleLocator(n4, n2));
            }
        }
        TextLocator textLocator = this._manager.createTextLocator(arrayList, stringAndLocator.loc.getWhitespaceLocators());
        textLocator.attach(this._manager, true);
        if (attributeLocator != null) {
            attributeLocator.setValueLocator(textLocator);
            attributeLocator.setQuoteStyle(s);
            attributeLocator.setQuoteUsage(s2);
        }
        return stringAndLocator.str;
    }

    protected void parseSymbol(LexerToken lexerToken, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = this._buffer.getChar(n3);
            if (c == '/') {
                SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
                elementDeclaration.getElementLocator().setSlashLocator(simpleLocator);
                elementDeclaration.setEndTag(true);
                if (elementDeclaration.getRawElementName() != null) break;
                elementDeclaration.setStartTag(false);
                break;
            }
            if (c == '=') {
                SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
                AttributeLocator attributeLocator = elementDeclaration.getCurrentAttributeLocator();
                if (attributeLocator == null) break;
                attributeLocator.setEqualsLocator(simpleLocator);
                break;
            }
            ++n3;
        }
    }

    protected final void simulateEndElements(NamespaceDeclarations namespaceDeclarations, List list, int n, int n2) {
        DocumentScannerScope documentScannerScope = null;
        int n3 = list.size() - 1;
        while (n3 > n) {
            SimpleLocator simpleLocator = this._manager.createSimpleLocator(n2, n2);
            documentScannerScope = (DocumentScannerScope)list.get(n3);
            this._handler.handleEndElement(documentScannerScope.getElementName(), simpleLocator, true);
            namespaceDeclarations.removeNamespaceDeclarations(documentScannerScope.getNamespaceScope());
            list.remove(n3);
            --n3;
        }
    }

    protected void commitCurrentAttribute(ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope) {
        String string = elementDeclaration.getCurrentAttributeName();
        String string2 = elementDeclaration.getCurrentAttributeValue();
        AttributeLocator attributeLocator = elementDeclaration.getCurrentAttributeLocator();
        AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
        ResolvedName resolvedName = this.createResolvedName(string, namespaceDeclarations, true);
        attributeDeclarations.addAttributeDeclaration(resolvedName, string2, attributeLocator);
        this.postProcessAttribute(resolvedName, string2, namespaceDeclarations, documentScannerScope);
    }

    protected void parseText(LexerToken lexerToken) {
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        this.parseText(n, n2);
    }

    protected void parseText(int n, int n2) {
        StringAndLocator stringAndLocator = this.parseContentString(n, n2, false);
        this._handler.handleText(stringAndLocator.str, stringAndLocator.loc);
    }

    protected void parseComment(LexerToken lexerToken) {
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
        if (n2 - n >= 4 && this._buffer.getChar(n) == '<' && this._buffer.getChar(n + 1) == '!' && this._buffer.getChar(n + 2) == '-' && this._buffer.getChar(n + 3) == '-') {
            n += 4;
        }
        if (n2 - n >= 3 && this._buffer.getChar(n2 - 1) == '>' && this._buffer.getChar(n2 - 2) == '-' && this._buffer.getChar(n2 - 3) == '-') {
            n2 -= 3;
        }
        String string = this.getStringValue(n, n2);
        this._handler.handleComment(string, simpleLocator);
    }

    protected void parseDocumentType(LexerToken lexerToken, NamespaceDeclarations namespaceDeclarations, List list) {
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
        this._elementLexer.setPosition(n);
        LexerToken lexerToken2 = this._elementLexer.createLexerToken();
        this._elementLexer.lex(lexerToken2);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n3 = this.findNextTokenStart(n, n2);
        int n4 = this.findTokenEnd(n3, n2);
        this._elementLexer.setPosition(n4);
        while ((n3 = this.findNextTokenStart(n4, n2)) != -1) {
            this._elementLexer.setPosition(n3);
            switch (this.getBuffer().getChar(n3)) {
                case '\"': {
                    n4 = this.findNameOrValueTokenEnd(this._elementLexer);
                    String string5 = "";
                    if (n4 - n3 > 2) {
                        string5 = this.getStringValue(n3 + 1, n4 - 1);
                    }
                    if (string2 == null && bl) {
                        string2 = string5;
                        break;
                    }
                    string3 = string5;
                    break;
                }
                case '[': {
                    string4 = "";
                    if (n2 - n3 <= 3) break;
                    string4 = this.getStringValue(n3 + 1, n2 - 2);
                    break;
                }
                default: {
                    n4 = this.findNameOrValueTokenEnd(this._elementLexer);
                    String string5 = this.getStringValue(n3, n4);
                    if ("PUBLIC".equals(string5)) {
                        bl = true;
                        break;
                    }
                    if ("SYSTEM".equals(string5)) {
                        bl = false;
                        break;
                    }
                    if (string != null) break;
                    string = string5;
                }
            }
            this._elementLexer.setPosition(n4++);
        }
        ResolvedName resolvedName = this.createResolvedName(string, namespaceDeclarations, false);
        DocumentScannerScope documentScannerScope = (DocumentScannerScope)list.get(list.size() - 1);
        DocumentScannerScope documentScannerScope2 = new DocumentScannerScope(documentScannerScope.getNamespaceScope() + 1);
        this.handleDocumentType(namespaceDeclarations, documentScannerScope2, resolvedName, string2, string3, string4, simpleLocator);
    }

    protected void handleDocumentType(NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope, ResolvedName resolvedName, String string, String string2, String string3, SimpleLocator simpleLocator) {
        this._handler.handleDocumentType(resolvedName, string, string2, simpleLocator);
    }

    protected StringAndLocator parseContentString(int n, int n2, boolean bl) {
        TextLocator textLocator;
        String string;
        int n3 = n2 - n;
        if (n3 > 2) {
            ArrayList<SimpleLocator> arrayList = new ArrayList<SimpleLocator>();
            StringBuffer stringBuffer = new StringBuffer(n3);
            char[] cArray = this._buffer.getChars(n, n3);
            char[] cArray2 = this.getEntityStartCharacters(bl);
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = false;
            while (n5 < n3) {
                char c = cArray[n5];
                int n6 = 0;
                while (n6 < cArray2.length) {
                    if (c == cArray2[n6]) {
                        bl2 = true;
                        break;
                    }
                    ++n6;
                }
                if (bl2) {
                    bl2 = false;
                    int n7 = this.findEntityEnd(cArray, n5);
                    if (n7 >= n5) {
                        if (n5 != n4) {
                            stringBuffer.append(cArray, n4, n5 - n4);
                            arrayList.add(this._manager.createSimpleLocator(n + n4, n + n5));
                        }
                        int n8 = n7 - n5 + 1;
                        String string2 = new String(cArray, n5, n8);
                        String string3 = this.parseEntityReference(string2, bl);
                        stringBuffer.append(string3);
                        arrayList.add(this._manager.createEntityRefLocator(n + n5, n + n7 + 1, string2, string3, true));
                        n5 = n7;
                        n4 = n7 + 1;
                    }
                }
                ++n5;
            }
            if (n4 < n3) {
                stringBuffer.append(cArray, n4, n3 - n4);
                arrayList.add(this._manager.createSimpleLocator(n + n4, n + n3));
            }
            string = stringBuffer.toString();
            textLocator = this._manager.createTextLocator(arrayList);
        } else {
            string = this.getStringValue(n, n2);
            SimpleLocator simpleLocator = this._manager.createSimpleLocator(n, n2);
            textLocator = this._manager.createTextLocator(Collections.singletonList(simpleLocator));
        }
        return new StringAndLocator(string, textLocator);
    }

    protected char[] getEntityStartCharacters(boolean bl) {
        return _defaultEntityStartCharacters;
    }

    protected int findEntityEnd(char[] cArray, int n) {
        int n2 = -1;
        if (cArray[n] == '&') {
            int n3 = n + 1;
            while (n3 < cArray.length) {
                if (cArray[n3] == ';') {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    protected String parseEntityReference(String string, boolean bl) {
        String string2 = null;
        try {
            if (string.charAt(0) == '&') {
                String string3 = string.substring(1, string.length() - 1);
                if (string3.charAt(0) == '#') {
                    char c;
                    if (string3.charAt(1) == 'x') {
                        string3 = string3.substring(2);
                        c = (char)Integer.parseInt(string3, 16);
                    } else {
                        string3 = string3.substring(1);
                        c = (char)Integer.parseInt(string3, 10);
                    }
                    string2 = String.valueOf(c);
                } else {
                    string2 = this.getEntityReplacementText(string3);
                }
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    protected String getEntityReplacementText(String string) {
        String string2 = null;
        if (string != null) {
            string2 = (String)_predefinedEntities.get(string);
        }
        return string2;
    }

    protected abstract int findNameOrValueTokenEnd(Lexer var1);

    protected final String getStringValue(int n, int n2) {
        return new String(this._buffer.getChars(n, n2 - n));
    }

    protected final int findNextTokenStart(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = this._buffer.getChar(n3);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++n3;
                    break;
                }
                default: {
                    return n3;
                }
            }
        }
        return -1;
    }

    protected final int findTokenEnd(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = this._buffer.getChar(n3);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return n3;
                }
            }
            ++n3;
        }
        return n2;
    }

    protected final ReadTextBuffer getBuffer() {
        return this._buffer;
    }

    protected final LocatorManager getManager() {
        return this._manager;
    }

    protected final DocumentHandler getHandler() {
        return this._handler;
    }

    protected final Lexer getDocumentLexer() {
        return this._documentLexer;
    }

    protected final Lexer getElementLexer() {
        return this._elementLexer;
    }

    protected final int getCaretPosition() {
        return this._caretPosition;
    }

    protected final boolean caretInsideLocator(Locator locator, int n, boolean bl) {
        if (n > locator.getStartOffset()) {
            int n2 = locator.getEndOffset();
            if (bl ? n < n2 : n <= n2) {
                return true;
            }
        }
        return false;
    }

    void $init$() {
        this._buffer = null;
        this._handler = null;
        this._manager = null;
        this._documentLexer = null;
        this._elementLexer = null;
        this._currentElementDecl = null;
        this._reuseAttributeDecls = true;
        this._caretPosition = -1;
        this._stopRequested = false;
    }

    static {
        _predefinedEntities.put("amp", "&");
        _predefinedEntities.put("lt", "<");
        _predefinedEntities.put("gt", ">");
        _predefinedEntities.put("apos", "'");
        _predefinedEntities.put("quot", "\"");
        _defaultEntityStartCharacters = new char[]{'&'};
    }

    protected static final class StringAndLocator {
        public final String str;
        public final TextLocator loc;

        public StringAndLocator(String string, TextLocator textLocator) {
            this.str = string;
            this.loc = textLocator;
        }
    }
}

