/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;

public class NamespaceDeclarations {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final NamespaceDeclaration XML_NAMESPACE_DECL = new NamespaceDeclaration("http://www.w3.org/XML/1998/namespace", "xml", -1);
    public static final NamespaceDeclaration XMLNS_NAMESPACE_DECL = new NamespaceDeclaration("http://www.w3.org/2000/xmlns/", "xmlns", -1);
    private int _currentScope;
    private String _defaultNamespace;
    private HashMap _prefixMap;
    private ArrayList _declarations;

    public NamespaceDeclarations() {
        this.$init$();
        this._declarations = new ArrayList(16);
        this._prefixMap = new HashMap();
    }

    public void addNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration) {
        int n = namespaceDeclaration.getScope();
        if (this._currentScope > n) {
            throw new IllegalArgumentException("Cannot add a new NamespaceDeclaration with a scope less than the current scope");
        }
        this._declarations.add(namespaceDeclaration);
        this._currentScope = n;
        if (namespaceDeclaration.isDefault()) {
            this._defaultNamespace = namespaceDeclaration.getNamespace();
        } else if (namespaceDeclaration.getNamespace() != null) {
            this._prefixMap.put(namespaceDeclaration.getPrefix(), namespaceDeclaration);
        } else {
            this._prefixMap.remove(namespaceDeclaration.getPrefix());
        }
    }

    public void removeNamespaceDeclarations(int n) {
        if (n < this._currentScope) {
            throw new IllegalArgumentException("Cannot remove NamespaceDeclarations with a scope less than the currentscope");
        }
        NamespaceDeclaration namespaceDeclaration = null;
        int n2 = this._declarations.size() - 1;
        while (n2 >= 0) {
            namespaceDeclaration = (NamespaceDeclaration)this._declarations.get(n2);
            if (namespaceDeclaration.getScope() != n) break;
            this._declarations.remove(n2);
            --n2;
        }
        this._currentScope = this._declarations.size() > 0 ? namespaceDeclaration.getScope() : -1;
        this._resetDefaultAndMap();
    }

    public String getNamespaceForPrefix(String string) {
        String string2 = null;
        NamespaceDeclaration namespaceDeclaration = (NamespaceDeclaration)this._prefixMap.get(string);
        if (namespaceDeclaration != null) {
            string2 = namespaceDeclaration.getNamespace();
        }
        return string2;
    }

    public String getDefaultNamespace() {
        return this._defaultNamespace;
    }

    public int getCurrentScope() {
        return this._currentScope;
    }

    public Collection getPrefixDeclarations() {
        Collection collection = this._prefixMap.values();
        return Collections.unmodifiableCollection(collection);
    }

    private void _resetDefaultAndMap() {
        this._defaultNamespace = null;
        this._prefixMap.clear();
        NamespaceDeclaration namespaceDeclaration = null;
        int n = this._declarations.size();
        int n2 = 0;
        while (n2 < n) {
            namespaceDeclaration = (NamespaceDeclaration)this._declarations.get(n2);
            if (namespaceDeclaration.isDefault()) {
                this._defaultNamespace = namespaceDeclaration.getNamespace();
            } else if (namespaceDeclaration.getNamespace() != null) {
                this._prefixMap.put(namespaceDeclaration.getPrefix(), namespaceDeclaration);
            } else {
                this._prefixMap.remove(namespaceDeclaration.getPrefix());
            }
            ++n2;
        }
    }

    void $init$() {
        this._currentScope = -1;
        this._defaultNamespace = null;
        this._prefixMap = null;
        this._declarations = null;
    }
}

