/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.List;
import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTagLexer;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.DocumentScannerScope;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public class XmlDocumentScanner
extends DocumentScanner {
    public XmlDocumentScanner() {
        super((Lexer)new XMLLexer(), (Lexer)new XMLTagLexer());
    }

    protected boolean parseDocumentToken(LexerToken lexerToken, NamespaceDeclarations namespaceDeclarations, List list) {
        boolean bl = true;
        switch (lexerToken.getToken()) {
            case 11: {
                this.parseElement(lexerToken, namespaceDeclarations, list, true);
                break;
            }
            case 12: {
                this.parseElement(lexerToken, namespaceDeclarations, list, false);
                break;
            }
            case 16: {
                this.parseText(lexerToken);
                break;
            }
            case 13: {
                this.parseComment(lexerToken);
                break;
            }
            case 17: {
                this.parseCDATASection(lexerToken);
                break;
            }
            case 14: {
                this.parseDeclaration(lexerToken);
                break;
            }
            case 18: {
                this.parseDocumentType(lexerToken, namespaceDeclarations, list);
                break;
            }
            case 15: {
                this.parsePI(lexerToken);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected boolean parseElementToken(LexerToken lexerToken, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope, int n, int n2) {
        boolean bl = true;
        switch (lexerToken.getToken()) {
            case 21: {
                this.parseElementName(lexerToken, elementDeclaration, namespaceDeclarations, documentScannerScope, n, n2);
                break;
            }
            case 22: {
                this.parseAttributeName(lexerToken, elementDeclaration, namespaceDeclarations, documentScannerScope, n, n2);
                break;
            }
            case 23: {
                this.parseAttributeValue(lexerToken, elementDeclaration, namespaceDeclarations, documentScannerScope, n, n2);
                break;
            }
            case 24: {
                this.parseSymbol(lexerToken, elementDeclaration, namespaceDeclarations, documentScannerScope, n, n2);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected void addBuiltInNamespaceDeclarations(NamespaceDeclarations namespaceDeclarations) {
        namespaceDeclarations.addNamespaceDeclaration(NamespaceDeclarations.XML_NAMESPACE_DECL);
        namespaceDeclarations.addNamespaceDeclaration(NamespaceDeclarations.XMLNS_NAMESPACE_DECL);
    }

    protected int findNameOrValueTokenEnd(Lexer lexer) {
        int n;
        try {
            n = ((XMLTagLexer)lexer).skipNameOrValue(true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = this.getBuffer().getLength();
        }
        return n;
    }

    protected void postProcessAttribute(ResolvedName resolvedName, String string, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope) {
        if (string != null && "http://www.w3.org/2000/xmlns/".equals(resolvedName.getNamespace())) {
            String string2 = string;
            if (string2.length() == 0) {
                string2 = null;
            }
            NamespaceDeclaration namespaceDeclaration = null;
            String string3 = resolvedName.getLocalName();
            namespaceDeclaration = "xmlns".equals(string3) ? new NamespaceDeclaration(string2, documentScannerScope.getNamespaceScope()) : new NamespaceDeclaration(string2, string3, documentScannerScope.getNamespaceScope());
            namespaceDeclarations.addNamespaceDeclaration(namespaceDeclaration);
        }
    }

    protected final void updateAttributeNames(ResolvedName resolvedName, ElementDeclaration elementDeclaration, NamespaceDeclarations namespaceDeclarations, DocumentScannerScope documentScannerScope) {
        if (namespaceDeclarations.getCurrentScope() == documentScannerScope.getNamespaceScope()) {
            AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
            int n = attributeDeclarations.getLength();
            int n2 = 0;
            while (n2 < n) {
                ResolvedName resolvedName2 = attributeDeclarations.getResolvedName(n2);
                if (resolvedName2 != null) {
                    resolvedName2.updateAttributeResolvedName(namespaceDeclarations);
                }
                ++n2;
            }
        }
    }

    protected void parsePI(LexerToken lexerToken) {
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        ReadTextBuffer readTextBuffer = this.getBuffer();
        SimpleLocator simpleLocator = this.getManager().createSimpleLocator(n, n2);
        if (n2 - (n += 2) >= 1 && readTextBuffer.getChar(n2 - 1) == '>' && --n2 - n >= 1 && readTextBuffer.getChar(n2 - 1) == '?') {
            --n2;
        }
        String string = null;
        int n3 = this.findTokenEnd(n, n2);
        if (n3 - n > 0) {
            string = this.getStringValue(n, n3);
        }
        String string2 = null;
        int n4 = this.findNextTokenStart(n3, n2);
        if (n4 != -1 && n2 - n4 > 0) {
            string2 = this.getStringValue(n4, n2);
        }
        this.getHandler().handleProcessingInstruction(string, string2, simpleLocator);
    }

    protected void parseDeclaration(LexerToken lexerToken) {
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        SimpleLocator simpleLocator = this.getManager().createSimpleLocator(n, n2);
        DeclarationLocator declarationLocator = this.getManager().createDeclarationLocator(simpleLocator);
        String string = null;
        String string2 = null;
        AttributeLocator attributeLocator = null;
        Lexer lexer = this.getElementLexer();
        lexer.setPosition(n);
        LexerToken lexerToken2 = lexer.createLexerToken();
        lexer.lex(lexerToken2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (lexerToken2.getEndOffset() <= n2 && lexerToken2.getToken() != 0) {
            n5 = lexerToken2.getToken();
            n3 = lexerToken2.getStartOffset();
            n4 = lexerToken2.getEndOffset();
            if (lexerToken2.getToken() == 22) {
                if (string != null) {
                    if ("version".equals(string)) {
                        string3 = string2;
                        declarationLocator.setVersionLocator(attributeLocator);
                    } else if ("encoding".equals(string)) {
                        string4 = string2;
                        declarationLocator.setEncodingLocator(attributeLocator);
                    } else if ("standalone".equals(string)) {
                        string5 = string2;
                        declarationLocator.setStandaloneLocator(attributeLocator);
                    }
                }
                string = this.getStringValue(n3, n4);
                string2 = null;
                SimpleLocator simpleLocator2 = this.getManager().createSimpleLocator(n3, n4);
                attributeLocator = this.getManager().createAttributeLocator(simpleLocator2);
            } else if (lexerToken2.getToken() == 23) {
                string2 = this.parseAttributeValue(attributeLocator, n3, n4);
            }
            lexer.lex(lexerToken2);
        }
        if (string != null) {
            if ("version".equals(string)) {
                string3 = string2;
                declarationLocator.setVersionLocator(attributeLocator);
            } else if ("encoding".equals(string)) {
                string4 = string2;
                declarationLocator.setEncodingLocator(attributeLocator);
            } else if ("standalone".equals(string)) {
                string5 = string2;
                declarationLocator.setStandaloneLocator(attributeLocator);
            }
        }
        this.getHandler().handleXMLDeclaration(string3, string4, string5, declarationLocator);
    }

    protected void parseCDATASection(LexerToken lexerToken) {
        int n = lexerToken.getStartOffset();
        int n2 = lexerToken.getEndOffset();
        SimpleLocator simpleLocator = this.getManager().createSimpleLocator(n, n2);
        ReadTextBuffer readTextBuffer = this.getBuffer();
        if (n2 - (n += 9) >= 3 && readTextBuffer.getChar(n2 - 3) == ']' && readTextBuffer.getChar(n2 - 2) == ']' && readTextBuffer.getChar(n2 - 1) == '>') {
            n2 -= 3;
        }
        String string = this.getStringValue(n, n2);
        this.getHandler().handleCDATASection(string, simpleLocator);
    }
}

