/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

abstract class AttributeWrapper {
    private static final AttributeWrapper _WRAPPER_NONE = new 4();
    private static final AttributeWrapper _WRAPPER_AT_MARGIN_JUST_INDENTED = new 3();
    private static final AttributeWrapper _WRAPPER_AT_MARGIN_UNDER_FIRST_ATTR = new 2();
    private static final AttributeWrapper _WRAPPER_ALWAYS_JUST_INDENTED = new 1();

    public static AttributeWrapper get(TextSyncContext textSyncContext, Attr attr) {
        TextSyncOptions.AttributeWrapMode attributeWrapMode = textSyncContext.getOptions().getAttributeWrapMode(attr.getOwnerElement());
        if (attributeWrapMode == TextSyncOptions.ATTR_WRAP_NONE) {
            return _WRAPPER_NONE;
        }
        if (attributeWrapMode == TextSyncOptions.ATTR_WRAP_AT_MARGIN_JUST_INDENTED) {
            return _WRAPPER_AT_MARGIN_JUST_INDENTED;
        }
        if (attributeWrapMode == TextSyncOptions.ATTR_WRAP_AT_MARGIN_UNDER_FIRST_ATTR) {
            return _WRAPPER_AT_MARGIN_UNDER_FIRST_ATTR;
        }
        if (attributeWrapMode == TextSyncOptions.ATTR_WRAP_ALWAYS_JUST_INDENTED) {
            return _WRAPPER_ALWAYS_JUST_INDENTED;
        }
        throw new IllegalArgumentException("unknown wrap mode for " + attr + ": " + attributeWrapMode);
    }

    public abstract int getWrapColumn(TextSyncContext var1, Attr var2, Locator var3);

    private AttributeWrapper() {
    }

    AttributeWrapper(1 var1_1) {
        this();
    }

    AttributeWrapper(4 var1_1) {
        this();
    }

    private static abstract class AtMarginWrapper
    extends AttributeWrapper {
        public final int getWrapColumn(TextSyncContext textSyncContext, Attr attr, Locator locator) {
            ElementLocator elementLocator;
            Element element;
            int n;
            if (textSyncContext.isPastRightMargin(attr, locator) && (n = this.calculateDesiredColumn(textSyncContext, element = attr.getOwnerElement(), elementLocator = textSyncContext.getElementLocatorRequired(element), attr, locator)) < locator.getStartColumnNumber() - 1) {
                return n;
            }
            return -1;
        }

        protected abstract int calculateDesiredColumn(TextSyncContext var1, Element var2, ElementLocator var3, Attr var4, Locator var5);

        private AtMarginWrapper() {
            super((1)null);
        }

        AtMarginWrapper(3 var1_1) {
            this();
        }

        AtMarginWrapper(2 var1_1) {
            this();
        }
    }

    static final class 4
    extends AttributeWrapper {
        public int getWrapColumn(TextSyncContext textSyncContext, Attr attr, Locator locator) {
            return -1;
        }

        public 4() {
            super((4)null);
        }
    }

    static final class 3
    extends AtMarginWrapper {
        protected int calculateDesiredColumn(TextSyncContext textSyncContext, Element element, ElementLocator elementLocator, Attr attr, Locator locator) {
            return elementLocator.getStartColumnNumber() + textSyncContext.getModel().getIndentSize() - 1;
        }

        public 3() {
            super((3)null);
        }
    }

    static final class 2
    extends AtMarginWrapper {
        protected int calculateDesiredColumn(TextSyncContext textSyncContext, Element element, ElementLocator elementLocator, Attr attr, Locator locator) {
            return elementLocator.getNameLocator().getEndColumnNumber();
        }

        public 2() {
            super((2)null);
        }
    }

    static final class 1
    extends AttributeWrapper {
        public final int getWrapColumn(TextSyncContext textSyncContext, Attr attr, Locator locator) {
            Element element = attr.getOwnerElement();
            ElementLocator elementLocator = textSyncContext.getElementLocatorRequired(element);
            return elementLocator.getStartColumnNumber() - 1 + textSyncContext.getModel().getIndentSize();
        }

        public 1() {
            super((1)null);
        }
    }
}

