/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.textsync.BufferChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.javatools.buffer.TextBuffer;

public class InsertBufferChange
extends BufferChange {
    private final int _start;
    private final String _text;
    private static final Logger _LOGGER = Logger.getLogger(InsertBufferChange.class.getName());

    public InsertBufferChange(DomChange domChange, int n, String string) {
        super(domChange);
        this._start = n;
        this._text = string;
    }

    public void apply(TextBuffer textBuffer) {
        int n = this._text.length();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Insert {0} chars [{1}] at {2}", new Object[]{String.valueOf(n), this._text, String.valueOf(this._start)});
        }
        int n2 = textBuffer.getLength();
        textBuffer.insert(this._start, this._text.toCharArray());
        int n3 = textBuffer.getLength();
        int n4 = n3 - n2;
        if (n4 != n) {
            _LOGGER.log(Level.SEVERE, "Insertion did not change buffer length as expected! Locators are probably off. textLen={0} bufferSizeChange={1} text=[{2}]", new Object[]{String.valueOf(n), String.valueOf(n4), this._text});
        }
    }
}

