/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.textsync.ReformatInfo;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ReformatInfoTracker
implements DomChangeHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final ReformatInfo _result;
    private final TextSyncContext _context;

    public static ReformatInfo create(DomChange domChange, TextSyncContext textSyncContext) {
        ReformatInfoTracker reformatInfoTracker = new ReformatInfoTracker(textSyncContext);
        domChange.process(reformatInfoTracker);
        return reformatInfoTracker._result;
    }

    public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        this._result.addedAttrs.add(this._context.getEventAttr());
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
    }

    public void handleAttrValueChange(AttrValueChange attrValueChange) {
        this._result.addedAttrs.add(this._context.getEventAttr());
    }

    static {
        $assertionsDisabled = ReformatInfoTracker.class.desiredAssertionStatus() ^ true;
    }

    public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
        Node node = this._context.getEventTargetNode();
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        this._gatherInformationFromInsertedNode(node);
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
    }

    public void handleNodeValueChange(NodeValueChange nodeValueChange) {
    }

    private void _gatherInformationFromInsertedNode(Node node) {
        this._addAttrs(node);
        this._findInsertedTextNodes(node);
        this._checkForElementStartTagWrapping(node);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this._gatherInformationFromInsertedNode(node2);
            node2 = node2.getNextSibling();
        }
    }

    private void _checkForElementStartTagWrapping(Node node) {
        if (DomUtils.isElement((Node)node)) {
            Element element = (Element)node;
            if (this._context.getOptions().wrapBeforeEndOfStartTag(element)) {
                this._result.elementsToWrapStartTag.add(element);
            }
        }
    }

    private void _addAttrs(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                this._result.addedAttrs.add(namedNodeMap.item(n));
                ++n;
            }
        }
    }

    private void _findInsertedTextNodes(Node node) {
        if (DomUtils.isText((Node)node)) {
            this._result.insertedTextNodes.add(node);
        }
    }

    private ReformatInfoTracker(TextSyncContext textSyncContext) {
        this._context = textSyncContext;
        this._result = new ReformatInfo();
    }
}

