/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.AttributeWrapper;
import oracle.bali.xml.dom.buffer.textsync.ReformatInfo;
import oracle.bali.xml.dom.buffer.textsync.ReformatInfoTracker;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.util.CollectionUtils;
import oracle.javatools.buffer.TextBuffer;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Reformatter {
    private final Map _changeToInfo;
    private static final Logger _LOGGER = Logger.getLogger(Reformatter.class.getName());

    public void trackChange(DomChange domChange, TextSyncContext textSyncContext) {
        ReformatInfo reformatInfo = ReformatInfoTracker.create(domChange, textSyncContext);
        this._changeToInfo.put(domChange, reformatInfo);
    }

    public void untrackChange(DomChange domChange) {
        this._changeToInfo.remove(domChange);
    }

    public void reset() {
        this._changeToInfo.clear();
    }

    public void doReformatting(TextSyncContext textSyncContext, TextBuffer textBuffer) {
        block2: {
            try {
                this._wrapAttrs(textSyncContext, textBuffer);
                this._wrapInsertedTextNodes(textSyncContext, textBuffer);
                this._wrapEndOfStartTags(textSyncContext, textBuffer);
            }
            catch (Throwable throwable) {
                _LOGGER.log(Level.WARNING, "Exception during post-textsync formatting adjustment. Trying to continue.", throwable);
                if (!(throwable instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)throwable;
            }
        }
    }

    private void _wrapEndOfStartTags(TextSyncContext textSyncContext, TextBuffer textBuffer) {
        for (ReformatInfo reformatInfo : this._changeToInfo.values()) {
            this._wrapEndOfStartTags(textSyncContext, textBuffer, reformatInfo.elementsToWrapStartTag);
        }
    }

    private void _wrapEndOfStartTags(TextSyncContext textSyncContext, TextBuffer textBuffer, Set set) {
        if (!set.isEmpty()) {
            for (Element element : set) {
                this._wrapEndOfStartTag(textSyncContext, textBuffer, element);
            }
        }
    }

    private void _wrapEndOfStartTag(TextSyncContext textSyncContext, TextBuffer textBuffer, Element element) {
        ElementLocator elementLocator = textSyncContext.getElementLocator(element);
        if (elementLocator != null && elementLocator.isStartTagComplete()) {
            int n = elementLocator.getStartTagLocator().getEndOffset() - textSyncContext.getConfig().getStartTagEnd(element).length();
            int n2 = elementLocator.getStartColumnNumber() - 1 + textSyncContext.getModel().getIndentSize();
            char[] cArray = new char[n2 + 1];
            cArray[0] = 10;
            Arrays.fill(cArray, 1, cArray.length, ' ');
            textBuffer.insert(n, cArray);
            textSyncContext.noteCharactersAdded(n, cArray.length);
        }
    }

    private void _wrapInsertedTextNodes(TextSyncContext textSyncContext, TextBuffer textBuffer) {
        for (ReformatInfo reformatInfo : this._changeToInfo.values()) {
            this._wrapInsertedTextNodes(textSyncContext, textBuffer, reformatInfo.insertedTextNodes);
        }
    }

    private void _wrapInsertedTextNodes(TextSyncContext textSyncContext, TextBuffer textBuffer, Set set) {
        if (!set.isEmpty()) {
            for (Text text : set) {
                this._wrapSingleInsertedTextNode(textSyncContext, textBuffer, text);
            }
        }
    }

    private void _wrapSingleInsertedTextNode(TextSyncContext textSyncContext, TextBuffer textBuffer, Text text) {
        String string = text.getNodeValue();
        if (string == null) {
            return;
        }
        int n = string.length();
        TextLocator textLocator = (TextLocator)textSyncContext.getLocator(text);
        if (textLocator == null || n < 3) {
            return;
        }
        WhitespaceMode whitespaceMode = textSyncContext.getElementContentWhitespaceMode((Element)text.getParentNode());
        int n2 = -1;
        TextLocator textLocator2 = textLocator;
        LinkedList<TNRData> linkedList = new LinkedList<TNRData>();
        int n3 = 1;
        while (n3 < n - 1) {
            char c = string.charAt(n3);
            if (c == ' ' || c == '\t') {
                n2 = n3;
            } else if (n2 > -1) {
                int n4 = textLocator2.getContentTextOffset(n3);
                int n5 = Locator.getColumnNumber(textBuffer.getLineMap(), n4);
                if (n5 >= 0 && textSyncContext.isPastRightMargin(n5)) {
                    TNRData tNRData;
                    DomPosition domPosition = DomPositionFactory.createTextPosition((CharacterData)text, (int)n2);
                    Boolean bl = whitespaceMode.allowsAddingExtraWhitespace(domPosition);
                    if (!Boolean.FALSE.equals(bl) && (tNRData = this._doTextNodeWrap(textSyncContext, textBuffer, textLocator2, n2)) != null) {
                        textLocator2 = tNRData.newLocator;
                        linkedList.add(tNRData);
                    }
                    n2 = -1;
                }
            }
            ++n3;
        }
        if (!linkedList.isEmpty()) {
            textSyncContext.detachLocator(textLocator);
            textSyncContext.simpleMapNodeToLocator(text, null, textLocator);
            for (TNRData tNRData : linkedList) {
                textSyncContext.noteCharactersAdded(tNRData.wsBufferOffset, tNRData.indentationLevel);
            }
            textSyncContext.attachLocator(textLocator2);
            textSyncContext.simpleMapNodeToLocator(text, textLocator2, null);
        }
    }

    private TNRData _doTextNodeWrap(TextSyncContext textSyncContext, TextBuffer textBuffer, TextLocator textLocator, int n) {
        int n2;
        int n3 = textLocator.getContentTextOffset(n);
        int n4 = Locator.getColumnNumber(textBuffer.getLineMap(), n3);
        if (n4 <= (n2 = textLocator.getStartColumnNumber())) {
            return null;
        }
        if (n2 == 0) {
            textBuffer.remove(n3, 1);
            textBuffer.insert(n3, new char[]{'\n'});
            return new TNRData(n3, 0, textLocator);
        }
        List list = TextLocator.copyLocatorList(textLocator.getContentLocators());
        ArrayList<SimpleLocator> arrayList = TextLocator.copyLocatorList(textLocator.getWhitespaceLocators());
        int n5 = n3 + 1;
        boolean bl = TextSyncUtils.splitLocatorList(list, new int[]{n5});
        if (!bl) {
            return null;
        }
        char[] cArray = new char[n2];
        cArray[0] = 10;
        Arrays.fill(cArray, 1, cArray.length, ' ');
        textBuffer.remove(n3, 1);
        textBuffer.insert(n3, cArray);
        int n6 = n3 + 1;
        int n7 = cArray.length - 1;
        SimpleLocator simpleLocator = textSyncContext.createSimpleLocator(n6, n7);
        TextSyncUtils.adjustLocatorsForAddition(list, n6, n7);
        TextSyncUtils.adjustLocatorsForAddition(arrayList, n6, n7);
        if (CollectionUtils.isUnmodifiableList(arrayList, 0)) {
            ArrayList<SimpleLocator> arrayList2 = new ArrayList<SimpleLocator>(arrayList.size() + 1);
            arrayList2.addAll(arrayList);
            arrayList = arrayList2;
        }
        arrayList.add(simpleLocator);
        TextLocator textLocator2 = textSyncContext.createTextLocator(list, arrayList);
        return new TNRData(n6, n7, textLocator2);
    }

    private void _wrapAttrs(TextSyncContext textSyncContext, TextBuffer textBuffer) {
        SortedMap sortedMap = this._getAttrToLocator(textSyncContext);
        for (Map.Entry entry : sortedMap.entrySet()) {
            this._wrapSingleAttr(textSyncContext, textBuffer, (Attr)entry.getKey(), (Locator)entry.getValue());
        }
    }

    private void _wrapSingleAttr(TextSyncContext textSyncContext, TextBuffer textBuffer, Attr attr, Locator locator) {
        int n = AttributeWrapper.get(textSyncContext, attr).getWrapColumn(textSyncContext, attr, locator);
        if (n > 0) {
            int n2 = locator.getStartOffset();
            int n3 = this._getPrecedingSpaces(textBuffer, n2 - 1);
            int n4 = n2 - n3;
            textBuffer.remove(n4, n3);
            int n5 = n + 1;
            char[] cArray = new char[n5];
            cArray[0] = 10;
            Arrays.fill(cArray, 1, cArray.length, ' ');
            textBuffer.insert(n4, cArray);
            int n6 = n5 - n3;
            if (n6 > 0) {
                textSyncContext.noteCharactersAdded(n4, n6);
            } else {
                textSyncContext.noteCharactersRemoved(n4, -n6);
            }
        }
    }

    private int _getPrecedingSpaces(TextBuffer textBuffer, int n) {
        int n2 = 0;
        while (n > 0) {
            char c = textBuffer.getChar(n);
            if (!WhitespaceUtils.isXmlWhitespaceChar(c)) break;
            ++n2;
            --n;
        }
        return n2;
    }

    private SortedMap _getAttrToLocator(TextSyncContext textSyncContext) {
        HashSet hashSet = new HashSet();
        for (ReformatInfo reformatInfo : this._changeToInfo.values()) {
            hashSet.addAll(reformatInfo.addedAttrs);
        }
        return textSyncContext.getSortedNodeToLocatorMap(hashSet);
    }

    void $init$() {
        this._changeToInfo = new HashMap(23);
    }

    public Reformatter() {
        this.$init$();
    }

    private static class TNRData {
        public final int wsBufferOffset;
        public final int indentationLevel;
        public final TextLocator newLocator;

        public TNRData(int n, int n2, TextLocator textLocator) {
            this.wsBufferOffset = n;
            this.indentationLevel = n2;
            this.newLocator = textLocator;
        }
    }
}

