/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.ref.NodeRef;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextSyncUtils {
    public static void adjustLocatorsForAddition(List list, int n, int n2) {
        for (SimpleLocator simpleLocator : list) {
            if (simpleLocator.getStartOffset() < n) continue;
            simpleLocator.move(n2);
        }
    }

    public static boolean updateWhitespaceLocatorsForRemoval(List list, int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        int n3 = n + n2;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SimpleLocator simpleLocator = (SimpleLocator)iterator.next();
            int n4 = simpleLocator.getStartOffset();
            int n5 = simpleLocator.getEndOffset();
            if (n5 <= n) continue;
            if (n4 >= n3) {
                simpleLocator.setStartOffset(n4 - n2);
                simpleLocator.setEndOffset(n5 - n2);
                continue;
            }
            if (n <= n4 && n3 >= n5) {
                iterator.remove();
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean splitLocatorList(List list, int[] nArray) {
        ListIterator<SimpleLocator> listIterator = list.listIterator();
        int n = nArray.length;
        int n2 = 0;
        while (listIterator.hasNext()) {
            SimpleLocator simpleLocator = (SimpleLocator)listIterator.next();
            int n3 = simpleLocator.getStartOffset();
            int n4 = simpleLocator.getEndOffset();
            boolean bl = simpleLocator instanceof EntityRefLocator;
            int n5 = n2;
            while (n5 < n) {
                int n6 = nArray[n5];
                if (simpleLocator.containsNotAtStart(n6)) {
                    if (bl) {
                        return false;
                    }
                    n2 = n5 + 1;
                    SimpleLocator simpleLocator2 = (SimpleLocator)simpleLocator.getCopy();
                    simpleLocator.setEndOffset(n6);
                    simpleLocator2.setStartOffset(n6);
                    listIterator.add(simpleLocator2);
                    simpleLocator = simpleLocator2;
                }
                ++n5;
            }
        }
        return true;
    }

    public static void minimizeNumberOfLocators(List list) {
        Iterator iterator = list.iterator();
        SimpleLocator simpleLocator = null;
        while (iterator.hasNext()) {
            SimpleLocator simpleLocator2 = (SimpleLocator)iterator.next();
            boolean bl = simpleLocator2 instanceof EntityRefLocator;
            if (bl) {
                simpleLocator = null;
                continue;
            }
            if (simpleLocator != null && simpleLocator.getEndOffset() == simpleLocator2.getStartOffset()) {
                iterator.remove();
                simpleLocator.setEndOffset(simpleLocator2.getEndOffset());
                continue;
            }
            simpleLocator = simpleLocator2;
        }
    }

    public static void debugRootLocator(BufferDomModel bufferDomModel, Logger logger) {
        if (logger.isLoggable(Level.FINEST)) {
            Element element = bufferDomModel.getDocument().getDocumentElement();
            String string = element == null ? "null" : String.valueOf(bufferDomModel.getLocator(element));
            logger.log(Level.FINEST, "Root node {0} has locator {1}", new Object[]{element, string});
        }
    }

    public static Node getNode(DomModel domModel, NodeRef nodeRef) {
        Node node = nodeRef.getCorrespondingNode(domModel.getDocument());
        if (node == null) {
            throw new IllegalStateException("null node for ref " + nodeRef);
        }
        return node;
    }

    private TextSyncUtils() {
    }
}

